/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.ManyIndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.NoneIndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.SingleIndexProperties;
import org.optaplanner.constraint.streams.bi.DefaultBiJoiner;
import org.optaplanner.constraint.streams.common.AbstractJoiner;
import org.optaplanner.constraint.streams.tri.DefaultTriJoiner;

public final class JoinerUtils {
    private static final NoneIndexProperties NONE_INDEX_PROPERTY = NoneIndexProperties.INSTANCE;

    private JoinerUtils() {
    }

    public static <A, B> Function<A, IndexProperties> combineLeftMappings(DefaultBiJoiner<A, B> joiner) {
        int joinerCount = joiner.getJoinerCount();
        if (joinerCount == 0) {
            return a -> NONE_INDEX_PROPERTY;
        }
        if (joinerCount == 1) {
            Function mapping = joiner.getLeftMapping(0);
            return a -> new SingleIndexProperties(mapping.apply(a));
        }
        return a -> {
            Object[] mappings = new Object[joinerCount];
            for (int i = 0; i < joinerCount; ++i) {
                mappings[i] = joiner.getLeftMapping(i).apply(a);
            }
            return new ManyIndexProperties(mappings);
        };
    }

    public static <A, B, C> BiFunction<A, B, IndexProperties> combineLeftMappings(DefaultTriJoiner<A, B, C> joiner) {
        int joinerCount = joiner.getJoinerCount();
        if (joinerCount == 0) {
            return (a, b) -> NONE_INDEX_PROPERTY;
        }
        if (joinerCount == 1) {
            BiFunction mapping = joiner.getLeftMapping(0);
            return (a, b) -> new SingleIndexProperties(mapping.apply(a, b));
        }
        return (a, b) -> {
            Object[] mappings = new Object[joinerCount];
            for (int i = 0; i < joinerCount; ++i) {
                mappings[i] = joiner.getLeftMapping(i).apply(a, b);
            }
            return new ManyIndexProperties(mappings);
        };
    }

    public static <Right_> Function<Right_, IndexProperties> combineRightMappings(AbstractJoiner<Right_> joiner) {
        int joinerCount = joiner.getJoinerCount();
        if (joinerCount == 0) {
            return x -> NONE_INDEX_PROPERTY;
        }
        if (joinerCount == 1) {
            Function mapping = joiner.getRightMapping(0);
            return x -> new SingleIndexProperties(mapping.apply(x));
        }
        return x -> {
            Object[] mappings = new Object[joinerCount];
            for (int i = 0; i < joinerCount; ++i) {
                mappings[i] = joiner.getRightMapping(i).apply(x);
            }
            return new ManyIndexProperties(mappings);
        };
    }
}

