/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.tri;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.bi.BiTuple;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.tri.TriTuple;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public final class JoinTriNode<A, B, C>
extends AbstractNode {
    private final BiFunction<A, B, IndexProperties> mappingAB;
    private final Function<C, IndexProperties> mappingC;
    private final int inputStoreIndexAB;
    private final int inputStoreIndexC;
    private final Consumer<TriTuple<A, B, C>> nextNodesInsert;
    private final Consumer<TriTuple<A, B, C>> nextNodesRetract;
    private final int outputStoreSize;
    private final Indexer<BiTuple<A, B>, Map<UniTuple<C>, TriTuple<A, B, C>>> indexerAB;
    private final Indexer<UniTuple<C>, Map<BiTuple<A, B>, TriTuple<A, B, C>>> indexerC;
    private final Queue<TriTuple<A, B, C>> dirtyTupleQueue;

    public JoinTriNode(BiFunction<A, B, IndexProperties> mappingAB, Function<C, IndexProperties> mappingC, int inputStoreIndexAB, int inputStoreIndexC, Consumer<TriTuple<A, B, C>> nextNodesInsert, Consumer<TriTuple<A, B, C>> nextNodesRetract, int outputStoreSize, Indexer<BiTuple<A, B>, Map<UniTuple<C>, TriTuple<A, B, C>>> indexerAB, Indexer<UniTuple<C>, Map<BiTuple<A, B>, TriTuple<A, B, C>>> indexerC) {
        this.mappingAB = mappingAB;
        this.mappingC = mappingC;
        this.inputStoreIndexAB = inputStoreIndexAB;
        this.inputStoreIndexC = inputStoreIndexC;
        this.nextNodesInsert = nextNodesInsert;
        this.nextNodesRetract = nextNodesRetract;
        this.outputStoreSize = outputStoreSize;
        this.indexerAB = indexerAB;
        this.indexerC = indexerC;
        this.dirtyTupleQueue = new ArrayDeque<TriTuple<A, B, C>>(1000);
    }

    public void insertAB(BiTuple<A, B> tupleAB) {
        if (tupleAB.store[this.inputStoreIndexAB] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tupleAB + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingAB.apply(tupleAB.factA, tupleAB.factB);
        tupleAB.store[this.inputStoreIndexAB] = indexProperties;
        HashMap tupleABCMapAB = new HashMap();
        this.indexerAB.put(indexProperties, tupleAB, tupleABCMapAB);
        this.indexerC.visit(indexProperties, (tupleC, tupleABCMapC) -> {
            TriTuple tupleABC = new TriTuple(tupleAB.factA, tupleAB.factB, tupleC.factA, this.outputStoreSize);
            tupleABC.state = BavetTupleState.CREATING;
            tupleABCMapAB.put(tupleC, tupleABC);
            tupleABCMapC.put(tupleAB, tupleABC);
            this.dirtyTupleQueue.add(tupleABC);
        });
    }

    public void retractAB(BiTuple<A, B> tupleAB) {
        IndexProperties indexProperties = (IndexProperties)tupleAB.store[this.inputStoreIndexAB];
        if (indexProperties == null) {
            return;
        }
        tupleAB.store[this.inputStoreIndexAB] = null;
        this.indexerAB.remove(indexProperties, tupleAB);
        this.indexerC.visit(indexProperties, (tupleC, tupleABCMapC) -> {
            TriTuple tupleABC = (TriTuple)tupleABCMapC.remove(tupleAB);
            if (tupleABC == null) {
                throw new IllegalStateException("Impossible state: the tuple (" + tupleAB + ") with indexProperties (" + indexProperties + ") has tuples on the AB side that didn't exist on the C side.");
            }
            this.killTuple(tupleABC);
        });
    }

    public void insertC(UniTuple<C> tupleC) {
        if (tupleC.store[this.inputStoreIndexC] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tupleC + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingC.apply(tupleC.factA);
        tupleC.store[this.inputStoreIndexC] = indexProperties;
        HashMap tupleABCMapC = new HashMap();
        this.indexerC.put(indexProperties, tupleC, tupleABCMapC);
        this.indexerAB.visit(indexProperties, (tupleAB, tupleABCMapAB) -> {
            TriTuple tupleABC = new TriTuple(tupleAB.factA, tupleAB.factB, tupleC.factA, this.outputStoreSize);
            tupleABC.state = BavetTupleState.CREATING;
            tupleABCMapC.put(tupleAB, tupleABC);
            tupleABCMapAB.put(tupleC, tupleABC);
            this.dirtyTupleQueue.add(tupleABC);
        });
    }

    public void retractC(UniTuple<C> tupleC) {
        IndexProperties indexProperties = (IndexProperties)tupleC.store[this.inputStoreIndexC];
        if (indexProperties == null) {
            return;
        }
        tupleC.store[this.inputStoreIndexC] = null;
        this.indexerC.remove(indexProperties, tupleC);
        this.indexerAB.visit(indexProperties, (tupleAB, tupleABCMapAB) -> {
            TriTuple tupleABC = (TriTuple)tupleABCMapAB.remove(tupleC);
            if (tupleABC == null) {
                throw new IllegalStateException("Impossible state: the tuple (" + tupleAB + ") with indexProperties (" + indexProperties + ") has tuples on the C side that didn't exist on the AB side.");
            }
            this.killTuple(tupleABC);
        });
    }

    private void killTuple(TriTuple<A, B, C> tupleABC) {
        block6: {
            block5: {
                if (!tupleABC.state.isDirty()) break block5;
                switch (tupleABC.state) {
                    case CREATING: {
                        tupleABC.state = BavetTupleState.ABORTING;
                        break block6;
                    }
                    case UPDATING: {
                        tupleABC.state = BavetTupleState.DYING;
                        break block6;
                    }
                    case DYING: {
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException("Impossible state: The tuple (" + tupleABC.factA + ") has the dirty state (" + tupleABC.state + ").");
                    }
                }
            }
            tupleABC.state = BavetTupleState.DYING;
            this.dirtyTupleQueue.add(tupleABC);
        }
    }

    @Override
    public void calculateScore() {
        this.dirtyTupleQueue.forEach(tuple -> {
            if (tuple.state == BavetTupleState.UPDATING || tuple.state == BavetTupleState.DYING) {
                this.nextNodesRetract.accept((TriTuple<A, B, C>)tuple);
            }
            if (tuple.state == BavetTupleState.CREATING || tuple.state == BavetTupleState.UPDATING) {
                this.nextNodesInsert.accept((TriTuple<A, B, C>)tuple);
            }
            switch (tuple.state) {
                case CREATING: 
                case UPDATING: {
                    tuple.state = BavetTupleState.OK;
                    return;
                }
                case DYING: 
                case ABORTING: {
                    tuple.state = BavetTupleState.DEAD;
                    return;
                }
                case DEAD: {
                    throw new IllegalStateException("Impossible state: The tuple (" + tuple + ") in node (" + this + ") is already in the dead state (" + tuple.state + ").");
                }
            }
            throw new IllegalStateException("Impossible state: The tuple (" + tuple + ") in node (" + this + ") is in an unexpected state (" + tuple.state + ").");
        });
        this.dirtyTupleQueue.clear();
    }

    public String toString() {
        return "JoinTriNode";
    }
}

