/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.core.base.CoreComponentsBuilder;
import org.drools.core.base.XMLSupport;

public class Drools {
    private static final boolean IS_NATIVE_IMAGE;
    private static Pattern VERSION_PAT;
    private static String droolsFullVersion;
    private static int droolsMajorVersion;
    private static int droolsMinorVersion;
    private static int droolsRevisionVersion;
    private static String droolsRevisionClassifier;
    private static boolean jmxAvailable;
    private static boolean jndiAvailable;

    public static String getFullVersion() {
        return droolsFullVersion;
    }

    public static int getMajorVersion() {
        return droolsMajorVersion;
    }

    public static int getMinorVersion() {
        return droolsMinorVersion;
    }

    public static int getRevisionVersion() {
        return droolsRevisionVersion;
    }

    public static String getRevisionClassifier() {
        return droolsRevisionClassifier;
    }

    public static boolean isCompatible(int major, int minor, int revision) {
        if (major != droolsMajorVersion) {
            return false;
        }
        return minor == 0 ? droolsMinorVersion == 0 : droolsMinorVersion > 0;
    }

    public static boolean isJmxAvailable() {
        return jmxAvailable;
    }

    public static boolean isJndiAvailable() {
        return jndiAvailable;
    }

    public static boolean hasMvel() {
        return CoreComponentsBuilder.present();
    }

    public static boolean hasXmlSupport() {
        return XMLSupport.present();
    }

    public static boolean isNativeImage() {
        return IS_NATIVE_IMAGE;
    }

    static {
        Matcher m;
        IS_NATIVE_IMAGE = System.getProperty("org.graalvm.nativeimage.imagecode") != null;
        VERSION_PAT = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)([\\.-](.*))?");
        droolsFullVersion = Drools.class.getPackage().getImplementationVersion();
        if (droolsFullVersion == null || droolsFullVersion.equals("0.0")) {
            try (InputStream is = Drools.class.getClassLoader().getResourceAsStream("drools.versions.properties");){
                Properties properties = new Properties();
                properties.load(is);
                droolsFullVersion = properties.get("drools.version").toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ((m = VERSION_PAT.matcher(droolsFullVersion)).matches()) {
            droolsMajorVersion = Integer.parseInt(m.group(1));
            droolsMinorVersion = Integer.parseInt(m.group(2));
            droolsRevisionVersion = Integer.parseInt(m.group(3));
            droolsRevisionClassifier = m.group(5);
        }
        try {
            Class.forName("java.lang.management.ManagementFactory");
            jmxAvailable = true;
        }
        catch (Throwable t) {
            jmxAvailable = false;
        }
        try {
            Class.forName("javax.naming.InitialContext");
            jndiAvailable = true;
        }
        catch (Throwable t) {
            jndiAvailable = false;
        }
    }
}

