/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.audit;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.kiesession.audit.LogEvent;

public class RuleBaseLogEvent
extends LogEvent {
    private String packageName;
    private String ruleName;

    public RuleBaseLogEvent(int type, String packageName, String ruleName) {
        super(type);
        this.packageName = packageName;
        this.ruleName = ruleName;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.packageName = (String)in.readObject();
        this.ruleName = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.packageName);
        out.writeObject(this.ruleName);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String toString() {
        String msg = null;
        switch (this.getType()) {
            case 16: {
                msg = "BEFORE PACKAGE ADDED";
                break;
            }
            case 17: {
                msg = "AFTER PACKAGE ADDED";
                break;
            }
            case 18: {
                msg = "BEFORE PACKAGE REMOVED";
                break;
            }
            case 19: {
                msg = "AFTER PACKAGE REMOVED";
                break;
            }
            case 20: {
                msg = "BEFORE RULE ADDED";
                break;
            }
            case 21: {
                msg = "AFTER RULE ADDED";
                break;
            }
            case 22: {
                msg = "BEFORE RULE REMOVED";
                break;
            }
            case 23: {
                msg = "AFTER RULE REMOVED";
            }
        }
        String ruleMsg = "";
        if (this.ruleName != null) {
            ruleMsg = " rule: \"" + this.ruleName + "\"";
        }
        return msg + " package: \"" + this.packageName + "\"" + ruleMsg;
    }
}

