/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.LeftTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.RightTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public abstract class AbstractJoinNode<LeftTuple_ extends Tuple, Right_, OutTuple_ extends Tuple>
extends AbstractNode
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final Function<Right_, IndexProperties> mappingRight;
    private final int inputStoreIndexLeft;
    private final int inputStoreIndexRight;
    private final TupleLifecycle<OutTuple_> nextNodesTupleLifecycle;
    private final Indexer<LeftTuple_, Map<UniTuple<Right_>, OutTuple_>> indexerLeft;
    private final Indexer<UniTuple<Right_>, Map<LeftTuple_, OutTuple_>> indexerRight;
    private final Queue<OutTuple_> dirtyTupleQueue;

    protected AbstractJoinNode(Function<Right_, IndexProperties> mappingRight, int inputStoreIndexLeft, int inputStoreIndexRight, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, Indexer<LeftTuple_, Map<UniTuple<Right_>, OutTuple_>> indexerLeft, Indexer<UniTuple<Right_>, Map<LeftTuple_, OutTuple_>> indexerRight) {
        this.mappingRight = mappingRight;
        this.inputStoreIndexLeft = inputStoreIndexLeft;
        this.inputStoreIndexRight = inputStoreIndexRight;
        this.nextNodesTupleLifecycle = nextNodesTupleLifecycle;
        this.indexerLeft = indexerLeft;
        this.indexerRight = indexerRight;
        this.dirtyTupleQueue = new ArrayDeque<OutTuple_>(1000);
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        Object[] tupleStore = leftTuple.getStore();
        if (tupleStore[this.inputStoreIndexLeft] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + leftTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.createIndexPropertiesLeft(leftTuple);
        tupleStore[this.inputStoreIndexLeft] = indexProperties;
        HashMap outTupleMapLeft = new HashMap();
        this.indexLeftTuple(leftTuple, indexProperties, outTupleMapLeft);
    }

    private void indexLeftTuple(LeftTuple_ leftTuple, IndexProperties newIndexProperties, Map<UniTuple<Right_>, OutTuple_> outTupleMapLeft) {
        this.indexerLeft.put(newIndexProperties, leftTuple, outTupleMapLeft);
        this.indexerRight.visit(newIndexProperties, (rightTuple, emptyMap) -> {
            OutTuple_ outTuple = this.createOutTuple(leftTuple, (UniTuple<Right_>)rightTuple);
            outTuple.setState(BavetTupleState.CREATING);
            outTupleMapLeft.put((UniTuple<Right_>)rightTuple, outTuple);
            this.dirtyTupleQueue.add(outTuple);
        });
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        Object[] tupleStore = leftTuple.getStore();
        IndexProperties oldIndexProperties = (IndexProperties)tupleStore[this.inputStoreIndexLeft];
        if (oldIndexProperties == null) {
            this.insertLeft(leftTuple);
            return;
        }
        IndexProperties newIndexProperties = this.createIndexPropertiesLeft(leftTuple);
        if (oldIndexProperties.equals(newIndexProperties)) {
            Map<UniTuple<Right_>, OutTuple_> outTupleMapLeft = this.indexerLeft.get(oldIndexProperties, leftTuple);
            for (Tuple outTuple : outTupleMapLeft.values()) {
                this.updateOutTupleLeft(outTuple, leftTuple);
                this.updateTuple(outTuple);
            }
        } else {
            Map<UniTuple<Right_>, OutTuple_> outTupleMapLeft = this.indexerLeft.remove(oldIndexProperties, leftTuple);
            for (Tuple outTuple : outTupleMapLeft.values()) {
                this.retractTuple(outTuple);
            }
            outTupleMapLeft.clear();
            tupleStore[this.inputStoreIndexLeft] = newIndexProperties;
            this.indexLeftTuple(leftTuple, newIndexProperties, outTupleMapLeft);
        }
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        Object[] tupleStore = leftTuple.getStore();
        IndexProperties indexProperties = (IndexProperties)tupleStore[this.inputStoreIndexLeft];
        if (indexProperties == null) {
            return;
        }
        tupleStore[this.inputStoreIndexLeft] = null;
        Map<UniTuple<Right_>, OutTuple_> outTupleMapLeft = this.indexerLeft.remove(indexProperties, leftTuple);
        for (Tuple outTuple : outTupleMapLeft.values()) {
            this.retractTuple(outTuple);
        }
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.store[this.inputStoreIndexRight] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + rightTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingRight.apply(rightTuple.factA);
        rightTuple.store[this.inputStoreIndexRight] = indexProperties;
        this.indexRightTuple(rightTuple, indexProperties);
    }

    private void indexRightTuple(UniTuple<Right_> rightTuple, IndexProperties indexProperties) {
        this.indexerRight.put(indexProperties, rightTuple, Collections.emptyMap());
        this.indexerLeft.visit(indexProperties, (leftTuple, outTupleMapLeft) -> {
            OutTuple_ outTuple = this.createOutTuple(leftTuple, rightTuple);
            outTuple.setState(BavetTupleState.CREATING);
            outTupleMapLeft.put(rightTuple, outTuple);
            this.dirtyTupleQueue.add(outTuple);
        });
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        IndexProperties oldIndexProperties = (IndexProperties)rightTuple.store[this.inputStoreIndexRight];
        if (oldIndexProperties == null) {
            this.insertRight(rightTuple);
            return;
        }
        IndexProperties newIndexProperties = this.mappingRight.apply(rightTuple.factA);
        if (oldIndexProperties.equals(newIndexProperties)) {
            this.indexerLeft.visit(oldIndexProperties, (leftTuple, outTupleMapLeft) -> {
                Tuple outTuple = (Tuple)outTupleMapLeft.get(rightTuple);
                this.updateOutTupleRight(outTuple, rightTuple);
                if (outTuple == null) {
                    throw new IllegalStateException("Impossible state: the tuple (" + leftTuple + ") with indexProperties (" + oldIndexProperties + ") has tuples on the right side that didn't exist on the left side.");
                }
                this.updateTuple(outTuple);
            });
        } else {
            this.deindexRightTuple(oldIndexProperties, rightTuple);
            rightTuple.store[this.inputStoreIndexRight] = newIndexProperties;
            this.indexRightTuple(rightTuple, newIndexProperties);
        }
    }

    private void deindexRightTuple(IndexProperties indexProperties, UniTuple<Right_> rightTuple) {
        this.indexerRight.remove(indexProperties, rightTuple);
        this.indexerLeft.visit(indexProperties, (leftTuple, outTupleMapLeft) -> {
            Tuple outTuple = (Tuple)outTupleMapLeft.remove(rightTuple);
            if (outTuple == null) {
                throw new IllegalStateException("Impossible state: the tuple (" + leftTuple + ") with indexProperties (" + indexProperties + ") has tuples on the right side that didn't exist on the left side.");
            }
            this.retractTuple(outTuple);
        });
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        IndexProperties indexProperties = (IndexProperties)rightTuple.store[this.inputStoreIndexRight];
        if (indexProperties == null) {
            return;
        }
        rightTuple.store[this.inputStoreIndexRight] = null;
        this.deindexRightTuple(indexProperties, rightTuple);
    }

    protected abstract IndexProperties createIndexPropertiesLeft(LeftTuple_ var1);

    protected abstract OutTuple_ createOutTuple(LeftTuple_ var1, UniTuple<Right_> var2);

    protected abstract void updateOutTupleLeft(OutTuple_ var1, LeftTuple_ var2);

    protected abstract void updateOutTupleRight(OutTuple_ var1, UniTuple<Right_> var2);

    private void updateTuple(OutTuple_ outTuple) {
        switch (outTuple.getState()) {
            case CREATING: 
            case UPDATING: {
                break;
            }
            case OK: {
                outTuple.setState(BavetTupleState.UPDATING);
                this.dirtyTupleQueue.add(outTuple);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The tuple (" + outTuple.getState() + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
            }
        }
    }

    private void retractTuple(OutTuple_ outTuple) {
        switch (outTuple.getState()) {
            case CREATING: {
                outTuple.setState(BavetTupleState.ABORTING);
                break;
            }
            case OK: {
                outTuple.setState(BavetTupleState.DYING);
                this.dirtyTupleQueue.add(outTuple);
                break;
            }
            case UPDATING: {
                outTuple.setState(BavetTupleState.DYING);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The tuple (" + outTuple.getState() + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
            }
        }
    }

    @Override
    public void calculateScore() {
        block6: for (Tuple tuple : this.dirtyTupleQueue) {
            switch (tuple.getState()) {
                case CREATING: {
                    this.nextNodesTupleLifecycle.insert(tuple);
                    tuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case UPDATING: {
                    this.nextNodesTupleLifecycle.update(tuple);
                    tuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case DYING: {
                    this.nextNodesTupleLifecycle.retract(tuple);
                    tuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
                case ABORTING: {
                    tuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
            }
            throw new IllegalStateException("Impossible state: The tuple (" + tuple + ") in node (" + this + ") is in an unexpected state (" + tuple.getState() + ").");
        }
        this.dirtyTupleQueue.clear();
    }
}

