/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common;

import java.util.Objects;
import org.optaplanner.constraint.streams.common.ConstraintConstructor;
import org.optaplanner.constraint.streams.common.ScoreImpactType;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintBuilder;

public abstract class AbstractConstraintBuilder<ConstraintBuilder_ extends ConstraintBuilder<ConstraintBuilder_>>
implements ConstraintBuilder<ConstraintBuilder_> {
    private final ConstraintConstructor constraintConstructor;
    private final ScoreImpactType impactType;
    private final Score<?> constraintWeight;

    protected AbstractConstraintBuilder(ConstraintConstructor constraintConstructor, ScoreImpactType impactType, Score<?> constraintWeight) {
        this.constraintConstructor = Objects.requireNonNull(constraintConstructor);
        this.impactType = Objects.requireNonNull(impactType);
        this.constraintWeight = constraintWeight;
    }

    public final Constraint asConstraint(String constraintName) {
        return this.constraintConstructor.apply(null, constraintName, this.constraintWeight, this.impactType);
    }

    public final Constraint asConstraint(String constraintPackage, String constraintName) {
        return this.constraintConstructor.apply(constraintPackage, constraintName, this.constraintWeight, this.impactType);
    }
}

