/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.tri;

import java.math.BigDecimal;
import org.optaplanner.constraint.streams.common.RetrievalSemantics;
import org.optaplanner.constraint.streams.common.ScoreImpactType;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.quad.QuadJoiner;
import org.optaplanner.core.api.score.stream.tri.TriConstraintBuilder;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;

public interface InnerTriConstraintStream<A, B, C>
extends TriConstraintStream<A, B, C> {
    public RetrievalSemantics getRetrievalSemantics();

    public boolean guaranteesDistinct();

    default public <D> QuadConstraintStream<A, B, C, D> join(Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.join(this.getConstraintFactory().forEach(otherClass), joiners);
        }
        return this.join(this.getConstraintFactory().from(otherClass), joiners);
    }

    default public TriConstraintStream<A, B, C> distinct() {
        if (this.guaranteesDistinct()) {
            return this;
        }
        return this.groupBy((a, b, c) -> a, (a, b, c) -> b, (a, b, c) -> c);
    }

    default public TriConstraintBuilder<A, B, C> penalize(Score<?> constraintWeight, ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public TriConstraintBuilder<A, B, C> penalizeLong(Score<?> constraintWeight, ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public TriConstraintBuilder<A, B, C> penalizeBigDecimal(Score<?> constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public TriConstraintBuilder<A, B, C> penalizeConfigurable(ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public TriConstraintBuilder<A, B, C> penalizeConfigurableLong(ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public TriConstraintBuilder<A, B, C> penalizeConfigurableBigDecimal(TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public TriConstraintBuilder<A, B, C> reward(Score<?> constraintWeight, ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    default public TriConstraintBuilder<A, B, C> rewardLong(Score<?> constraintWeight, ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    default public TriConstraintBuilder<A, B, C> rewardBigDecimal(Score<?> constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    default public TriConstraintBuilder<A, B, C> rewardConfigurable(ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    default public TriConstraintBuilder<A, B, C> rewardConfigurableLong(ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    default public TriConstraintBuilder<A, B, C> rewardConfigurableBigDecimal(TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    default public TriConstraintBuilder<A, B, C> impact(Score<?> constraintWeight, ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    default public TriConstraintBuilder<A, B, C> impactLong(Score<?> constraintWeight, ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    default public TriConstraintBuilder<A, B, C> impactBigDecimal(Score<?> constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    default public TriConstraintBuilder<A, B, C> impactConfigurable(ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    default public TriConstraintBuilder<A, B, C> impactConfigurableLong(ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    default public TriConstraintBuilder<A, B, C> impactConfigurableBigDecimal(TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    public TriConstraintBuilder<A, B, C> innerImpact(Score<?> var1, ToIntTriFunction<A, B, C> var2, ScoreImpactType var3);

    public TriConstraintBuilder<A, B, C> innerImpact(Score<?> var1, ToLongTriFunction<A, B, C> var2, ScoreImpactType var3);

    public TriConstraintBuilder<A, B, C> innerImpact(Score<?> var1, TriFunction<A, B, C, BigDecimal> var2, ScoreImpactType var3);

    default public Constraint penalize(String constraintName, Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintName);
    }

    default public Constraint penalize(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    default public Constraint penalizeConfigurable(String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintName);
    }

    default public Constraint penalizeConfigurable(String constraintPackage, String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    default public Constraint reward(String constraintName, Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintName);
    }

    default public Constraint reward(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    default public Constraint rewardConfigurable(String constraintName) {
        return this.rewardConfigurable().asConstraint(constraintName);
    }

    default public Constraint rewardConfigurable(String constraintPackage, String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    default public Constraint impact(String constraintName, Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintName);
    }

    default public Constraint impact(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintPackage, constraintName);
    }
}

