/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendable;

import java.util.Arrays;
import java.util.Objects;
import org.optaplanner.core.api.score.AbstractBendableScore;

public final class BendableScore
extends AbstractBendableScore<BendableScore> {
    private final int[] hardScores;
    private final int[] softScores;

    public static BendableScore parseScore(String scoreString) {
        String[][] scoreTokens = BendableScore.parseBendableScoreTokens(BendableScore.class, scoreString);
        int initScore = BendableScore.parseInitScore(BendableScore.class, scoreString, scoreTokens[0][0]);
        int[] hardScores = new int[scoreTokens[1].length];
        for (int i = 0; i < hardScores.length; ++i) {
            hardScores[i] = BendableScore.parseLevelAsInt(BendableScore.class, scoreString, scoreTokens[1][i]);
        }
        int[] softScores = new int[scoreTokens[2].length];
        for (int i = 0; i < softScores.length; ++i) {
            softScores[i] = BendableScore.parseLevelAsInt(BendableScore.class, scoreString, scoreTokens[2][i]);
        }
        return BendableScore.ofUninitialized(initScore, hardScores, softScores);
    }

    public static BendableScore ofUninitialized(int initScore, int[] hardScores, int[] softScores) {
        return new BendableScore(initScore, hardScores, softScores);
    }

    public static BendableScore of(int[] hardScores, int[] softScores) {
        return new BendableScore(0, hardScores, softScores);
    }

    public static BendableScore zero(int hardLevelsSize, int softLevelsSize) {
        return new BendableScore(0, new int[hardLevelsSize], new int[softLevelsSize]);
    }

    public static BendableScore ofHard(int hardLevelsSize, int softLevelsSize, int hardLevel, int hardScore) {
        int[] hardScores = new int[hardLevelsSize];
        hardScores[hardLevel] = hardScore;
        return new BendableScore(0, hardScores, new int[softLevelsSize]);
    }

    public static BendableScore ofSoft(int hardLevelsSize, int softLevelsSize, int softLevel, int softScore) {
        int[] softScores = new int[softLevelsSize];
        softScores[softLevel] = softScore;
        return new BendableScore(0, new int[hardLevelsSize], softScores);
    }

    private BendableScore() {
        this(Integer.MIN_VALUE, null, null);
    }

    private BendableScore(int initScore, int[] hardScores, int[] softScores) {
        super(initScore);
        this.hardScores = hardScores;
        this.softScores = softScores;
    }

    public int[] getHardScores() {
        return Arrays.copyOf(this.hardScores, this.hardScores.length);
    }

    public int[] getSoftScores() {
        return Arrays.copyOf(this.softScores, this.softScores.length);
    }

    @Override
    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public int getHardScore(int hardLevel) {
        return this.hardScores[hardLevel];
    }

    @Override
    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public int getSoftScore(int softLevel) {
        return this.softScores[softLevel];
    }

    @Override
    public BendableScore withInitScore(int newInitScore) {
        return new BendableScore(newInitScore, this.hardScores, this.softScores);
    }

    @Override
    public int getLevelsSize() {
        return this.hardScores.length + this.softScores.length;
    }

    public int getHardOrSoftScore(int level) {
        if (level < this.hardScores.length) {
            return this.hardScores[level];
        }
        return this.softScores[level - this.hardScores.length];
    }

    @Override
    public boolean isFeasible() {
        if (this.initScore < 0) {
            return false;
        }
        for (int hardScore : this.hardScores) {
            if (hardScore >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public BendableScore add(BendableScore addend) {
        int i;
        this.validateCompatible(addend);
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i] + addend.getHardScore(i);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i] + addend.getSoftScore(i);
        }
        return new BendableScore(this.initScore + addend.getInitScore(), newHardScores, newSoftScores);
    }

    @Override
    public BendableScore subtract(BendableScore subtrahend) {
        int i;
        this.validateCompatible(subtrahend);
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i] - subtrahend.getHardScore(i);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i] - subtrahend.getSoftScore(i);
        }
        return new BendableScore(this.initScore - subtrahend.getInitScore(), newHardScores, newSoftScores);
    }

    @Override
    public BendableScore multiply(double multiplicand) {
        int i;
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (int)Math.floor((double)this.hardScores[i] * multiplicand);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (int)Math.floor((double)this.softScores[i] * multiplicand);
        }
        return new BendableScore((int)Math.floor((double)this.initScore * multiplicand), newHardScores, newSoftScores);
    }

    @Override
    public BendableScore divide(double divisor) {
        int i;
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (int)Math.floor((double)this.hardScores[i] / divisor);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (int)Math.floor((double)this.softScores[i] / divisor);
        }
        return new BendableScore((int)Math.floor((double)this.initScore / divisor), newHardScores, newSoftScores);
    }

    @Override
    public BendableScore power(double exponent) {
        int i;
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (int)Math.floor(Math.pow(this.hardScores[i], exponent));
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (int)Math.floor(Math.pow(this.softScores[i], exponent));
        }
        return new BendableScore((int)Math.floor(Math.pow(this.initScore, exponent)), newHardScores, newSoftScores);
    }

    @Override
    public BendableScore negate() {
        int i;
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = -this.hardScores[i];
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = -this.softScores[i];
        }
        return new BendableScore(-this.initScore, newHardScores, newSoftScores);
    }

    @Override
    public BendableScore abs() {
        int i;
        int[] newHardScores = new int[this.hardScores.length];
        int[] newSoftScores = new int[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = Math.abs(this.hardScores[i]);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = Math.abs(this.softScores[i]);
        }
        return new BendableScore(Math.abs(this.initScore), newHardScores, newSoftScores);
    }

    @Override
    public BendableScore zero() {
        return BendableScore.zero(this.getHardLevelsSize(), this.getSoftLevelsSize());
    }

    @Override
    public Number[] toLevelNumbers() {
        int i;
        Number[] levelNumbers = new Number[this.hardScores.length + this.softScores.length];
        for (i = 0; i < this.hardScores.length; ++i) {
            levelNumbers[i] = this.hardScores[i];
        }
        for (i = 0; i < this.softScores.length; ++i) {
            levelNumbers[this.hardScores.length + i] = this.softScores[i];
        }
        return levelNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BendableScore) {
            int i;
            BendableScore other = (BendableScore)o;
            if (this.getHardLevelsSize() != other.getHardLevelsSize() || this.getSoftLevelsSize() != other.getSoftLevelsSize()) {
                return false;
            }
            if (this.initScore != other.getInitScore()) {
                return false;
            }
            for (i = 0; i < this.hardScores.length; ++i) {
                if (this.hardScores[i] == other.getHardScore(i)) continue;
                return false;
            }
            for (i = 0; i < this.softScores.length; ++i) {
                if (this.softScores[i] == other.getSoftScore(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, Arrays.hashCode(this.hardScores), Arrays.hashCode(this.softScores));
    }

    @Override
    public int compareTo(BendableScore other) {
        int i;
        this.validateCompatible(other);
        if (this.initScore != other.getInitScore()) {
            return Integer.compare(this.initScore, other.getInitScore());
        }
        for (i = 0; i < this.hardScores.length; ++i) {
            if (this.hardScores[i] == other.getHardScore(i)) continue;
            return Integer.compare(this.hardScores[i], other.getHardScore(i));
        }
        for (i = 0; i < this.softScores.length; ++i) {
            if (this.softScores[i] == other.getSoftScore(i)) continue;
            return Integer.compare(this.softScores[i], other.getSoftScore(i));
        }
        return 0;
    }

    @Override
    public String toShortString() {
        return this.buildBendableShortString(n -> n.intValue() != 0);
    }

    public String toString() {
        StringBuilder s = new StringBuilder((this.hardScores.length + this.softScores.length) * 4 + 13);
        s.append(this.getInitPrefix());
        s.append("[");
        boolean first = true;
        for (int hardScore : this.hardScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(hardScore);
        }
        s.append("]hard/[");
        first = true;
        for (int softScore : this.softScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(softScore);
        }
        s.append("]soft");
        return s.toString();
    }

    public void validateCompatible(BendableScore other) {
        if (this.getHardLevelsSize() != other.getHardLevelsSize()) {
            throw new IllegalArgumentException("The score (" + this + ") with hardScoreSize (" + this.getHardLevelsSize() + ") is not compatible with the other score (" + other + ") with hardScoreSize (" + other.getHardLevelsSize() + ").");
        }
        if (this.getSoftLevelsSize() != other.getSoftLevelsSize()) {
            throw new IllegalArgumentException("The score (" + this + ") with softScoreSize (" + this.getSoftLevelsSize() + ") is not compatible with the other score (" + other + ") with softScoreSize (" + other.getSoftLevelsSize() + ").");
        }
    }
}

