/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.constraint;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.optaplanner.core.api.domain.common.DomainAccessType;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessorFactory;
import org.optaplanner.core.impl.domain.lookup.ClassAndPlanningIdComparator;

public final class ConstraintMatch<Score_ extends Score<Score_>>
implements Comparable<ConstraintMatch<Score_>> {
    private final String constraintPackage;
    private final String constraintName;
    private final String constraintId;
    private final List<Object> justificationList;
    private final Score_ score;
    private Comparator<Object> classAndIdPlanningComparator;

    public ConstraintMatch(String constraintPackage, String constraintName, List<Object> justificationList, Score_ score) {
        this.constraintPackage = Objects.requireNonNull(constraintPackage);
        this.constraintName = Objects.requireNonNull(constraintName);
        this.constraintId = ConstraintMatchTotal.composeConstraintId(constraintPackage, constraintName);
        this.justificationList = Objects.requireNonNull(justificationList);
        this.score = (Score)Objects.requireNonNull(score);
    }

    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public List<Object> getJustificationList() {
        return this.justificationList;
    }

    public Score_ getScore() {
        return this.score;
    }

    public String getConstraintId() {
        return ConstraintMatchTotal.composeConstraintId(this.constraintPackage, this.constraintName);
    }

    public String getIdentificationString() {
        return this.getConstraintId() + "/" + this.justificationList;
    }

    @Override
    public int compareTo(ConstraintMatch<Score_> other) {
        if (!this.constraintId.equals(other.constraintId)) {
            return this.constraintId.compareTo(other.constraintId);
        }
        if (!this.score.equals(other.score)) {
            return this.score.compareTo(other.score);
        }
        if (this.justificationList.size() != other.justificationList.size()) {
            return Integer.compare(this.justificationList.size(), other.justificationList.size());
        }
        Comparator<Object> comparator = this.getClassAndIdPlanningComparator(other);
        for (int i = 0; i < this.justificationList.size(); ++i) {
            Object right;
            Object left = this.justificationList.get(i);
            int comparison = comparator.compare(left, right = other.justificationList.get(i));
            if (comparison == 0) continue;
            return comparison;
        }
        return Integer.compare(System.identityHashCode(this), System.identityHashCode(other));
    }

    private Comparator<Object> getClassAndIdPlanningComparator(ConstraintMatch<Score_> other) {
        if (this.classAndIdPlanningComparator != null) {
            return this.classAndIdPlanningComparator;
        }
        if (other.classAndIdPlanningComparator != null) {
            return other.classAndIdPlanningComparator;
        }
        this.classAndIdPlanningComparator = new ClassAndPlanningIdComparator(new MemberAccessorFactory(), DomainAccessType.REFLECTION, false);
        other.classAndIdPlanningComparator = this.classAndIdPlanningComparator;
        return this.classAndIdPlanningComparator;
    }

    public String toString() {
        return this.getIdentificationString() + "=" + this.score;
    }
}

