/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.stream.uni;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintStream;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.uni.UniConstraintBuilder;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;

public interface UniConstraintStream<A>
extends ConstraintStream {
    public UniConstraintStream<A> filter(Predicate<A> var1);

    default public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> otherStream) {
        return this.join(otherStream, new BiJoiner[0]);
    }

    default public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> otherStream, BiJoiner<A, B> joiner) {
        return this.join(otherStream, new BiJoiner[]{joiner});
    }

    default public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> otherStream, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2) {
        return this.join(otherStream, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> otherStream, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3) {
        return this.join(otherStream, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> otherStream, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3, BiJoiner<A, B> joiner4) {
        return this.join(otherStream, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> var1, BiJoiner<A, B> ... var2);

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass) {
        return this.join(otherClass, new BiJoiner[0]);
    }

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> joiner) {
        return this.join(otherClass, new BiJoiner[]{joiner});
    }

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2) {
        return this.join(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3) {
        return this.join(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3, BiJoiner<A, B> joiner4) {
        return this.join(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> BiConstraintStream<A, B> join(Class<B> var1, BiJoiner<A, B> ... var2);

    default public <B> UniConstraintStream<A> ifExists(Class<B> otherClass, BiJoiner<A, B> joiner) {
        return this.ifExists(otherClass, new BiJoiner[]{joiner});
    }

    default public <B> UniConstraintStream<A> ifExists(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2) {
        return this.ifExists(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> UniConstraintStream<A> ifExists(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3) {
        return this.ifExists(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> UniConstraintStream<A> ifExists(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3, BiJoiner<A, B> joiner4) {
        return this.ifExists(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> UniConstraintStream<A> ifExists(Class<B> var1, BiJoiner<A, B> ... var2);

    default public <B> UniConstraintStream<A> ifExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner) {
        return this.ifExistsIncludingNullVars(otherClass, new BiJoiner[]{joiner});
    }

    default public <B> UniConstraintStream<A> ifExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2) {
        return this.ifExistsIncludingNullVars(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> UniConstraintStream<A> ifExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3) {
        return this.ifExistsIncludingNullVars(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> UniConstraintStream<A> ifExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3, BiJoiner<A, B> joiner4) {
        return this.ifExistsIncludingNullVars(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> UniConstraintStream<A> ifExistsIncludingNullVars(Class<B> var1, BiJoiner<A, B> ... var2);

    default public UniConstraintStream<A> ifExistsOther(Class<A> otherClass) {
        return this.ifExists((Class<B>)otherClass, (BiJoiner<A, B>)Joiners.filtering((a, b) -> !Objects.equals(a, b)));
    }

    default public UniConstraintStream<A> ifExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner) {
        return this.ifExistsOther(otherClass, new BiJoiner[]{joiner});
    }

    default public UniConstraintStream<A> ifExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2) {
        return this.ifExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public UniConstraintStream<A> ifExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3) {
        return this.ifExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public UniConstraintStream<A> ifExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3, BiJoiner<A, A> joiner4) {
        return this.ifExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    default public UniConstraintStream<A> ifExistsOther(Class<A> otherClass, BiJoiner<A, A> ... joiners) {
        BiJoiner<Object, Object> otherness = Joiners.filtering((a, b) -> !Objects.equals(a, b));
        BiJoiner[] allJoiners = (BiJoiner[])Stream.concat(Arrays.stream(joiners), Stream.of(otherness)).toArray(BiJoiner[]::new);
        return this.ifExists(otherClass, allJoiners);
    }

    default public UniConstraintStream<A> ifExistsOtherIncludingNullVars(Class<A> otherClass) {
        return this.ifExistsOtherIncludingNullVars(otherClass, new BiJoiner[0]);
    }

    default public UniConstraintStream<A> ifExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner) {
        return this.ifExistsOtherIncludingNullVars(otherClass, new BiJoiner[]{joiner});
    }

    default public UniConstraintStream<A> ifExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2) {
        return this.ifExistsOtherIncludingNullVars(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public UniConstraintStream<A> ifExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3) {
        return this.ifExistsOtherIncludingNullVars(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public UniConstraintStream<A> ifExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3, BiJoiner<A, A> joiner4) {
        return this.ifExistsOtherIncludingNullVars(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    default public UniConstraintStream<A> ifExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> ... joiners) {
        BiJoiner<Object, Object> otherness = Joiners.filtering((a, b) -> !Objects.equals(a, b));
        BiJoiner[] allJoiners = (BiJoiner[])Stream.concat(Arrays.stream(joiners), Stream.of(otherness)).toArray(BiJoiner[]::new);
        return this.ifExistsIncludingNullVars(otherClass, allJoiners);
    }

    default public <B> UniConstraintStream<A> ifNotExists(Class<B> otherClass, BiJoiner<A, B> joiner) {
        return this.ifNotExists(otherClass, new BiJoiner[]{joiner});
    }

    default public <B> UniConstraintStream<A> ifNotExists(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2) {
        return this.ifNotExists(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> UniConstraintStream<A> ifNotExists(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3) {
        return this.ifNotExists(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> UniConstraintStream<A> ifNotExists(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3, BiJoiner<A, B> joiner4) {
        return this.ifNotExists(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> UniConstraintStream<A> ifNotExists(Class<B> var1, BiJoiner<A, B> ... var2);

    default public <B> UniConstraintStream<A> ifNotExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner) {
        return this.ifNotExistsIncludingNullVars(otherClass, new BiJoiner[]{joiner});
    }

    default public <B> UniConstraintStream<A> ifNotExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2) {
        return this.ifNotExistsIncludingNullVars(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public <B> UniConstraintStream<A> ifNotExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3) {
        return this.ifNotExistsIncludingNullVars(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <B> UniConstraintStream<A> ifNotExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3, BiJoiner<A, B> joiner4) {
        return this.ifNotExistsIncludingNullVars(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <B> UniConstraintStream<A> ifNotExistsIncludingNullVars(Class<B> var1, BiJoiner<A, B> ... var2);

    default public UniConstraintStream<A> ifNotExistsOther(Class<A> otherClass) {
        return this.ifNotExists((Class<B>)otherClass, (BiJoiner<A, B>)Joiners.filtering((a, b) -> !Objects.equals(a, b)));
    }

    default public UniConstraintStream<A> ifNotExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner) {
        return this.ifNotExistsOther(otherClass, new BiJoiner[]{joiner});
    }

    default public UniConstraintStream<A> ifNotExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2) {
        return this.ifNotExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public UniConstraintStream<A> ifNotExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3) {
        return this.ifNotExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public UniConstraintStream<A> ifNotExistsOther(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3, BiJoiner<A, A> joiner4) {
        return this.ifNotExistsOther(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    default public UniConstraintStream<A> ifNotExistsOther(Class<A> otherClass, BiJoiner<A, A> ... joiners) {
        BiJoiner<Object, Object> otherness = Joiners.filtering((a, b) -> !Objects.equals(a, b));
        BiJoiner[] allJoiners = (BiJoiner[])Stream.concat(Arrays.stream(joiners), Stream.of(otherness)).toArray(BiJoiner[]::new);
        return this.ifNotExists(otherClass, allJoiners);
    }

    default public UniConstraintStream<A> ifNotExistsOtherIncludingNullVars(Class<A> otherClass) {
        return this.ifNotExistsOtherIncludingNullVars(otherClass, new BiJoiner[0]);
    }

    default public UniConstraintStream<A> ifNotExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner) {
        return this.ifNotExistsOtherIncludingNullVars(otherClass, new BiJoiner[]{joiner});
    }

    default public UniConstraintStream<A> ifNotExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2) {
        return this.ifNotExistsOtherIncludingNullVars(otherClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public UniConstraintStream<A> ifNotExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3) {
        return this.ifNotExistsOtherIncludingNullVars(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public UniConstraintStream<A> ifNotExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3, BiJoiner<A, A> joiner4) {
        return this.ifNotExistsOtherIncludingNullVars(otherClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    default public UniConstraintStream<A> ifNotExistsOtherIncludingNullVars(Class<A> otherClass, BiJoiner<A, A> ... joiners) {
        BiJoiner<Object, Object> otherness = Joiners.filtering((a, b) -> !Objects.equals(a, b));
        BiJoiner[] allJoiners = (BiJoiner[])Stream.concat(Arrays.stream(joiners), Stream.of(otherness)).toArray(BiJoiner[]::new);
        return this.ifNotExistsIncludingNullVars(otherClass, allJoiners);
    }

    public <ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(UniConstraintCollector<A, ResultContainer_, Result_> var1);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_> BiConstraintStream<ResultA_, ResultB_> groupBy(UniConstraintCollector<A, ResultContainerA_, ResultA_> var1, UniConstraintCollector<A, ResultContainerB_, ResultB_> var2);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<ResultA_, ResultB_, ResultC_> groupBy(UniConstraintCollector<A, ResultContainerA_, ResultA_> var1, UniConstraintCollector<A, ResultContainerB_, ResultB_> var2, UniConstraintCollector<A, ResultContainerC_, ResultC_> var3);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> groupBy(UniConstraintCollector<A, ResultContainerA_, ResultA_> var1, UniConstraintCollector<A, ResultContainerB_, ResultB_> var2, UniConstraintCollector<A, ResultContainerC_, ResultC_> var3, UniConstraintCollector<A, ResultContainerD_, ResultD_> var4);

    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(Function<A, GroupKey_> var1);

    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(Function<A, GroupKey_> var1, UniConstraintCollector<A, ResultContainer_, Result_> var2);

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<GroupKey_, ResultB_, ResultC_> groupBy(Function<A, GroupKey_> var1, UniConstraintCollector<A, ResultContainerB_, ResultB_> var2, UniConstraintCollector<A, ResultContainerC_, ResultC_> var3);

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKey_, ResultB_, ResultC_, ResultD_> groupBy(Function<A, GroupKey_> var1, UniConstraintCollector<A, ResultContainerB_, ResultB_> var2, UniConstraintCollector<A, ResultContainerC_, ResultC_> var3, UniConstraintCollector<A, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(Function<A, GroupKeyA_> var1, Function<A, GroupKeyB_> var2);

    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(Function<A, GroupKeyA_> var1, Function<A, GroupKeyB_> var2, UniConstraintCollector<A, ResultContainer_, Result_> var3);

    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(Function<A, GroupKeyA_> var1, Function<A, GroupKeyB_> var2, UniConstraintCollector<A, ResultContainerC_, ResultC_> var3, UniConstraintCollector<A, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_> TriConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_> groupBy(Function<A, GroupKeyA_> var1, Function<A, GroupKeyB_> var2, Function<A, GroupKeyC_> var3);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultD_> groupBy(Function<A, GroupKeyA_> var1, Function<A, GroupKeyB_> var2, Function<A, GroupKeyC_> var3, UniConstraintCollector<A, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> groupBy(Function<A, GroupKeyA_> var1, Function<A, GroupKeyB_> var2, Function<A, GroupKeyC_> var3, Function<A, GroupKeyD_> var4);

    public <ResultA_> UniConstraintStream<ResultA_> map(Function<A, ResultA_> var1);

    public <ResultA_> UniConstraintStream<ResultA_> flattenLast(Function<A, Iterable<ResultA_>> var1);

    public UniConstraintStream<A> distinct();

    default public UniConstraintBuilder<A> penalize(Score<?> constraintWeight) {
        return this.penalize(constraintWeight, (A a) -> 1);
    }

    public UniConstraintBuilder<A> penalize(Score<?> var1, ToIntFunction<A> var2);

    public UniConstraintBuilder<A> penalizeLong(Score<?> var1, ToLongFunction<A> var2);

    public UniConstraintBuilder<A> penalizeBigDecimal(Score<?> var1, Function<A, BigDecimal> var2);

    default public UniConstraintBuilder<A> penalizeConfigurable() {
        return this.penalizeConfigurable((A a) -> 1);
    }

    public UniConstraintBuilder<A> penalizeConfigurable(ToIntFunction<A> var1);

    public UniConstraintBuilder<A> penalizeConfigurableLong(ToLongFunction<A> var1);

    public UniConstraintBuilder<A> penalizeConfigurableBigDecimal(Function<A, BigDecimal> var1);

    default public UniConstraintBuilder<A> reward(Score<?> constraintWeight) {
        return this.reward(constraintWeight, (A a) -> 1);
    }

    public UniConstraintBuilder<A> reward(Score<?> var1, ToIntFunction<A> var2);

    public UniConstraintBuilder<A> rewardLong(Score<?> var1, ToLongFunction<A> var2);

    public UniConstraintBuilder<A> rewardBigDecimal(Score<?> var1, Function<A, BigDecimal> var2);

    default public UniConstraintBuilder<A> rewardConfigurable() {
        return this.rewardConfigurable((A a) -> 1);
    }

    public UniConstraintBuilder<A> rewardConfigurable(ToIntFunction<A> var1);

    public UniConstraintBuilder<A> rewardConfigurableLong(ToLongFunction<A> var1);

    public UniConstraintBuilder<A> rewardConfigurableBigDecimal(Function<A, BigDecimal> var1);

    default public UniConstraintBuilder<A> impact(Score<?> constraintWeight) {
        return this.impact(constraintWeight, (A a) -> 1);
    }

    public UniConstraintBuilder<A> impact(Score<?> var1, ToIntFunction<A> var2);

    public UniConstraintBuilder<A> impactLong(Score<?> var1, ToLongFunction<A> var2);

    public UniConstraintBuilder<A> impactBigDecimal(Score<?> var1, Function<A, BigDecimal> var2);

    default public UniConstraintBuilder<A> impactConfigurable() {
        return this.impactConfigurable(a -> 1);
    }

    public UniConstraintBuilder<A> impactConfigurable(ToIntFunction<A> var1);

    public UniConstraintBuilder<A> impactConfigurableLong(ToLongFunction<A> var1);

    public UniConstraintBuilder<A> impactConfigurableBigDecimal(Function<A, BigDecimal> var1);

    @Deprecated(forRemoval=true)
    default public Constraint penalize(String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.penalize(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalize(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.penalize(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeLong(String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.penalizeLong(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.penalizeLong(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeBigDecimal(String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.penalizeBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.penalizeBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurable(String constraintName, ToIntFunction<A> matchWeigher) {
        return this.penalizeConfigurable(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurable(String constraintPackage, String constraintName, ToIntFunction<A> matchWeigher) {
        return this.penalizeConfigurable(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableLong(String constraintName, ToLongFunction<A> matchWeigher) {
        return this.penalizeConfigurableLong(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableLong(String constraintPackage, String constraintName, ToLongFunction<A> matchWeigher) {
        return this.penalizeConfigurableLong(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableBigDecimal(String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.penalizeConfigurableBigDecimal(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint penalizeConfigurableBigDecimal(String constraintPackage, String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.penalizeConfigurableBigDecimal(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint reward(String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.reward(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint reward(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.reward(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardLong(String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.rewardLong(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.rewardLong(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardBigDecimal(String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.rewardBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.rewardBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurable(String constraintName, ToIntFunction<A> matchWeigher) {
        return this.rewardConfigurable(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurable(String constraintPackage, String constraintName, ToIntFunction<A> matchWeigher) {
        return this.rewardConfigurable(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableLong(String constraintName, ToLongFunction<A> matchWeigher) {
        return this.rewardConfigurableLong(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableLong(String constraintPackage, String constraintName, ToLongFunction<A> matchWeigher) {
        return this.rewardConfigurableLong(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableBigDecimal(String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.rewardConfigurableBigDecimal(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint rewardConfigurableBigDecimal(String constraintPackage, String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.rewardConfigurableBigDecimal(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impact(String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.impact(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impact(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.impact(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactLong(String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.impactLong(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.impactLong(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactBigDecimal(String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.impactBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.impactBigDecimal(constraintWeight, matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurable(String constraintName, ToIntFunction<A> matchWeigher) {
        return this.impactConfigurable(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurable(String constraintPackage, String constraintName, ToIntFunction<A> matchWeigher) {
        return this.impactConfigurable(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurableLong(String constraintName, ToLongFunction<A> matchWeigher) {
        return this.impactConfigurableLong(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurableLong(String constraintPackage, String constraintName, ToLongFunction<A> matchWeigher) {
        return this.impactConfigurableLong(matchWeigher).asConstraint(constraintPackage, constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurableBigDecimal(String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.impactConfigurableBigDecimal(matchWeigher).asConstraint(constraintName);
    }

    @Deprecated(forRemoval=true)
    default public Constraint impactConfigurableBigDecimal(String constraintPackage, String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.impactConfigurableBigDecimal(matchWeigher).asConstraint(constraintPackage, constraintName);
    }
}

