/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener.support.violation;

import java.util.Objects;
import java.util.function.Consumer;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;

final class ShadowVariableSnapshot {
    private final ShadowVariableDescriptor<?> shadowVariableDescriptor;
    private final Object entity;
    private final Object originalValue;

    private ShadowVariableSnapshot(ShadowVariableDescriptor<?> shadowVariableDescriptor, Object entity, Object originalValue) {
        this.shadowVariableDescriptor = shadowVariableDescriptor;
        this.entity = entity;
        this.originalValue = originalValue;
    }

    static ShadowVariableSnapshot of(ShadowVariableDescriptor<?> shadowVariableDescriptor, Object entity) {
        return new ShadowVariableSnapshot(shadowVariableDescriptor, entity, shadowVariableDescriptor.getValue(entity));
    }

    void validate(Consumer<String> violationMessageConsumer) {
        Object newValue = this.shadowVariableDescriptor.getValue(this.entity);
        if (!Objects.equals(this.originalValue, newValue)) {
            violationMessageConsumer.accept("    The entity (" + this.entity + ")'s shadow variable (" + this.shadowVariableDescriptor.getSimpleEntityAndVariableName() + ")'s corrupted value (" + this.originalValue + ") changed to uncorrupted value (" + newValue + ") after all " + VariableListener.class.getSimpleName() + "s were triggered without changes to the genuine variables.\n      Maybe the " + VariableListener.class.getSimpleName() + " class (" + this.shadowVariableDescriptor.getVariableListenerClass().getSimpleName() + ") for that shadow variable (" + this.shadowVariableDescriptor.getSimpleEntityAndVariableName() + ") forgot to update it when one of its sources changed.\n      Maybe some of the genuine/shadow variables it depends on are missing in the @" + CustomShadowVariable.class.getSimpleName() + "'s sources value.");
        }
    }

    ShadowVariableDescriptor<?> getShadowVariableDescriptor() {
        return this.shadowVariableDescriptor;
    }

    public String toString() {
        return this.entity + "." + this.shadowVariableDescriptor.getVariableName() + " = " + this.originalValue;
    }
}

