/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value;

import java.util.ArrayList;
import java.util.Comparator;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import org.optaplanner.core.config.heuristic.selector.value.ValueSelectorConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.EntityIndependentValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.heuristic.selector.AbstractSelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandomFactory;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.FromEntityPropertyValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.FromSolutionPropertyValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.CachingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.DowncastingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.EntityDependentSortingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.FilteringValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.InitializedValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.ProbabilityValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.ReinitializeVariableValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.SelectedCountLimitValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.ShufflingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.SortingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.UnassignedValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.MimicRecordingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.MimicReplayingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.ValueMimicRecorder;
import org.optaplanner.core.impl.heuristic.selector.value.nearby.NearEntityNearbyValueSelector;

public class ValueSelectorFactory<Solution_>
extends AbstractSelectorFactory<Solution_, ValueSelectorConfig> {
    public static <Solution_> ValueSelectorFactory<Solution_> create(ValueSelectorConfig valueSelectorConfig) {
        return new ValueSelectorFactory<Solution_>(valueSelectorConfig);
    }

    public ValueSelectorFactory(ValueSelectorConfig valueSelectorConfig) {
        super(valueSelectorConfig);
    }

    public GenuineVariableDescriptor<Solution_> extractVariableDescriptor(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor) {
        String variableName = ((ValueSelectorConfig)this.config).getVariableName();
        if (variableName != null) {
            return this.getVariableDescriptorForName(this.downcastEntityDescriptor(configPolicy, entityDescriptor), variableName);
        }
        if (((ValueSelectorConfig)this.config).getMimicSelectorRef() != null) {
            return configPolicy.getValueMimicRecorder(((ValueSelectorConfig)this.config).getMimicSelectorRef()).getVariableDescriptor();
        }
        return null;
    }

    public ValueSelector<Solution_> buildValueSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        return this.buildValueSelector(configPolicy, entityDescriptor, minimumCacheType, inheritedSelectionOrder, configPolicy.isReinitializeVariableFilterEnabled(), false);
    }

    public ValueSelector<Solution_> buildValueSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder, boolean applyReinitializeVariableFiltering, boolean applyUnassignedValueFiltering) {
        GenuineVariableDescriptor<Solution_> variableDescriptor = this.deduceGenuineVariableDescriptor(this.downcastEntityDescriptor(configPolicy, entityDescriptor), ((ValueSelectorConfig)this.config).getVariableName());
        if (((ValueSelectorConfig)this.config).getMimicSelectorRef() != null) {
            ValueSelector<Solution_> valueSelector = this.buildMimicReplaying(configPolicy);
            valueSelector = this.applyReinitializeVariableFiltering(applyReinitializeVariableFiltering, variableDescriptor, valueSelector);
            valueSelector = this.applyDowncasting(valueSelector);
            return valueSelector;
        }
        SelectionCacheType resolvedCacheType = SelectionCacheType.resolve(((ValueSelectorConfig)this.config).getCacheType(), minimumCacheType);
        SelectionOrder resolvedSelectionOrder = SelectionOrder.resolve(((ValueSelectorConfig)this.config).getSelectionOrder(), inheritedSelectionOrder);
        if (((ValueSelectorConfig)this.config).getNearbySelectionConfig() != null) {
            ((ValueSelectorConfig)this.config).getNearbySelectionConfig().validateNearby(resolvedCacheType, resolvedSelectionOrder);
        }
        this.validateCacheTypeVersusSelectionOrder(resolvedCacheType, resolvedSelectionOrder);
        this.validateSorting(resolvedSelectionOrder);
        this.validateProbability(resolvedSelectionOrder);
        this.validateSelectedLimit(minimumCacheType);
        ValueSelector<Solution_> valueSelector = this.buildBaseValueSelector(variableDescriptor, SelectionCacheType.max(minimumCacheType, resolvedCacheType), this.determineBaseRandomSelection(variableDescriptor, resolvedCacheType, resolvedSelectionOrder));
        if (((ValueSelectorConfig)this.config).getNearbySelectionConfig() != null) {
            valueSelector = this.applyNearbySelection(configPolicy, ((ValueSelectorConfig)this.config).getNearbySelectionConfig(), minimumCacheType, resolvedSelectionOrder, valueSelector);
        }
        valueSelector = this.applyFiltering(valueSelector);
        valueSelector = this.applyInitializedChainedValueFilter(configPolicy, variableDescriptor, valueSelector);
        valueSelector = this.applySorting(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyProbability(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyShuffling(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyCaching(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applySelectedLimit(valueSelector);
        valueSelector = this.applyUnassignedValueFiltering(applyUnassignedValueFiltering, variableDescriptor, valueSelector);
        valueSelector = this.applyMimicRecording(configPolicy, valueSelector);
        valueSelector = this.applyReinitializeVariableFiltering(applyReinitializeVariableFiltering, variableDescriptor, valueSelector);
        valueSelector = this.applyDowncasting(valueSelector);
        return valueSelector;
    }

    protected ValueSelector<Solution_> buildMimicReplaying(HeuristicConfigPolicy<Solution_> configPolicy) {
        if (((ValueSelectorConfig)this.config).getId() != null || ((ValueSelectorConfig)this.config).getVariableName() != null || ((ValueSelectorConfig)this.config).getCacheType() != null || ((ValueSelectorConfig)this.config).getSelectionOrder() != null || ((ValueSelectorConfig)this.config).getNearbySelectionConfig() != null || ((ValueSelectorConfig)this.config).getFilterClass() != null || ((ValueSelectorConfig)this.config).getSorterManner() != null || ((ValueSelectorConfig)this.config).getSorterComparatorClass() != null || ((ValueSelectorConfig)this.config).getSorterWeightFactoryClass() != null || ((ValueSelectorConfig)this.config).getSorterOrder() != null || ((ValueSelectorConfig)this.config).getSorterClass() != null || ((ValueSelectorConfig)this.config).getProbabilityWeightFactoryClass() != null || ((ValueSelectorConfig)this.config).getSelectedCountLimit() != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with mimicSelectorRef (" + ((ValueSelectorConfig)this.config).getMimicSelectorRef() + ") has another property that is not null.");
        }
        ValueMimicRecorder<Solution_> valueMimicRecorder = configPolicy.getValueMimicRecorder(((ValueSelectorConfig)this.config).getMimicSelectorRef());
        if (valueMimicRecorder == null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") has a mimicSelectorRef (" + ((ValueSelectorConfig)this.config).getMimicSelectorRef() + ") for which no valueSelector with that id exists (in its solver phase).");
        }
        return new MimicReplayingValueSelector<Solution_>(valueMimicRecorder);
    }

    protected EntityDescriptor<Solution_> downcastEntityDescriptor(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor) {
        if (((ValueSelectorConfig)this.config).getDowncastEntityClass() != null) {
            Class<?> parentEntityClass = entityDescriptor.getEntityClass();
            if (!parentEntityClass.isAssignableFrom(((ValueSelectorConfig)this.config).getDowncastEntityClass())) {
                throw new IllegalStateException("The downcastEntityClass (" + ((ValueSelectorConfig)this.config).getDowncastEntityClass() + ") is not a subclass of the parentEntityClass (" + parentEntityClass + ") configured by the " + EntitySelector.class.getSimpleName() + ".");
            }
            SolutionDescriptor<Solution_> solutionDescriptor = configPolicy.getSolutionDescriptor();
            entityDescriptor = solutionDescriptor.getEntityDescriptorStrict(((ValueSelectorConfig)this.config).getDowncastEntityClass());
            if (entityDescriptor == null) {
                throw new IllegalArgumentException("The selectorConfig (" + this.config + ") has an downcastEntityClass (" + ((ValueSelectorConfig)this.config).getDowncastEntityClass() + ") that is not a known planning entity.\nCheck your solver configuration. If that class (" + ((ValueSelectorConfig)this.config).getDowncastEntityClass().getSimpleName() + ") is not in the entityClassSet (" + solutionDescriptor.getEntityClassSet() + "), check your @" + PlanningSolution.class.getSimpleName() + " implementation's annotated methods too.");
            }
        }
        return entityDescriptor;
    }

    protected boolean determineBaseRandomSelection(GenuineVariableDescriptor<Solution_> variableDescriptor, SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder) {
        switch (resolvedSelectionOrder) {
            case ORIGINAL: {
                return false;
            }
            case SORTED: 
            case SHUFFLED: 
            case PROBABILISTIC: {
                return false;
            }
            case RANDOM: {
                return resolvedCacheType.isNotCached() || this.isBaseInherentlyCached(variableDescriptor) && !this.hasFiltering(variableDescriptor);
            }
        }
        throw new IllegalStateException("The selectionOrder (" + resolvedSelectionOrder + ") is not implemented.");
    }

    protected boolean isBaseInherentlyCached(GenuineVariableDescriptor<Solution_> variableDescriptor) {
        return variableDescriptor.isValueRangeEntityIndependent();
    }

    private ValueSelector<Solution_> buildBaseValueSelector(GenuineVariableDescriptor<Solution_> variableDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        ValueRangeDescriptor<Solution_> valueRangeDescriptor = variableDescriptor.getValueRangeDescriptor();
        if (minimumCacheType == SelectionCacheType.SOLVER) {
            throw new IllegalArgumentException("The minimumCacheType (" + minimumCacheType + ") is not yet supported. Please use " + SelectionCacheType.PHASE + " instead.");
        }
        if (valueRangeDescriptor.isEntityIndependent()) {
            return new FromSolutionPropertyValueSelector((EntityIndependentValueRangeDescriptor)valueRangeDescriptor, minimumCacheType, randomSelection);
        }
        return new FromEntityPropertyValueSelector<Solution_>(valueRangeDescriptor, randomSelection);
    }

    private boolean hasFiltering(GenuineVariableDescriptor<Solution_> variableDescriptor) {
        return ((ValueSelectorConfig)this.config).getFilterClass() != null || variableDescriptor.hasMovableChainedTrailingValueFilter();
    }

    protected ValueSelector<Solution_> applyFiltering(ValueSelector<Solution_> valueSelector) {
        GenuineVariableDescriptor<Solution_> variableDescriptor = valueSelector.getVariableDescriptor();
        if (this.hasFiltering(variableDescriptor)) {
            ArrayList filterList = new ArrayList(((ValueSelectorConfig)this.config).getFilterClass() == null ? 1 : 2);
            if (((ValueSelectorConfig)this.config).getFilterClass() != null) {
                filterList.add(ConfigUtils.newInstance(this.config, "filterClass", ((ValueSelectorConfig)this.config).getFilterClass()));
            }
            if (variableDescriptor.hasMovableChainedTrailingValueFilter()) {
                filterList.add(variableDescriptor.getMovableChainedTrailingValueFilter());
            }
            valueSelector = FilteringValueSelector.create(valueSelector, filterList);
        }
        return valueSelector;
    }

    protected ValueSelector<Solution_> applyInitializedChainedValueFilter(HeuristicConfigPolicy<Solution_> configPolicy, GenuineVariableDescriptor<Solution_> variableDescriptor, ValueSelector<Solution_> valueSelector) {
        if (configPolicy.isInitializedChainedValueFilterEnabled() && variableDescriptor.isChained()) {
            valueSelector = InitializedValueSelector.create(valueSelector);
        }
        return valueSelector;
    }

    protected void validateSorting(SelectionOrder resolvedSelectionOrder) {
        if ((((ValueSelectorConfig)this.config).getSorterManner() != null || ((ValueSelectorConfig)this.config).getSorterComparatorClass() != null || ((ValueSelectorConfig)this.config).getSorterWeightFactoryClass() != null || ((ValueSelectorConfig)this.config).getSorterOrder() != null || ((ValueSelectorConfig)this.config).getSorterClass() != null) && resolvedSelectionOrder != SelectionOrder.SORTED) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with sorterManner (" + ((ValueSelectorConfig)this.config).getSorterManner() + ") and sorterComparatorClass (" + ((ValueSelectorConfig)this.config).getSorterComparatorClass() + ") and sorterWeightFactoryClass (" + ((ValueSelectorConfig)this.config).getSorterWeightFactoryClass() + ") and sorterOrder (" + ((ValueSelectorConfig)this.config).getSorterOrder() + ") and sorterClass (" + ((ValueSelectorConfig)this.config).getSorterClass() + ") has a resolvedSelectionOrder (" + resolvedSelectionOrder + ") that is not " + SelectionOrder.SORTED + ".");
        }
        if (((ValueSelectorConfig)this.config).getSorterManner() != null && ((ValueSelectorConfig)this.config).getSorterComparatorClass() != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") has both a sorterManner (" + ((ValueSelectorConfig)this.config).getSorterManner() + ") and a sorterComparatorClass (" + ((ValueSelectorConfig)this.config).getSorterComparatorClass() + ").");
        }
        if (((ValueSelectorConfig)this.config).getSorterManner() != null && ((ValueSelectorConfig)this.config).getSorterWeightFactoryClass() != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") has both a sorterManner (" + ((ValueSelectorConfig)this.config).getSorterManner() + ") and a sorterWeightFactoryClass (" + ((ValueSelectorConfig)this.config).getSorterWeightFactoryClass() + ").");
        }
        if (((ValueSelectorConfig)this.config).getSorterManner() != null && ((ValueSelectorConfig)this.config).getSorterClass() != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") has both a sorterManner (" + ((ValueSelectorConfig)this.config).getSorterManner() + ") and a sorterClass (" + ((ValueSelectorConfig)this.config).getSorterClass() + ").");
        }
        if (((ValueSelectorConfig)this.config).getSorterManner() != null && ((ValueSelectorConfig)this.config).getSorterOrder() != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with sorterManner (" + ((ValueSelectorConfig)this.config).getSorterManner() + ") has a non-null sorterOrder (" + ((ValueSelectorConfig)this.config).getSorterOrder() + ").");
        }
        if (((ValueSelectorConfig)this.config).getSorterComparatorClass() != null && ((ValueSelectorConfig)this.config).getSorterWeightFactoryClass() != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") has both a sorterComparatorClass (" + ((ValueSelectorConfig)this.config).getSorterComparatorClass() + ") and a sorterWeightFactoryClass (" + ((ValueSelectorConfig)this.config).getSorterWeightFactoryClass() + ").");
        }
        if (((ValueSelectorConfig)this.config).getSorterComparatorClass() != null && ((ValueSelectorConfig)this.config).getSorterClass() != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") has both a sorterComparatorClass (" + ((ValueSelectorConfig)this.config).getSorterComparatorClass() + ") and a sorterClass (" + ((ValueSelectorConfig)this.config).getSorterClass() + ").");
        }
        if (((ValueSelectorConfig)this.config).getSorterWeightFactoryClass() != null && ((ValueSelectorConfig)this.config).getSorterClass() != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") has both a sorterWeightFactoryClass (" + ((ValueSelectorConfig)this.config).getSorterWeightFactoryClass() + ") and a sorterClass (" + ((ValueSelectorConfig)this.config).getSorterClass() + ").");
        }
        if (((ValueSelectorConfig)this.config).getSorterClass() != null && ((ValueSelectorConfig)this.config).getSorterOrder() != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with sorterClass (" + ((ValueSelectorConfig)this.config).getSorterClass() + ") has a non-null sorterOrder (" + ((ValueSelectorConfig)this.config).getSorterOrder() + ").");
        }
    }

    protected ValueSelector<Solution_> applySorting(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector<Solution_> valueSelector) {
        if (resolvedSelectionOrder == SelectionOrder.SORTED) {
            WeightFactorySelectionSorter sorter;
            if (((ValueSelectorConfig)this.config).getSorterManner() != null) {
                GenuineVariableDescriptor<Solution_> variableDescriptor = valueSelector.getVariableDescriptor();
                if (!ValueSelectorConfig.hasSorter(((ValueSelectorConfig)this.config).getSorterManner(), variableDescriptor)) {
                    return valueSelector;
                }
                sorter = ValueSelectorConfig.determineSorter(((ValueSelectorConfig)this.config).getSorterManner(), variableDescriptor);
            } else if (((ValueSelectorConfig)this.config).getSorterComparatorClass() != null) {
                Comparator sorterComparator = ConfigUtils.newInstance(this.config, "sorterComparatorClass", ((ValueSelectorConfig)this.config).getSorterComparatorClass());
                sorter = new ComparatorSelectionSorter<Solution_, Object>(sorterComparator, SelectionSorterOrder.resolve(((ValueSelectorConfig)this.config).getSorterOrder()));
            } else if (((ValueSelectorConfig)this.config).getSorterWeightFactoryClass() != null) {
                SelectionSorterWeightFactory sorterWeightFactory = ConfigUtils.newInstance(this.config, "sorterWeightFactoryClass", ((ValueSelectorConfig)this.config).getSorterWeightFactoryClass());
                sorter = new WeightFactorySelectionSorter(sorterWeightFactory, SelectionSorterOrder.resolve(((ValueSelectorConfig)this.config).getSorterOrder()));
            } else if (((ValueSelectorConfig)this.config).getSorterClass() != null) {
                sorter = ConfigUtils.newInstance(this.config, "sorterClass", ((ValueSelectorConfig)this.config).getSorterClass());
            } else {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs a sorterManner (" + ((ValueSelectorConfig)this.config).getSorterManner() + ") or a sorterComparatorClass (" + ((ValueSelectorConfig)this.config).getSorterComparatorClass() + ") or a sorterWeightFactoryClass (" + ((ValueSelectorConfig)this.config).getSorterWeightFactoryClass() + ") or a sorterClass (" + ((ValueSelectorConfig)this.config).getSorterClass() + ").");
            }
            if (!valueSelector.getVariableDescriptor().isValueRangeEntityIndependent() && resolvedCacheType == SelectionCacheType.STEP) {
                valueSelector = new EntityDependentSortingValueSelector<Solution_>(valueSelector, resolvedCacheType, sorter);
            } else {
                if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                    throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with resolvedCacheType (" + resolvedCacheType + ") and resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
                }
                valueSelector = new SortingValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType, sorter);
            }
        }
        return valueSelector;
    }

    protected void validateProbability(SelectionOrder resolvedSelectionOrder) {
        if (((ValueSelectorConfig)this.config).getProbabilityWeightFactoryClass() != null && resolvedSelectionOrder != SelectionOrder.PROBABILISTIC) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with probabilityWeightFactoryClass (" + ((ValueSelectorConfig)this.config).getProbabilityWeightFactoryClass() + ") has a resolvedSelectionOrder (" + resolvedSelectionOrder + ") that is not " + SelectionOrder.PROBABILISTIC + ".");
        }
    }

    protected ValueSelector<Solution_> applyProbability(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector<Solution_> valueSelector) {
        if (resolvedSelectionOrder == SelectionOrder.PROBABILISTIC) {
            if (((ValueSelectorConfig)this.config).getProbabilityWeightFactoryClass() == null) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs a probabilityWeightFactoryClass (" + ((ValueSelectorConfig)this.config).getProbabilityWeightFactoryClass() + ").");
            }
            SelectionProbabilityWeightFactory probabilityWeightFactory = ConfigUtils.newInstance(this.config, "probabilityWeightFactoryClass", ((ValueSelectorConfig)this.config).getProbabilityWeightFactoryClass());
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with resolvedCacheType (" + resolvedCacheType + ") and resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new ProbabilityValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType, probabilityWeightFactory);
        }
        return valueSelector;
    }

    private ValueSelector<Solution_> applyShuffling(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector<Solution_> valueSelector) {
        if (resolvedSelectionOrder == SelectionOrder.SHUFFLED) {
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with resolvedCacheType (" + resolvedCacheType + ") and resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new ShufflingValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType);
        }
        return valueSelector;
    }

    private ValueSelector<Solution_> applyCaching(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector<Solution_> valueSelector) {
        if (resolvedCacheType.isCached() && resolvedCacheType.compareTo(valueSelector.getCacheType()) > 0) {
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with resolvedCacheType (" + resolvedCacheType + ") and resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new CachingValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType, resolvedSelectionOrder.toRandomSelectionBoolean());
        }
        return valueSelector;
    }

    private void validateSelectedLimit(SelectionCacheType minimumCacheType) {
        if (((ValueSelectorConfig)this.config).getSelectedCountLimit() != null && minimumCacheType.compareTo(SelectionCacheType.JUST_IN_TIME) > 0) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with selectedCountLimit (" + ((ValueSelectorConfig)this.config).getSelectedCountLimit() + ") has a minimumCacheType (" + minimumCacheType + ") that is higher than " + SelectionCacheType.JUST_IN_TIME + ".");
        }
    }

    private ValueSelector<Solution_> applySelectedLimit(ValueSelector<Solution_> valueSelector) {
        if (((ValueSelectorConfig)this.config).getSelectedCountLimit() != null) {
            valueSelector = new SelectedCountLimitValueSelector<Solution_>(valueSelector, ((ValueSelectorConfig)this.config).getSelectedCountLimit());
        }
        return valueSelector;
    }

    private ValueSelector<Solution_> applyNearbySelection(HeuristicConfigPolicy<Solution_> configPolicy, NearbySelectionConfig nearbySelectionConfig, SelectionCacheType minimumCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector<Solution_> valueSelector) {
        boolean randomSelection = resolvedSelectionOrder.toRandomSelectionBoolean();
        EntitySelectorFactory<Solution_> entitySelectorFactory = EntitySelectorFactory.create(nearbySelectionConfig.getOriginEntitySelectorConfig());
        EntitySelector originEntitySelector = entitySelectorFactory.buildEntitySelector(configPolicy, minimumCacheType, resolvedSelectionOrder);
        NearbyDistanceMeter nearbyDistanceMeter = ConfigUtils.newInstance(nearbySelectionConfig, "nearbyDistanceMeterClass", nearbySelectionConfig.getNearbyDistanceMeterClass());
        NearbyRandom nearbyRandom = NearbyRandomFactory.create(((ValueSelectorConfig)this.config).getNearbySelectionConfig()).buildNearbyRandom(randomSelection);
        return new NearEntityNearbyValueSelector<Solution_>(valueSelector, originEntitySelector, nearbyDistanceMeter, nearbyRandom, randomSelection);
    }

    private ValueSelector<Solution_> applyMimicRecording(HeuristicConfigPolicy<Solution_> configPolicy, ValueSelector<Solution_> valueSelector) {
        if (((ValueSelectorConfig)this.config).getId() != null) {
            if (((ValueSelectorConfig)this.config).getId().isEmpty()) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") has an empty id (" + ((ValueSelectorConfig)this.config).getId() + ").");
            }
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with id (" + ((ValueSelectorConfig)this.config).getId() + ") needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            MimicRecordingValueSelector mimicRecordingValueSelector = new MimicRecordingValueSelector((EntityIndependentValueSelector)valueSelector);
            configPolicy.addValueMimicRecorder(((ValueSelectorConfig)this.config).getId(), mimicRecordingValueSelector);
            valueSelector = mimicRecordingValueSelector;
        }
        return valueSelector;
    }

    private ValueSelector<Solution_> applyUnassignedValueFiltering(boolean applyUnassignedValueFiltering, GenuineVariableDescriptor<Solution_> variableDescriptor, ValueSelector<Solution_> valueSelector) {
        if (applyUnassignedValueFiltering && variableDescriptor.isListVariable()) {
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with id (" + ((ValueSelectorConfig)this.config).getId() + ") needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new UnassignedValueSelector((EntityIndependentValueSelector)valueSelector);
        }
        return valueSelector;
    }

    private ValueSelector<Solution_> applyReinitializeVariableFiltering(boolean applyReinitializeVariableFiltering, GenuineVariableDescriptor<Solution_> variableDescriptor, ValueSelector<Solution_> valueSelector) {
        if (applyReinitializeVariableFiltering && !variableDescriptor.isListVariable()) {
            valueSelector = new ReinitializeVariableValueSelector<Solution_>(valueSelector);
        }
        return valueSelector;
    }

    private ValueSelector<Solution_> applyDowncasting(ValueSelector<Solution_> valueSelector) {
        if (((ValueSelectorConfig)this.config).getDowncastEntityClass() != null) {
            valueSelector = new DowncastingValueSelector<Solution_>(valueSelector, ((ValueSelectorConfig)this.config).getDowncastEntityClass());
        }
        return valueSelector;
    }
}

