/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.common.AbstractJoinNode;
import org.optaplanner.constraint.streams.bavet.common.LeftTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.RightTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;
import org.optaplanner.core.impl.util.FieldBasedScalingMap;

public abstract class AbstractIndexedJoinNode<LeftTuple_ extends Tuple, Right_, OutTuple_ extends Tuple, MutableOutTuple_ extends OutTuple_>
extends AbstractJoinNode<LeftTuple_, Right_, OutTuple_, MutableOutTuple_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final Function<Right_, IndexProperties> mappingRight;
    private final int inputStoreIndexLeft;
    private final int inputStoreIndexRight;
    private final Indexer<LeftTuple_, Map<UniTuple<Right_>, MutableOutTuple_>> indexerLeft;
    private final Indexer<UniTuple<Right_>, Map<LeftTuple_, MutableOutTuple_>> indexerRight;

    protected AbstractIndexedJoinNode(Function<Right_, IndexProperties> mappingRight, int inputStoreIndexLeft, int inputStoreIndexRight, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, Indexer<LeftTuple_, Map<UniTuple<Right_>, MutableOutTuple_>> indexerLeft, Indexer<UniTuple<Right_>, Map<LeftTuple_, MutableOutTuple_>> indexerRight) {
        super(nextNodesTupleLifecycle);
        this.mappingRight = mappingRight;
        this.inputStoreIndexLeft = inputStoreIndexLeft;
        this.inputStoreIndexRight = inputStoreIndexRight;
        this.indexerLeft = indexerLeft;
        this.indexerRight = indexerRight;
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (leftTuple.getStore(this.inputStoreIndexLeft) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + leftTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.createIndexPropertiesLeft(leftTuple);
        leftTuple.setStore(this.inputStoreIndexLeft, indexProperties);
        FieldBasedScalingMap outTupleMapLeft = new FieldBasedScalingMap(LinkedHashMap::new);
        this.indexAndPropagateLeft(leftTuple, indexProperties, (Map<UniTuple<Right_>, MutableOutTuple_>)outTupleMapLeft);
    }

    private void indexAndPropagateLeft(LeftTuple_ leftTuple, IndexProperties newIndexProperties, Map<UniTuple<Right_>, MutableOutTuple_> outTupleMapLeft) {
        this.indexerLeft.put(newIndexProperties, leftTuple, outTupleMapLeft);
        this.indexerRight.visit(newIndexProperties, (rightTuple, emptyMap) -> this.insertTuple(outTupleMapLeft, leftTuple, rightTuple));
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        IndexProperties oldIndexProperties = (IndexProperties)leftTuple.getStore(this.inputStoreIndexLeft);
        if (oldIndexProperties == null) {
            this.insertLeft(leftTuple);
            return;
        }
        IndexProperties newIndexProperties = this.createIndexPropertiesLeft(leftTuple);
        if (oldIndexProperties.equals(newIndexProperties)) {
            Map<UniTuple<Right_>, MutableOutTuple_> outTupleMapLeft = this.indexerLeft.get(oldIndexProperties, leftTuple);
            for (Tuple outTuple : outTupleMapLeft.values()) {
                this.updateOutTupleLeft(outTuple, leftTuple);
                this.updateTuple(outTuple);
            }
        } else {
            Map<UniTuple<Right_>, MutableOutTuple_> outTupleMapLeft = this.indexerLeft.remove(oldIndexProperties, leftTuple);
            for (Tuple outTuple : outTupleMapLeft.values()) {
                this.retractTuple(outTuple);
            }
            outTupleMapLeft.clear();
            leftTuple.setStore(this.inputStoreIndexLeft, newIndexProperties);
            this.indexAndPropagateLeft(leftTuple, newIndexProperties, outTupleMapLeft);
        }
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        IndexProperties indexProperties = (IndexProperties)leftTuple.getStore(this.inputStoreIndexLeft);
        if (indexProperties == null) {
            return;
        }
        leftTuple.setStore(this.inputStoreIndexLeft, null);
        Map<UniTuple<Right_>, MutableOutTuple_> outTupleMapLeft = this.indexerLeft.remove(indexProperties, leftTuple);
        for (Tuple outTuple : outTupleMapLeft.values()) {
            this.retractTuple(outTuple);
        }
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRight) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + rightTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingRight.apply(rightTuple.getFactA());
        rightTuple.setStore(this.inputStoreIndexRight, indexProperties);
        this.indexAndPropagateRight(rightTuple, indexProperties);
    }

    private void indexAndPropagateRight(UniTuple<Right_> rightTuple, IndexProperties indexProperties) {
        this.indexerRight.put(indexProperties, rightTuple, Collections.emptyMap());
        this.indexerLeft.visit(indexProperties, (leftTuple, outTupleMapLeft) -> this.insertTuple(outTupleMapLeft, leftTuple, rightTuple));
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        IndexProperties oldIndexProperties = (IndexProperties)rightTuple.getStore(this.inputStoreIndexRight);
        if (oldIndexProperties == null) {
            this.insertRight(rightTuple);
            return;
        }
        IndexProperties newIndexProperties = this.mappingRight.apply(rightTuple.getFactA());
        if (oldIndexProperties.equals(newIndexProperties)) {
            this.indexerLeft.visit(oldIndexProperties, (leftTuple, outTupleMapLeft) -> {
                Tuple outTuple = (Tuple)outTupleMapLeft.get(rightTuple);
                this.updateOutTupleRight(outTuple, rightTuple);
                if (outTuple == null) {
                    throw new IllegalStateException("Impossible state: the tuple (" + leftTuple + ") with indexProperties (" + oldIndexProperties + ") has tuples on the right side that didn't exist on the left side.");
                }
                this.updateTuple(outTuple);
            });
        } else {
            this.deindexRightTuple(oldIndexProperties, rightTuple);
            rightTuple.setStore(this.inputStoreIndexRight, newIndexProperties);
            this.indexAndPropagateRight(rightTuple, newIndexProperties);
        }
    }

    private void deindexRightTuple(IndexProperties indexProperties, UniTuple<Right_> rightTuple) {
        this.indexerRight.remove(indexProperties, rightTuple);
        this.indexerLeft.visit(indexProperties, (leftTuple, outTupleMapLeft) -> {
            Tuple outTuple = (Tuple)outTupleMapLeft.remove(rightTuple);
            if (outTuple == null) {
                throw new IllegalStateException("Impossible state: the tuple (" + leftTuple + ") with indexProperties (" + indexProperties + ") has tuples on the right side that didn't exist on the left side.");
            }
            this.retractTuple(outTuple);
        });
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        IndexProperties indexProperties = (IndexProperties)rightTuple.getStore(this.inputStoreIndexRight);
        if (indexProperties == null) {
            return;
        }
        rightTuple.setStore(this.inputStoreIndexRight, null);
        this.deindexRightTuple(indexProperties, rightTuple);
    }

    protected abstract IndexProperties createIndexPropertiesLeft(LeftTuple_ var1);
}

