/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.core.impl.score.stream.JoinerType;

final class ComparisonIndexer<Tuple_ extends Tuple, Value_, Key_ extends Comparable<Key_>>
implements Indexer<Tuple_, Value_> {
    private final int indexKeyPosition;
    private final Supplier<Indexer<Tuple_, Value_>> downstreamIndexerSupplier;
    private final Comparator<Key_> keyComparator;
    private final boolean hasOrEquals;
    private final NavigableMap<Key_, Indexer<Tuple_, Value_>> comparisonMap;

    public ComparisonIndexer(JoinerType comparisonJoinerType, Supplier<Indexer<Tuple_, Value_>> downstreamIndexerSupplier) {
        this(comparisonJoinerType, 0, downstreamIndexerSupplier);
    }

    public ComparisonIndexer(JoinerType comparisonJoinerType, int indexKeyPosition, Supplier<Indexer<Tuple_, Value_>> downstreamIndexerSupplier) {
        this.indexKeyPosition = indexKeyPosition;
        this.downstreamIndexerSupplier = Objects.requireNonNull(downstreamIndexerSupplier);
        this.keyComparator = comparisonJoinerType == JoinerType.GREATER_THAN || comparisonJoinerType == JoinerType.GREATER_THAN_OR_EQUAL ? KeyComparator.INSTANCE.reversed() : KeyComparator.INSTANCE;
        this.hasOrEquals = comparisonJoinerType == JoinerType.GREATER_THAN_OR_EQUAL || comparisonJoinerType == JoinerType.LESS_THAN_OR_EQUAL;
        this.comparisonMap = new TreeMap<Key_, Indexer<Tuple_, Value_>>(this.keyComparator);
    }

    @Override
    public void visit(IndexProperties indexProperties, BiConsumer<Tuple_, Value_> tupleValueVisitor) {
        int size = this.comparisonMap.size();
        if (size == 0) {
            return;
        }
        Comparable indexKey = (Comparable)indexProperties.toKey(this.indexKeyPosition);
        if (size == 1) {
            Map.Entry<Key_, Indexer<Tuple_, Value_>> entry = this.comparisonMap.firstEntry();
            this.visitEntry(indexProperties, tupleValueVisitor, indexKey, entry);
        } else {
            for (Map.Entry entry : this.comparisonMap.entrySet()) {
                boolean boundaryReached = this.visitEntry(indexProperties, tupleValueVisitor, indexKey, entry);
                if (!boundaryReached) continue;
                return;
            }
        }
    }

    private boolean visitEntry(IndexProperties indexProperties, BiConsumer<Tuple_, Value_> tupleValueVisitor, Key_ indexKey, Map.Entry<Key_, Indexer<Tuple_, Value_>> entry) {
        int comparison = this.keyComparator.compare((Comparable)entry.getKey(), indexKey);
        if (!(comparison < 0 || comparison <= 0 && this.hasOrEquals)) {
            return true;
        }
        entry.getValue().visit(indexProperties, tupleValueVisitor);
        return false;
    }

    @Override
    public Value_ get(IndexProperties indexProperties, Tuple_ tuple) {
        Comparable indexKey = (Comparable)indexProperties.toKey(this.indexKeyPosition);
        Indexer<Tuple_, Value_> downstreamIndexer = this.getDownstreamIndexer(indexProperties, indexKey, tuple);
        return downstreamIndexer.get(indexProperties, tuple);
    }

    @Override
    public void put(IndexProperties indexProperties, Tuple_ tuple, Value_ value) {
        Comparable indexKey = (Comparable)indexProperties.toKey(this.indexKeyPosition);
        Indexer<Tuple_, Value_> downstreamIndexer = (Indexer<Tuple_, Value_>)this.comparisonMap.get(indexKey);
        if (downstreamIndexer == null) {
            downstreamIndexer = this.downstreamIndexerSupplier.get();
            this.comparisonMap.put(indexKey, downstreamIndexer);
        }
        downstreamIndexer.put(indexProperties, tuple, value);
    }

    @Override
    public Value_ remove(IndexProperties indexProperties, Tuple_ tuple) {
        Comparable indexKey = (Comparable)indexProperties.toKey(this.indexKeyPosition);
        Indexer<Tuple_, Value_> downstreamIndexer = this.getDownstreamIndexer(indexProperties, indexKey, tuple);
        Value_ value = downstreamIndexer.remove(indexProperties, tuple);
        if (downstreamIndexer.isEmpty()) {
            this.comparisonMap.remove(indexKey);
        }
        return value;
    }

    private Indexer<Tuple_, Value_> getDownstreamIndexer(IndexProperties indexProperties, Key_ indexerKey, Tuple_ tuple) {
        Indexer downstreamIndexer = (Indexer)this.comparisonMap.get(indexerKey);
        if (downstreamIndexer == null) {
            throw new IllegalStateException("Impossible state: the tuple (" + tuple + ") with indexProperties (" + indexProperties + ") doesn't exist in the indexer " + this + ".");
        }
        return downstreamIndexer;
    }

    @Override
    public boolean isEmpty() {
        return this.comparisonMap.isEmpty();
    }

    private static final class KeyComparator<Key_ extends Comparable<Key_>>
    implements Comparator<Key_> {
        private static final Comparator INSTANCE = new KeyComparator();

        private KeyComparator() {
        }

        @Override
        public int compare(Key_ o1, Key_ o2) {
            if (o1 == o2) {
                return 0;
            }
            return o1.compareTo(o2);
        }
    }
}

