/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.ComparisonIndexer;
import org.optaplanner.constraint.streams.bavet.common.index.EqualsIndexer;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.common.index.NoneIndexer;
import org.optaplanner.constraint.streams.common.AbstractJoiner;
import org.optaplanner.core.impl.score.stream.JoinerType;

public class IndexerFactory {
    private final JoinerType[] joinerTypes;

    public IndexerFactory(AbstractJoiner joiner) {
        int joinerCount = joiner.getJoinerCount();
        this.joinerTypes = new JoinerType[joinerCount];
        for (int i = 0; i < joinerCount; ++i) {
            JoinerType joinerType = joiner.getJoinerType(i);
            switch (joinerType) {
                case EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported joiner type (" + joinerType + ").");
                }
            }
            this.joinerTypes[i] = joiner.getJoinerType(i);
        }
    }

    public boolean hasJoiners() {
        return this.joinerTypes.length > 0;
    }

    public <Tuple_ extends Tuple, Value_> Indexer<Tuple_, Value_> buildIndexer(boolean isLeftBridge) {
        if (this.joinerTypes.length == 0) {
            return new NoneIndexer();
        }
        if (this.joinerTypes.length == 1) {
            JoinerType joinerType = this.joinerTypes[0];
            if (joinerType == JoinerType.EQUAL) {
                return new EqualsIndexer(NoneIndexer::new);
            }
            return new ComparisonIndexer(isLeftBridge ? joinerType : joinerType.flip(), NoneIndexer::new);
        }
        TreeMap<Integer, JoinerType> joinerTypeMap = new TreeMap<Integer, JoinerType>();
        for (int i = 1; i <= this.joinerTypes.length; ++i) {
            JoinerType joinerType = i < this.joinerTypes.length ? this.joinerTypes[i] : null;
            JoinerType previousJoinerType = this.joinerTypes[i - 1];
            if (joinerType == JoinerType.EQUAL && previousJoinerType == joinerType) continue;
            joinerTypeMap.put(i, previousJoinerType);
        }
        NavigableMap descendingJoinerTypeMap = joinerTypeMap.descendingMap();
        Supplier<Indexer> downstreamIndexerSupplier = NoneIndexer::new;
        for (Map.Entry entry : descendingJoinerTypeMap.entrySet()) {
            Integer endingPropertyExclusive = (Integer)entry.getKey();
            Integer previousEndingPropertyExclusiveOrNull = descendingJoinerTypeMap.higherKey(endingPropertyExclusive);
            int previousEndingPropertyExclusive = previousEndingPropertyExclusiveOrNull == null ? 0 : previousEndingPropertyExclusiveOrNull;
            JoinerType joinerType = (JoinerType)entry.getValue();
            Supplier<Indexer> actualDownstreamIndexerSupplier = downstreamIndexerSupplier;
            if (joinerType == JoinerType.EQUAL) {
                if (endingPropertyExclusive <= previousEndingPropertyExclusive) {
                    throw new IllegalStateException("Impossible state: index key ending position <= starting position (" + endingPropertyExclusive + " <= " + previousEndingPropertyExclusive + ")");
                }
                downstreamIndexerSupplier = () -> new EqualsIndexer(previousEndingPropertyExclusive, endingPropertyExclusive, actualDownstreamIndexerSupplier);
                continue;
            }
            JoinerType actualJoinerType = isLeftBridge ? joinerType : joinerType.flip();
            downstreamIndexerSupplier = () -> new ComparisonIndexer(actualJoinerType, previousEndingPropertyExclusive, actualDownstreamIndexerSupplier);
        }
        return downstreamIndexerSupplier.get();
    }
}

