/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.ManyIndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.NoneIndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.SingleIndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.ThreeIndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.TwoIndexProperties;
import org.optaplanner.constraint.streams.common.AbstractJoiner;
import org.optaplanner.constraint.streams.common.bi.DefaultBiJoiner;
import org.optaplanner.constraint.streams.common.penta.DefaultPentaJoiner;
import org.optaplanner.constraint.streams.common.quad.DefaultQuadJoiner;
import org.optaplanner.constraint.streams.common.tri.DefaultTriJoiner;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.TriFunction;

public final class JoinerUtils {
    private JoinerUtils() {
    }

    public static <A, B> Function<A, IndexProperties> combineLeftMappings(DefaultBiJoiner<A, B> joiner) {
        int joinerCount = joiner.getJoinerCount();
        switch (joinerCount) {
            case 0: {
                return a -> NoneIndexProperties.INSTANCE;
            }
            case 1: {
                Function mapping = joiner.getLeftMapping(0);
                return a -> new SingleIndexProperties(mapping.apply(a));
            }
            case 2: {
                Function mappingX = joiner.getLeftMapping(0);
                Function mappingY = joiner.getLeftMapping(1);
                return a -> new TwoIndexProperties(mappingX.apply(a), mappingY.apply(a));
            }
            case 3: {
                Function mapping1 = joiner.getLeftMapping(0);
                Function mapping2 = joiner.getLeftMapping(1);
                Function mapping3 = joiner.getLeftMapping(2);
                return a -> new ThreeIndexProperties(mapping1.apply(a), mapping2.apply(a), mapping3.apply(a));
            }
        }
        return a -> {
            Object[] mappings = new Object[joinerCount];
            for (int i = 0; i < joinerCount; ++i) {
                mappings[i] = joiner.getLeftMapping(i).apply(a);
            }
            return new ManyIndexProperties(mappings);
        };
    }

    public static <A, B, C> BiFunction<A, B, IndexProperties> combineLeftMappings(DefaultTriJoiner<A, B, C> joiner) {
        int joinerCount = joiner.getJoinerCount();
        switch (joinerCount) {
            case 0: {
                return (a, b) -> NoneIndexProperties.INSTANCE;
            }
            case 1: {
                BiFunction mapping = joiner.getLeftMapping(0);
                return (a, b) -> new SingleIndexProperties(mapping.apply(a, b));
            }
            case 2: {
                BiFunction mappingX = joiner.getLeftMapping(0);
                BiFunction mappingY = joiner.getLeftMapping(1);
                return (a, b) -> new TwoIndexProperties(mappingX.apply(a, b), mappingY.apply(a, b));
            }
            case 3: {
                BiFunction mapping1 = joiner.getLeftMapping(0);
                BiFunction mapping2 = joiner.getLeftMapping(1);
                BiFunction mapping3 = joiner.getLeftMapping(2);
                return (a, b) -> new ThreeIndexProperties(mapping1.apply(a, b), mapping2.apply(a, b), mapping3.apply(a, b));
            }
        }
        return (a, b) -> {
            Object[] mappings = new Object[joinerCount];
            for (int i = 0; i < joinerCount; ++i) {
                mappings[i] = joiner.getLeftMapping(i).apply(a, b);
            }
            return new ManyIndexProperties(mappings);
        };
    }

    public static <A, B, C, D> TriFunction<A, B, C, IndexProperties> combineLeftMappings(DefaultQuadJoiner<A, B, C, D> joiner) {
        int joinerCount = joiner.getJoinerCount();
        switch (joinerCount) {
            case 0: {
                return (a, b, c) -> NoneIndexProperties.INSTANCE;
            }
            case 1: {
                TriFunction mapping = joiner.getLeftMapping(0);
                return (a, b, c) -> new SingleIndexProperties(mapping.apply(a, b, c));
            }
            case 2: {
                TriFunction mappingX = joiner.getLeftMapping(0);
                TriFunction mappingY = joiner.getLeftMapping(1);
                return (a, b, c) -> new TwoIndexProperties(mappingX.apply(a, b, c), mappingY.apply(a, b, c));
            }
            case 3: {
                TriFunction mapping1 = joiner.getLeftMapping(0);
                TriFunction mapping2 = joiner.getLeftMapping(1);
                TriFunction mapping3 = joiner.getLeftMapping(2);
                return (a, b, c) -> new ThreeIndexProperties(mapping1.apply(a, b, c), mapping2.apply(a, b, c), mapping3.apply(a, b, c));
            }
        }
        return (a, b, c) -> {
            Object[] mappings = new Object[joinerCount];
            for (int i = 0; i < joinerCount; ++i) {
                mappings[i] = joiner.getLeftMapping(i).apply(a, b, c);
            }
            return new ManyIndexProperties(mappings);
        };
    }

    public static <A, B, C, D, E> QuadFunction<A, B, C, D, IndexProperties> combineLeftMappings(DefaultPentaJoiner<A, B, C, D, E> joiner) {
        int joinerCount = joiner.getJoinerCount();
        switch (joinerCount) {
            case 0: {
                return (a, b, c, d) -> NoneIndexProperties.INSTANCE;
            }
            case 1: {
                QuadFunction mapping = joiner.getLeftMapping(0);
                return (a, b, c, d) -> new SingleIndexProperties(mapping.apply(a, b, c, d));
            }
            case 2: {
                QuadFunction mappingX = joiner.getLeftMapping(0);
                QuadFunction mappingY = joiner.getLeftMapping(1);
                return (a, b, c, d) -> new TwoIndexProperties(mappingX.apply(a, b, c, d), mappingY.apply(a, b, c, d));
            }
            case 3: {
                QuadFunction mapping1 = joiner.getLeftMapping(0);
                QuadFunction mapping2 = joiner.getLeftMapping(1);
                QuadFunction mapping3 = joiner.getLeftMapping(2);
                return (a, b, c, d) -> new ThreeIndexProperties(mapping1.apply(a, b, c, d), mapping2.apply(a, b, c, d), mapping3.apply(a, b, c, d));
            }
        }
        return (a, b, c, d) -> {
            Object[] mappings = new Object[joinerCount];
            for (int i = 0; i < joinerCount; ++i) {
                mappings[i] = joiner.getLeftMapping(i).apply(a, b, c, d);
            }
            return new ManyIndexProperties(mappings);
        };
    }

    public static <Right_> Function<Right_, IndexProperties> combineRightMappings(AbstractJoiner<Right_> joiner) {
        int joinerCount = joiner.getJoinerCount();
        switch (joinerCount) {
            case 0: {
                return right -> NoneIndexProperties.INSTANCE;
            }
            case 1: {
                Function mapping = joiner.getRightMapping(0);
                return right -> new SingleIndexProperties(mapping.apply(right));
            }
            case 2: {
                Function mappingX = joiner.getRightMapping(0);
                Function mappingY = joiner.getRightMapping(1);
                return right -> new TwoIndexProperties(mappingX.apply(right), mappingY.apply(right));
            }
            case 3: {
                Function mapping1 = joiner.getRightMapping(0);
                Function mapping2 = joiner.getRightMapping(1);
                Function mapping3 = joiner.getRightMapping(2);
                return right -> new ThreeIndexProperties(mapping1.apply(right), mapping2.apply(right), mapping3.apply(right));
            }
        }
        return right -> {
            Object[] mappings = new Object[joinerCount];
            for (int i = 0; i < joinerCount; ++i) {
                mappings[i] = joiner.getRightMapping(i).apply(right);
            }
            return new ManyIndexProperties(mappings);
        };
    }
}

