/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools.quad;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.Function;
import org.optaplanner.constraint.streams.common.RetrievalSemantics;
import org.optaplanner.constraint.streams.common.ScoreImpactType;
import org.optaplanner.constraint.streams.common.quad.InnerQuadConstraintStream;
import org.optaplanner.constraint.streams.common.quad.QuadConstraintBuilderImpl;
import org.optaplanner.constraint.streams.drools.DroolsConstraintFactory;
import org.optaplanner.constraint.streams.drools.bi.DroolsGroupingBiConstraintStream;
import org.optaplanner.constraint.streams.drools.common.DroolsAbstractConstraintStream;
import org.optaplanner.constraint.streams.drools.common.QuadLeftHandSide;
import org.optaplanner.constraint.streams.drools.common.RuleBuilder;
import org.optaplanner.constraint.streams.drools.quad.DroolsExistsQuadConstraintStream;
import org.optaplanner.constraint.streams.drools.quad.DroolsFilterQuadConstraintStream;
import org.optaplanner.constraint.streams.drools.quad.DroolsFlatteningQuadConstraintStream;
import org.optaplanner.constraint.streams.drools.quad.DroolsGroupingQuadConstraintStream;
import org.optaplanner.constraint.streams.drools.tri.DroolsGroupingTriConstraintStream;
import org.optaplanner.constraint.streams.drools.uni.DroolsGroupingUniConstraintStream;
import org.optaplanner.constraint.streams.drools.uni.DroolsMappingUniConstraintStream;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.penta.PentaJoiner;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintBuilder;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;

public abstract class DroolsAbstractQuadConstraintStream<Solution_, A, B, C, D>
extends DroolsAbstractConstraintStream<Solution_>
implements InnerQuadConstraintStream<A, B, C, D> {
    public DroolsAbstractQuadConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, RetrievalSemantics retrievalSemantics) {
        super(constraintFactory, retrievalSemantics);
    }

    public QuadConstraintStream<A, B, C, D> filter(QuadPredicate<A, B, C, D> predicate) {
        DroolsFilterQuadConstraintStream stream = new DroolsFilterQuadConstraintStream(this.constraintFactory, this, predicate);
        this.addChildStream(stream);
        return stream;
    }

    @SafeVarargs
    public final <E> QuadConstraintStream<A, B, C, D> ifExists(Class<E> otherClass, PentaJoiner<A, B, C, D, E> ... joiners) {
        return this.ifExistsOrNot(true, this.getRetrievalSemantics() != RetrievalSemantics.STANDARD, otherClass, joiners);
    }

    @SafeVarargs
    public final <E> QuadConstraintStream<A, B, C, D> ifExistsIncludingNullVars(Class<E> otherClass, PentaJoiner<A, B, C, D, E> ... joiners) {
        return this.ifExistsOrNot(true, true, otherClass, joiners);
    }

    @SafeVarargs
    public final <E> QuadConstraintStream<A, B, C, D> ifNotExists(Class<E> otherClass, PentaJoiner<A, B, C, D, E> ... joiners) {
        return this.ifExistsOrNot(false, this.getRetrievalSemantics() != RetrievalSemantics.STANDARD, otherClass, joiners);
    }

    @SafeVarargs
    public final <E> QuadConstraintStream<A, B, C, D> ifNotExistsIncludingNullVars(Class<E> otherClass, PentaJoiner<A, B, C, D, E> ... joiners) {
        return this.ifExistsOrNot(false, true, otherClass, joiners);
    }

    @SafeVarargs
    private <E> QuadConstraintStream<A, B, C, D> ifExistsOrNot(boolean shouldExist, boolean shouldIncludeNullVars, Class<E> otherClass, PentaJoiner<A, B, C, D, E> ... joiners) {
        this.getConstraintFactory().assertValidFromType(otherClass);
        DroolsExistsQuadConstraintStream stream = new DroolsExistsQuadConstraintStream(this.constraintFactory, this, shouldExist, shouldIncludeNullVars, otherClass, joiners);
        this.addChildStream(stream);
        return stream;
    }

    public <ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> collector) {
        DroolsGroupingUniConstraintStream stream = new DroolsGroupingUniConstraintStream(this.constraintFactory, this, collector);
        this.addChildStream(stream);
        return stream;
    }

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_> BiConstraintStream<ResultA_, ResultB_> groupBy(QuadConstraintCollector<A, B, C, D, ResultContainerA_, ResultA_> collectorA, QuadConstraintCollector<A, B, C, D, ResultContainerB_, ResultB_> collectorB) {
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, collectorA, collectorB);
        this.addChildStream(stream);
        return stream;
    }

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<ResultA_, ResultB_, ResultC_> groupBy(QuadConstraintCollector<A, B, C, D, ResultContainerA_, ResultA_> collectorA, QuadConstraintCollector<A, B, C, D, ResultContainerB_, ResultB_> collectorB, QuadConstraintCollector<A, B, C, D, ResultContainerC_, ResultC_> collectorC) {
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, collectorA, collectorB, collectorC);
        this.addChildStream(stream);
        return stream;
    }

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> groupBy(QuadConstraintCollector<A, B, C, D, ResultContainerA_, ResultA_> collectorA, QuadConstraintCollector<A, B, C, D, ResultContainerB_, ResultB_> collectorB, QuadConstraintCollector<A, B, C, D, ResultContainerC_, ResultC_> collectorC, QuadConstraintCollector<A, B, C, D, ResultContainerD_, ResultD_> collectorD) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, collectorA, collectorB, collectorC, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(QuadFunction<A, B, C, D, GroupKey_> groupKeyMapping) {
        DroolsGroupingUniConstraintStream stream = new DroolsGroupingUniConstraintStream(this.constraintFactory, this, groupKeyMapping);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(QuadFunction<A, B, C, D, GroupKey_> groupKeyMapping, QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> collector) {
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, groupKeyMapping, collector);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<GroupKey_, ResultB_, ResultC_> groupBy(QuadFunction<A, B, C, D, GroupKey_> groupKeyMapping, QuadConstraintCollector<A, B, C, D, ResultContainerB_, ResultB_> collectorB, QuadConstraintCollector<A, B, C, D, ResultContainerC_, ResultC_> collectorC) {
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, groupKeyMapping, collectorB, collectorC);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKey_, ResultB_, ResultC_, ResultD_> groupBy(QuadFunction<A, B, C, D, GroupKey_> groupKeyMapping, QuadConstraintCollector<A, B, C, D, ResultContainerB_, ResultB_> collectorB, QuadConstraintCollector<A, B, C, D, ResultContainerC_, ResultC_> collectorC, QuadConstraintCollector<A, B, C, D, ResultContainerD_, ResultD_> collectorD) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyMapping, collectorB, collectorC, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(QuadFunction<A, B, C, D, GroupKeyA_> groupKeyAMapping, QuadFunction<A, B, C, D, GroupKeyB_> groupKeyBMapping) {
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(QuadFunction<A, B, C, D, GroupKeyA_> groupKeyAMapping, QuadFunction<A, B, C, D, GroupKeyB_> groupKeyBMapping, QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> collector) {
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, collector);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(QuadFunction<A, B, C, D, GroupKeyA_> groupKeyAMapping, QuadFunction<A, B, C, D, GroupKeyB_> groupKeyBMapping, QuadConstraintCollector<A, B, C, D, ResultContainerC_, ResultC_> collectorC, QuadConstraintCollector<A, B, C, D, ResultContainerD_, ResultD_> collectorD) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, collectorC, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_> TriConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_> groupBy(QuadFunction<A, B, C, D, GroupKeyA_> groupKeyAMapping, QuadFunction<A, B, C, D, GroupKeyB_> groupKeyBMapping, QuadFunction<A, B, C, D, GroupKeyC_> groupKeyCMapping) {
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, groupKeyCMapping);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultD_> groupBy(QuadFunction<A, B, C, D, GroupKeyA_> groupKeyAMapping, QuadFunction<A, B, C, D, GroupKeyB_> groupKeyBMapping, QuadFunction<A, B, C, D, GroupKeyC_> groupKeyCMapping, QuadConstraintCollector<A, B, C, D, ResultContainerD_, ResultD_> collectorD) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, groupKeyCMapping, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> groupBy(QuadFunction<A, B, C, D, GroupKeyA_> groupKeyAMapping, QuadFunction<A, B, C, D, GroupKeyB_> groupKeyBMapping, QuadFunction<A, B, C, D, GroupKeyC_> groupKeyCMapping, QuadFunction<A, B, C, D, GroupKeyD_> groupKeyDMapping) {
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, groupKeyCMapping, groupKeyDMapping);
        this.addChildStream(stream);
        return stream;
    }

    public <ResultA_> UniConstraintStream<ResultA_> map(QuadFunction<A, B, C, D, ResultA_> mapping) {
        DroolsMappingUniConstraintStream stream = new DroolsMappingUniConstraintStream(this.constraintFactory, this, Objects.requireNonNull(mapping));
        this.addChildStream(stream);
        return stream;
    }

    public <ResultD_> QuadConstraintStream<A, B, C, ResultD_> flattenLast(Function<D, Iterable<ResultD_>> mapping) {
        DroolsFlatteningQuadConstraintStream stream = new DroolsFlatteningQuadConstraintStream(this.constraintFactory, this, Objects.requireNonNull(mapping));
        this.addChildStream(stream);
        return stream;
    }

    public QuadConstraintBuilder<A, B, C, D> innerImpact(Score<?> constraintWeight, ToIntQuadFunction<A, B, C, D> matchWeigher, ScoreImpactType scoreImpactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.newTerminator(ruleBuilder, constraintWeight, scoreImpactType);
    }

    private QuadConstraintBuilderImpl<A, B, C, D> newTerminator(RuleBuilder<Solution_> ruleBuilder, Score<?> constraintWeight, ScoreImpactType impactType) {
        return new QuadConstraintBuilderImpl((constraintPackage, constraintName, constraintWeight_, impactType_) -> this.buildConstraint(constraintPackage, constraintName, constraintWeight_, impactType_, ruleBuilder), impactType, constraintWeight);
    }

    public QuadConstraintBuilder<A, B, C, D> innerImpact(Score<?> constraintWeight, ToLongQuadFunction<A, B, C, D> matchWeigher, ScoreImpactType scoreImpactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.newTerminator(ruleBuilder, constraintWeight, scoreImpactType);
    }

    public QuadConstraintBuilder<A, B, C, D> innerImpact(Score<?> constraintWeight, QuadFunction<A, B, C, D, BigDecimal> matchWeigher, ScoreImpactType scoreImpactType) {
        RuleBuilder ruleBuilder = this.getLeftHandSide().andTerminate(matchWeigher);
        return this.newTerminator(ruleBuilder, constraintWeight, scoreImpactType);
    }

    public abstract QuadLeftHandSide<A, B, C, D> getLeftHandSide();
}

