/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.score;

import java.util.function.Function;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.Period;
import org.optaplanner.examples.cheaptime.domain.Resource;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;
import org.optaplanner.examples.cheaptime.score.CheapTimeCostCalculator;
import org.optaplanner.examples.common.experimental.ExperimentalConstraintCollectors;
import org.optaplanner.examples.common.experimental.api.ConsecutiveIntervalInfo;

public class CheapTimeConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.startTimeLimitsFrom(constraintFactory), this.startTimeLimitsTo(constraintFactory), this.maximumCapacity(constraintFactory), this.activeMachinePowerCost(constraintFactory), this.activeMachineSpinUpAndDownCost(constraintFactory), this.idleCosts(constraintFactory), this.taskPowerCost(constraintFactory), this.startEarly(constraintFactory)};
    }

    protected Constraint startTimeLimitsFrom(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TaskAssignment.class).filter(taskAssignment -> taskAssignment.getStartPeriod() < taskAssignment.getTask().getStartPeriodRangeFrom()).penalizeLong((Score)HardMediumSoftLongScore.ONE_HARD, taskAssignment -> taskAssignment.getTask().getStartPeriodRangeFrom() - taskAssignment.getStartPeriod()).asConstraint("Task starts too early");
    }

    protected Constraint startTimeLimitsTo(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TaskAssignment.class).filter(taskAssignment -> taskAssignment.getStartPeriod() >= taskAssignment.getTask().getStartPeriodRangeTo()).penalizeLong((Score)HardMediumSoftLongScore.ONE_HARD, taskAssignment -> taskAssignment.getStartPeriod() - taskAssignment.getTask().getStartPeriodRangeTo()).asConstraint("Task starts too late");
    }

    protected Constraint maximumCapacity(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TaskAssignment.class).join(Resource.class, Joiners.filtering((taskAssignment, resource) -> taskAssignment.getTask().getUsage((Resource)resource) > 0)).join(Period.class, Joiners.overlapping((taskAssignment, resource) -> taskAssignment.getStartPeriod(), (taskAssignment, resource) -> taskAssignment.getEndPeriod(), Period::getIndex, period -> period.getIndex() + 1)).groupBy((taskAssignment, resource, period) -> period, (taskAssignment, resource, period) -> resource, (taskAssignment, resource, period) -> taskAssignment.getMachine(), ConstraintCollectors.sum((taskAssignment, resource, period) -> taskAssignment.getTask().getUsage((Resource)resource))).filter((period, resource, machine, usage) -> machine.getCapacity((Resource)resource) < usage).penalizeLong((Score)HardMediumSoftLongScore.ONE_HARD, (period, resource, machine, usage) -> usage - machine.getCapacity((Resource)resource)).asConstraint("Maximum resource capacity");
    }

    protected Constraint activeMachinePowerCost(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Period.class).join(Machine.class).ifExists(TaskAssignment.class, Joiners.equal((period, machine) -> machine, TaskAssignment::getMachine), Joiners.overlapping((period, machine) -> period.getIndex(), (period, machine) -> period.getIndex() + 1, TaskAssignment::getStartPeriod, TaskAssignment::getEndPeriod)).penalizeLong((Score)HardMediumSoftLongScore.ONE_MEDIUM, (period, machine) -> CheapTimeCostCalculator.multiplyTwoMicros(machine.getPowerConsumptionMicros(), period.getPowerPriceMicros())).asConstraint("Active machine power cost");
    }

    protected Constraint activeMachineSpinUpAndDownCost(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Machine.class).ifExists(TaskAssignment.class, Joiners.equal(Function.identity(), TaskAssignment::getMachine)).penalizeLong((Score)HardMediumSoftLongScore.ONE_MEDIUM, Machine::getSpinUpDownCostMicros).asConstraint("Active machine spin up and down cost");
    }

    protected Constraint idleCosts(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TaskAssignment.class).groupBy(TaskAssignment::getMachine, ExperimentalConstraintCollectors.consecutiveIntervals(TaskAssignment::getStartPeriod, TaskAssignment::getEndPeriod, (a, b) -> b - a)).flattenLast(ConsecutiveIntervalInfo::getBreaks).join(Period.class, Joiners.overlapping((machine, brk) -> (Integer)brk.getPreviousIntervalClusterEnd(), (machine, brk) -> (Integer)brk.getNextIntervalClusterStart(), Period::getIndex, period -> period.getIndex() + 1)).groupBy((machine, brk, idlePeriod) -> machine, (machine, brk, idlePeriod) -> brk, ConstraintCollectors.sumLong((machine, brk, idlePeriod) -> idlePeriod.getPowerPriceMicros())).penalizeLong((Score)HardMediumSoftLongScore.ONE_MEDIUM, (machine, brk, powerCost) -> {
            long idleCost = CheapTimeCostCalculator.multiplyTwoMicros(machine.getPowerConsumptionMicros(), powerCost);
            return Math.min(idleCost, machine.getSpinUpDownCostMicros());
        }).asConstraint("Machine idle costs");
    }

    protected Constraint taskPowerCost(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TaskAssignment.class).join(Period.class, Joiners.overlapping(TaskAssignment::getStartPeriod, TaskAssignment::getEndPeriod, Period::getIndex, period -> period.getIndex() + 1)).penalizeLong((Score)HardMediumSoftLongScore.ONE_MEDIUM, (taskAssignment, period) -> CheapTimeCostCalculator.multiplyTwoMicros(taskAssignment.getTask().getPowerConsumptionMicros(), period.getPowerPriceMicros())).asConstraint("Task power cost");
    }

    protected Constraint startEarly(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TaskAssignment.class).penalize((Score)HardMediumSoftLongScore.ONE_SOFT, TaskAssignment::getStartPeriod).asConstraint("Prefer early task start");
    }
}

