/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.taskassigning.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.examples.taskassigning.domain.Employee;
import org.optaplanner.examples.taskassigning.domain.Priority;
import org.optaplanner.examples.taskassigning.domain.Task;

public final class TaskAssigningConstraintProvider
implements ConstraintProvider {
    private static final int BENDABLE_SCORE_HARD_LEVELS_SIZE = 1;
    private static final int BENDABLE_SCORE_SOFT_LEVELS_SIZE = 4;

    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.noMissingSkills(constraintFactory), this.minimizeMakespan(constraintFactory), this.criticalPriorityBasedTaskEndTime(constraintFactory), this.majorPriorityTaskEndTime(constraintFactory), this.minorPriorityTaskEndTime(constraintFactory)};
    }

    private UniConstraintStream<Task> getTaskWithPriority(ConstraintFactory constraintFactory, Priority priority) {
        return constraintFactory.forEach(Task.class).filter(task -> task.getEmployee() != null && task.getPriority() == priority);
    }

    private Constraint noMissingSkills(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Task.class).filter(task -> task.getMissingSkillCount() > 0).penalize((Score)BendableScore.ofHard((int)1, (int)4, (int)0, (int)1), Task::getMissingSkillCount).asConstraint("No missing skills");
    }

    private Constraint criticalPriorityBasedTaskEndTime(ConstraintFactory constraintFactory) {
        return this.getTaskWithPriority(constraintFactory, Priority.CRITICAL).penalize((Score)BendableScore.ofSoft((int)1, (int)4, (int)0, (int)1), Task::getEndTime).asConstraint("Critical priority task end time");
    }

    private Constraint minimizeMakespan(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Employee.class).penalize((Score)BendableScore.ofSoft((int)1, (int)4, (int)1, (int)1), employee -> employee.getEndTime() * employee.getEndTime()).asConstraint("Minimize makespan, latest ending employee first");
    }

    private Constraint majorPriorityTaskEndTime(ConstraintFactory constraintFactory) {
        return this.getTaskWithPriority(constraintFactory, Priority.MAJOR).penalize((Score)BendableScore.ofSoft((int)1, (int)4, (int)2, (int)1), Task::getEndTime).asConstraint("Major priority task end time");
    }

    private Constraint minorPriorityTaskEndTime(ConstraintFactory constraintFactory) {
        return this.getTaskWithPriority(constraintFactory, Priority.MINOR).penalize((Score)BendableScore.ofSoft((int)1, (int)4, (int)3, (int)1), Task::getEndTime).asConstraint("Minor priority task end time");
    }
}

