/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public final class FieldBasedScalingMap<K, V>
implements Map<K, V> {
    private final Supplier<Map<K, V>> mapSupplier;
    private K singletonKey;
    private V singletonValue;
    private Map<K, V> map;
    private int size = 0;

    public FieldBasedScalingMap(Supplier<Map<K, V>> mapSupplier) {
        this.mapSupplier = Objects.requireNonNull(mapSupplier);
    }

    @Override
    public V put(K key, V value) {
        V oldValue;
        if (this.map == null) {
            if (this.size == 0) {
                this.singletonKey = key;
                this.singletonValue = value;
                this.size = 1;
                return null;
            }
            if (this.size == 1) {
                this.map = this.mapSupplier.get();
                this.map.put(this.singletonKey, this.singletonValue);
                this.singletonKey = null;
                this.singletonValue = null;
            } else {
                throw new IllegalStateException("Impossible state: size (" + this.size + ") > 1 yet no map used.");
            }
        }
        if ((oldValue = this.map.put(key, value)) == null) {
            ++this.size;
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            this.put(key, value);
        }
    }

    @Override
    public void clear() {
        if (this.map == null) {
            this.singletonKey = null;
            this.singletonValue = null;
        } else {
            this.map.clear();
        }
        this.size = 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.size == 0) {
            return Collections.emptySet();
        }
        if (this.map == null) {
            return Collections.singleton(this.singletonKey);
        }
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        if (this.size == 0) {
            return Collections.emptyList();
        }
        if (this.map == null) {
            return Collections.singletonList(this.singletonValue);
        }
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.size == 0) {
            return Collections.emptySet();
        }
        if (this.map == null) {
            return Collections.singleton(Map.entry(this.singletonKey, this.singletonValue));
        }
        return this.map.entrySet();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (this.size == 0) {
            return;
        }
        if (this.map == null) {
            action.accept(this.singletonKey, this.singletonValue);
        } else {
            this.map.forEach(action);
        }
    }

    @Override
    public V remove(Object key) {
        if (this.map == null) {
            if (!Objects.equals(this.singletonKey, key)) {
                return null;
            }
            V oldValue = this.singletonValue;
            this.singletonKey = null;
            this.singletonValue = null;
            this.size = 0;
            return oldValue;
        }
        V value = this.map.remove(key);
        if (value != null) {
            --this.size;
        }
        return value;
    }

    @Override
    public V get(Object key) {
        if (this.map == null) {
            if (!Objects.equals(this.singletonKey, key)) {
                return null;
            }
            return this.singletonValue;
        }
        return this.map.get(key);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.size == 0) {
            return false;
        }
        if (this.map == null) {
            return Objects.equals(key, this.singletonKey);
        }
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.size == 0) {
            return false;
        }
        if (this.map == null) {
            return Objects.equals(value, this.singletonValue);
        }
        return this.map.containsValue(this.singletonValue);
    }

    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        if (this.map == null) {
            return "{" + this.singletonKey + "=" + this.singletonValue + "}";
        }
        return this.map.toString();
    }
}

