/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.management;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.RuleBase;
import org.drools.core.management.GenericKieSessionMonitoringImpl;
import org.drools.core.management.KnowledgeBaseMonitoring;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.util.Drools;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.management.KieManagementAgentMBean;
import org.kie.api.runtime.StatelessKieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DroolsManagementAgent
extends KieManagementAgentMBean {
    public static final String CONTAINER_NAME_PREFIX = "org.kie";
    public static final Logger logger = LoggerFactory.getLogger(DroolsManagementAgent.class);

    public static DroolsManagementAgent getInstance() {
        return DroolsManagementAgentHolder.INSTANCE;
    }

    public static ObjectName createObjectNameFor(RuleBase kbase) {
        return DroolsManagementAgent.createObjectName(DroolsManagementAgent.createObjectNameBy(kbase.getContainerId()) + ",kbaseId=" + ObjectName.quote(kbase.getId()));
    }

    public static ObjectName createObjectNameFor(InternalWorkingMemory ksession) {
        return DroolsManagementAgent.createObjectName(DroolsManagementAgent.createObjectNameFor(ksession.getKnowledgeBase()) + ",group=Sessions,ksessionId=Session-" + ksession.getIdentifier());
    }

    public static ObjectName createObjectNameBy(String containerId) {
        return DroolsManagementAgent.createObjectName("org.kie:kcontainerId=" + ObjectName.quote(containerId));
    }

    public static ObjectName createObjectNameBy(String containerId, String kbaseId, KieSessionModel.KieSessionType ksessionType, String ksessionName) {
        return DroolsManagementAgent.createObjectName("org.kie:kcontainerId=" + ObjectName.quote(containerId) + ",kbaseId=" + ObjectName.quote(kbaseId) + ",ksessionType=" + DroolsManagementAgent.ksessionType(ksessionType) + ",ksessionName=" + ObjectName.quote(ksessionName));
    }

    public static String ksessionType(KieSessionModel.KieSessionType ksessionType) {
        switch (ksessionType) {
            case STATELESS: {
                return "Stateless";
            }
        }
        return "Stateful";
    }

    public long getKieBaseCount();

    public long getSessionCount();

    public long getNextKnowledgeBaseId();

    public long getNextKnowledgeSessionId();

    public void registerKnowledgeBase(RuleBase var1);

    public void unregisterKnowledgeBase(RuleBase var1);

    public void registerKnowledgeSessionUnderName(CBSKey var1, KieRuntimeEventManager var2);

    public void unregisterKnowledgeSessionUnderName(CBSKey var1, KieRuntimeEventManager var2);

    public void unregisterKnowledgeSessionBean(CBSKey var1);

    public void registerMBean(Object var1, Object var2, ObjectName var3);

    public void unregisterMBeansFromOwner(Object var1);

    public void unregisterMBean(Object var1, ObjectName var2);

    public void unregisterDependentsMBeansFromOwner(Object var1);

    public static ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (Exception e) {
            logger.error("This is a bug. Error creating ObjectName for MBean: " + name + "\nPlease contact the development team and provide the following stack trace: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static class Dummy
    implements DroolsManagementAgent {
        @Override
        public long getKieBaseCount() {
            return 0L;
        }

        @Override
        public long getSessionCount() {
            return 0L;
        }

        @Override
        public long getNextKnowledgeBaseId() {
            return 0L;
        }

        @Override
        public long getNextKnowledgeSessionId() {
            return 0L;
        }

        @Override
        public void registerKnowledgeBase(RuleBase kbase) {
        }

        @Override
        public void unregisterKnowledgeBase(RuleBase kbase) {
        }

        @Override
        public void registerKnowledgeSessionUnderName(CBSKey cbsKey, KieRuntimeEventManager ksession) {
        }

        @Override
        public void unregisterKnowledgeSessionUnderName(CBSKey cbsKey, KieRuntimeEventManager ksession) {
        }

        @Override
        public void unregisterKnowledgeSessionBean(CBSKey cbsKey) {
        }

        @Override
        public void registerMBean(Object owner, Object mbean, ObjectName name) {
        }

        @Override
        public void unregisterMBeansFromOwner(Object owner) {
        }

        @Override
        public void unregisterMBean(Object owner, ObjectName mbean) {
        }

        @Override
        public void unregisterDependentsMBeansFromOwner(Object owner) {
        }
    }

    public static class Impl
    implements DroolsManagementAgent {
        private static MBeanServer mbs;
        private long kbases = 0L;
        private long ksessions = 0L;
        private Map<Object, List<ObjectName>> mbeans;
        private Map<Object, Object> mbeansRefs = new HashMap<Object, Object>();

        private Impl() {
            this.mbeans = new HashMap<Object, List<ObjectName>>();
        }

        @Override
        public synchronized long getKieBaseCount() {
            return this.kbases;
        }

        @Override
        public synchronized long getSessionCount() {
            return this.ksessions;
        }

        @Override
        public synchronized long getNextKnowledgeBaseId() {
            return ++this.kbases;
        }

        @Override
        public synchronized long getNextKnowledgeSessionId() {
            return ++this.ksessions;
        }

        @Override
        public void registerKnowledgeBase(RuleBase kbase) {
            KnowledgeBaseMonitoring mbean = new KnowledgeBaseMonitoring(kbase);
            this.registerMBean(kbase, mbean, mbean.getName());
        }

        @Override
        public void unregisterKnowledgeBase(RuleBase kbase) {
            this.unregisterMBeansFromOwner(kbase);
        }

        @Override
        public void registerKnowledgeSessionUnderName(CBSKey cbsKey, KieRuntimeEventManager ksession) {
            GenericKieSessionMonitoringImpl bean = this.getKnowledgeSessionBean(cbsKey, ksession);
            if (bean != null) {
                bean.attach(ksession);
            }
        }

        @Override
        public void unregisterKnowledgeSessionUnderName(CBSKey cbsKey, KieRuntimeEventManager ksession) {
            GenericKieSessionMonitoringImpl bean = this.getKnowledgeSessionBean(cbsKey, ksession);
            if (bean != null) {
                bean.detach(ksession);
            }
        }

        @Override
        public void unregisterKnowledgeSessionBean(CBSKey cbsKey) {
            this.unregisterMBeansFromOwner(cbsKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GenericKieSessionMonitoringImpl getKnowledgeSessionBean(CBSKey cbsKey, KieRuntimeEventManager ksession) {
            if (this.mbeansRefs.get(cbsKey) != null) {
                return (GenericKieSessionMonitoringImpl)this.mbeansRefs.get(cbsKey);
            }
            if (ksession instanceof StatelessKieSession) {
                Map<Object, Object> map = this.mbeansRefs;
                synchronized (map) {
                    if (this.mbeansRefs.get(cbsKey) != null) {
                        return (GenericKieSessionMonitoringImpl)this.mbeansRefs.get(cbsKey);
                    }
                    try {
                        GenericKieSessionMonitoringImpl mbean = RuntimeComponentFactory.get().createStatelessSessionMonitor(cbsKey);
                        this.registerMBean(cbsKey, mbean, mbean.getName());
                        this.mbeansRefs.put(cbsKey, mbean);
                        return mbean;
                    }
                    catch (Exception e) {
                        logger.error("Unable to instantiate and register StatelessKieSessionMonitoringMBean");
                        return null;
                    }
                }
            }
            Map<Object, Object> map = this.mbeansRefs;
            synchronized (map) {
                if (this.mbeansRefs.get(cbsKey) != null) {
                    return (GenericKieSessionMonitoringImpl)this.mbeansRefs.get(cbsKey);
                }
                try {
                    GenericKieSessionMonitoringImpl mbean = RuntimeComponentFactory.get().createStatefulSessionMonitor(cbsKey);
                    this.registerMBean(cbsKey, mbean, mbean.getName());
                    this.mbeansRefs.put(cbsKey, mbean);
                    return mbean;
                }
                catch (Exception e) {
                    logger.error("Unable to instantiate and register (stateful) KieSessionMonitoringMBean");
                    return null;
                }
            }
        }

        @Override
        public void registerMBean(Object owner, Object mbean, ObjectName name) {
            try {
                MBeanServer mbs = Impl.getMBeanServer();
                if (!mbs.isRegistered(name)) {
                    mbs.registerMBean(mbean, name);
                    List<ObjectName> mbl = this.mbeans.get(owner);
                    if (mbl == null) {
                        mbl = new ArrayList<ObjectName>();
                        this.mbeans.put(owner, mbl);
                        if (mbean instanceof StandardMBean) {
                            this.mbeansRefs.put(owner, ((StandardMBean)mbean).getImplementation());
                        } else {
                            this.mbeansRefs.put(owner, mbean);
                        }
                    }
                    mbl.add(name);
                    logger.debug("Registered {} into the platform MBean Server", (Object)name);
                }
            }
            catch (Exception e) {
                logger.error("Unable to register mbean " + name + " into the platform MBean Server", (Throwable)e);
            }
        }

        @Override
        public void unregisterMBeansFromOwner(Object owner) {
            List<ObjectName> mbl = this.mbeans.remove(owner);
            this.mbeansRefs.remove(owner);
            if (mbl != null) {
                MBeanServer mbs = Impl.getMBeanServer();
                for (ObjectName name : mbl) {
                    this.unregisterMBeanFromServer(mbs, name);
                }
            }
        }

        private void unregisterMBeanFromServer(MBeanServer mbs, ObjectName name) {
            try {
                mbs.unregisterMBean(name);
                logger.debug("Unregistered from MBean Server: {}", (Object)name);
            }
            catch (Exception e) {
                logger.error("Exception unregistering mbean: " + name, (Throwable)e);
            }
        }

        @Override
        public void unregisterMBean(Object owner, ObjectName mbean) {
            List<ObjectName> mbl = this.mbeans.get(owner);
            if (mbl != null) {
                mbl.remove(mbean);
            }
            MBeanServer mbs = Impl.getMBeanServer();
            this.unregisterMBeanFromServer(mbs, mbean);
        }

        @Override
        public void unregisterDependentsMBeansFromOwner(Object owner) {
            List<ObjectName> mbl = this.mbeans.get(owner);
            if (mbl != null) {
                MBeanServer mbs = Impl.getMBeanServer();
                for (ObjectName name : mbl.subList(1, mbl.size())) {
                    this.unregisterMBeanFromServer(mbs, name);
                }
                mbl.subList(1, mbl.size()).clear();
            }
        }

        private static MBeanServer getMBeanServer() {
            if (mbs == null) {
                mbs = ManagementFactory.getPlatformMBeanServer();
            }
            return mbs;
        }
    }

    public static class CBSKey {
        private final String kcontainerId;
        private final String kbaseId;
        private final String ksessionName;

        public CBSKey(String kcontainerId, String kbaseId, String ksessionName) {
            this.kcontainerId = kcontainerId;
            this.kbaseId = kbaseId;
            this.ksessionName = ksessionName;
        }

        public String getKcontainerId() {
            return this.kcontainerId;
        }

        public String getKbaseId() {
            return this.kbaseId;
        }

        public String getKsessionName() {
            return this.ksessionName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.kbaseId == null ? 0 : this.kbaseId.hashCode());
            result = 31 * result + (this.kcontainerId == null ? 0 : this.kcontainerId.hashCode());
            result = 31 * result + (this.ksessionName == null ? 0 : this.ksessionName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CBSKey)) {
                return false;
            }
            CBSKey other = (CBSKey)obj;
            if (this.kbaseId == null ? other.kbaseId != null : !this.kbaseId.equals(other.kbaseId)) {
                return false;
            }
            if (this.kcontainerId == null ? other.kcontainerId != null : !this.kcontainerId.equals(other.kcontainerId)) {
                return false;
            }
            return !(this.ksessionName == null ? other.ksessionName != null : !this.ksessionName.equals(other.ksessionName));
        }

        public String toString() {
            return "CBSKey [kcontainerId=" + this.kcontainerId + ", kbaseId=" + this.kbaseId + ", ksessionName=" + this.ksessionName + "]";
        }
    }

    public static class DroolsManagementAgentHolder {
        private static final DroolsManagementAgent INSTANCE = Drools.isNativeImage() ? new Dummy() : new Impl();
    }
}

