/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common;

import java.math.BigDecimal;
import java.util.function.Function;
import org.optaplanner.constraint.streams.common.InnerConstraintFactory;
import org.optaplanner.constraint.streams.common.ScoreImpactType;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.stream.Constraint;

public abstract class AbstractConstraint<Solution_, Constraint_ extends AbstractConstraint<Solution_, Constraint_, ConstraintFactory_>, ConstraintFactory_ extends InnerConstraintFactory<Solution_, Constraint_>>
implements Constraint {
    private final ConstraintFactory_ constraintFactory;
    private final String constraintPackage;
    private final String constraintName;
    private final String constraintId;
    private final Function<Solution_, Score<?>> constraintWeightExtractor;
    private final ScoreImpactType scoreImpactType;
    private final boolean isConstraintWeightConfigurable;
    private final Object justificationMapping;
    private final Object indictedObjectsMapping;

    protected AbstractConstraint(ConstraintFactory_ constraintFactory, String constraintPackage, String constraintName, Function<Solution_, Score<?>> constraintWeightExtractor, ScoreImpactType scoreImpactType, boolean isConstraintWeightConfigurable, Object justificationMapping, Object indictedObjectsMapping) {
        this.constraintFactory = constraintFactory;
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.constraintId = ConstraintMatchTotal.composeConstraintId((String)constraintPackage, (String)constraintName);
        this.constraintWeightExtractor = constraintWeightExtractor;
        this.scoreImpactType = scoreImpactType;
        this.isConstraintWeightConfigurable = isConstraintWeightConfigurable;
        this.justificationMapping = justificationMapping;
        this.indictedObjectsMapping = indictedObjectsMapping;
    }

    public final <Score_ extends Score<Score_>> Score_ extractConstraintWeight(Solution_ workingSolution) {
        if (this.isConstraintWeightConfigurable && workingSolution == null) {
            return (Score_)((InnerConstraintFactory)this.constraintFactory).getSolutionDescriptor().getScoreDefinition().getOneSoftestScore();
        }
        Score<?> constraintWeight = this.constraintWeightExtractor.apply(workingSolution);
        ((InnerConstraintFactory)this.constraintFactory).getSolutionDescriptor().validateConstraintWeight(this.constraintPackage, this.constraintName, constraintWeight);
        switch (this.scoreImpactType) {
            case PENALTY: {
                return (Score_)constraintWeight.negate();
            }
            case REWARD: 
            case MIXED: {
                return (Score_)constraintWeight;
            }
        }
        throw new IllegalStateException("Unknown score impact type: (" + this.scoreImpactType + ")");
    }

    public final void assertCorrectImpact(int impact) {
        if (this.scoreImpactType == ScoreImpactType.MIXED) {
            return;
        }
        if (impact < 0) {
            throw new IllegalStateException("Negative match weight (" + impact + ") for constraint (" + this.getConstraintId() + "). Check constraint provider implementation.");
        }
    }

    public final void assertCorrectImpact(long impact) {
        if (this.scoreImpactType == ScoreImpactType.MIXED) {
            return;
        }
        if (impact < 0L) {
            throw new IllegalStateException("Negative match weight (" + impact + ") for constraint (" + this.getConstraintId() + "). Check constraint provider implementation.");
        }
    }

    public final void assertCorrectImpact(BigDecimal impact) {
        if (this.scoreImpactType == ScoreImpactType.MIXED) {
            return;
        }
        if (impact.signum() < 0) {
            throw new IllegalStateException("Negative match weight (" + impact + ") for constraint (" + this.getConstraintId() + "). Check constraint provider implementation.");
        }
    }

    public final ConstraintFactory_ getConstraintFactory() {
        return this.constraintFactory;
    }

    public final String getConstraintPackage() {
        return this.constraintPackage;
    }

    public final String getConstraintName() {
        return this.constraintName;
    }

    public final String getConstraintId() {
        return this.constraintId;
    }

    public final ScoreImpactType getScoreImpactType() {
        return this.scoreImpactType;
    }

    public <JustificationMapping_> JustificationMapping_ getJustificationMapping() {
        return (JustificationMapping_)this.justificationMapping;
    }

    public <IndictedObjectsMapping_> IndictedObjectsMapping_ getIndictedObjectsMapping() {
        return (IndictedObjectsMapping_)this.indictedObjectsMapping;
    }
}

