/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jackson.impl.domain.solution;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.persistence.jackson.api.OptaPlannerJacksonModule;

public class JacksonSolutionFileIO<Solution_>
implements SolutionFileIO<Solution_> {
    private final Class<Solution_> clazz;
    private final ObjectMapper mapper;

    public JacksonSolutionFileIO(Class<Solution_> clazz) {
        this(clazz, new ObjectMapper());
    }

    public JacksonSolutionFileIO(Class<Solution_> clazz, ObjectMapper mapper) {
        this.clazz = clazz;
        this.mapper = mapper;
        mapper.registerModule(OptaPlannerJacksonModule.createModule());
    }

    public String getInputFileExtension() {
        return "json";
    }

    public String getOutputFileExtension() {
        return "json";
    }

    public Solution_ read(File inputSolutionFile) {
        try {
            return (Solution_)this.mapper.readValue(inputSolutionFile, this.clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed reading inputSolutionFile (" + inputSolutionFile + ").", e);
        }
    }

    public void write(Solution_ solution, File file) {
        try {
            this.mapper.writerWithDefaultPrettyPrinter().writeValue(file, solution);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed write", e);
        }
    }

    protected <Entity_, Id_ extends Number, Value_> void deduplicateEntities(Solution_ solution, Function<Solution_, Collection<Entity_>> entityCollectionFunction, Function<Entity_, Id_> entityIdFunction, Function<Entity_, Map<Entity_, Value_>> entityMapGetter, BiConsumer<Entity_, Map<Entity_, Value_>> entityMapSetter) {
        Collection<Entity_> entityCollection = entityCollectionFunction.apply(solution);
        Map entitiesById = entityCollection.stream().collect(Collectors.toMap(entityIdFunction, Function.identity()));
        for (Entity_ entity : entityCollection) {
            Map<Entity_, Value_> originalMap = entityMapGetter.apply(entity);
            if (originalMap.isEmpty()) continue;
            LinkedHashMap newMap = new LinkedHashMap(originalMap.size());
            originalMap.forEach((otherEntity, value) -> newMap.put(entitiesById.get(entityIdFunction.apply(otherEntity)), value));
            entityMapSetter.accept(entity, newMap);
        }
    }
}

