/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.cloner;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import org.optaplanner.core.impl.domain.solution.cloner.DeepCloningUtils;
import org.optaplanner.core.impl.domain.solution.cloner.FieldCloner;

final class DoubleFieldCloner
implements FieldCloner {
    static final FieldCloner INSTANCE = new DoubleFieldCloner();

    @Override
    public <C> void clone(DeepCloningUtils deepCloningUtils, Field field, Class<? extends C> instanceClass, C original, C clone, Consumer<Object> deferredValueConsumer) {
        double originalValue = DoubleFieldCloner.getFieldValue(original, field);
        DoubleFieldCloner.setFieldValue(clone, field, originalValue);
    }

    private static double getFieldValue(Object bean, Field field) {
        try {
            return field.getDouble(bean);
        }
        catch (IllegalAccessException e) {
            throw FieldCloner.createExceptionOnRead(bean, field, e);
        }
    }

    private static void setFieldValue(Object bean, Field field, double value) {
        try {
            field.setDouble(bean, value);
        }
        catch (IllegalAccessException e) {
            throw FieldCloner.createExceptionOnWrite(bean, field, value, e);
        }
    }

    private DoubleFieldCloner() {
    }
}

