/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.cloner;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import org.optaplanner.core.impl.domain.solution.cloner.DeepCloningUtils;

@FunctionalInterface
interface FieldCloner {
    public static Object getFieldValue(Object bean, Field field) {
        try {
            return field.get(bean);
        }
        catch (IllegalAccessException e) {
            throw FieldCloner.createExceptionOnRead(bean, field, e);
        }
    }

    public static RuntimeException createExceptionOnRead(Object bean, Field field, Exception rootCause) {
        return new IllegalStateException("The class (" + bean.getClass() + ") has a field (" + field + ") which cannot be read to create a planning clone.", rootCause);
    }

    public static void setFieldValue(Object bean, Field field, Object value) {
        try {
            field.set(bean, value);
        }
        catch (IllegalAccessException e) {
            throw FieldCloner.createExceptionOnWrite(bean, field, value, e);
        }
    }

    public static RuntimeException createExceptionOnWrite(Object bean, Field field, Object value, Exception rootCause) {
        return new IllegalStateException("The class (" + bean.getClass() + ") has a field (" + field + ") which cannot be written with the value (" + value + ") to create a planning clone.", rootCause);
    }

    public <C> void clone(DeepCloningUtils var1, Field var2, Class<? extends C> var3, C var4, C var5, Consumer<Object> var6);

    default public boolean mayDeferClone() {
        return false;
    }
}

