/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.RandomSubListSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.SubList;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.SubListChangeMove;
import org.optaplanner.core.impl.util.Pair;

class RandomSubListChangeMoveIterator<Solution_>
extends UpcomingSelectionIterator<Move<Solution_>> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final Iterator<SubList> subListIterator;
    private final Random workingRandom;
    private final boolean selectReversingMoveToo;
    private final NavigableMap<Integer, Object> indexToDestinationEntityMap;
    private final int destinationIndexRange;

    RandomSubListChangeMoveIterator(ListVariableDescriptor<Solution_> listVariableDescriptor, RandomSubListSelector<Solution_> subListSelector, EntitySelector<Solution_> entitySelector, Random workingRandom, boolean selectReversingMoveToo) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.subListIterator = subListSelector.iterator();
        this.workingRandom = workingRandom;
        this.selectReversingMoveToo = selectReversingMoveToo;
        this.indexToDestinationEntityMap = new TreeMap<Integer, Object>();
        int cumulativeDestinationListSize = 0;
        for (Object entity : entitySelector::endingIterator) {
            this.indexToDestinationEntityMap.put(cumulativeDestinationListSize, entity);
            cumulativeDestinationListSize += listVariableDescriptor.getListSize(entity) + 1;
        }
        this.destinationIndexRange = cumulativeDestinationListSize;
    }

    @Override
    protected Move<Solution_> createUpcomingSelection() {
        if (!this.subListIterator.hasNext() || this.destinationIndexRange == 0) {
            return (Move)this.noUpcomingSelection();
        }
        SubList subList = this.subListIterator.next();
        Pair<Object, Integer> destination = this.entityAndIndexFromGlobalIndex(this.workingRandom.nextInt(this.destinationIndexRange));
        boolean reversing = this.selectReversingMoveToo && this.workingRandom.nextBoolean();
        return new SubListChangeMove<Solution_>(this.listVariableDescriptor, subList, destination.getKey(), destination.getValue(), reversing);
    }

    Pair<Object, Integer> entityAndIndexFromGlobalIndex(int index) {
        Map.Entry<Integer, Object> entry = this.indexToDestinationEntityMap.floorEntry(index);
        return Pair.of(entry.getValue(), index - entry.getKey());
    }
}

