/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import org.optaplanner.constraint.streams.bavet.common.AbstractIfExistsNode;
import org.optaplanner.constraint.streams.bavet.common.ExistsCounter;
import org.optaplanner.constraint.streams.bavet.common.LeftTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.RightTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleList;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleListEntry;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public abstract class AbstractUnindexedIfExistsNode<LeftTuple_ extends Tuple, Right_>
extends AbstractIfExistsNode<LeftTuple_, Right_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final int inputStoreIndexLeftCounterEntry;
    private final int inputStoreIndexRightEntry;
    private final TupleList<ExistsCounter<LeftTuple_>> leftCounterList = new TupleList();
    private final TupleList<UniTuple<Right_>> rightTupleList = new TupleList();

    protected AbstractUnindexedIfExistsNode(boolean shouldExist, int inputStoreIndexLeftCounterEntry, int inputStoreIndexLeftTrackerList, int inputStoreIndexRightEntry, int inputStoreIndexRightTrackerList, TupleLifecycle<LeftTuple_> nextNodesTupleLifecycle, boolean isFiltering) {
        super(shouldExist, inputStoreIndexLeftTrackerList, inputStoreIndexRightTrackerList, nextNodesTupleLifecycle, isFiltering);
        this.inputStoreIndexLeftCounterEntry = inputStoreIndexLeftCounterEntry;
        this.inputStoreIndexRightEntry = inputStoreIndexRightEntry;
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (leftTuple.getStore(this.inputStoreIndexLeftCounterEntry) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + leftTuple + ") was already added in the tupleStore.");
        }
        ExistsCounter<LeftTuple_> counter = new ExistsCounter<LeftTuple_>(leftTuple);
        TupleListEntry<ExistsCounter<LeftTuple_>> counterEntry = this.leftCounterList.add(counter);
        leftTuple.setStore(this.inputStoreIndexLeftCounterEntry, counterEntry);
        if (!this.isFiltering) {
            counter.countRight = this.rightTupleList.size();
        } else {
            TupleList leftTrackerList = new TupleList();
            this.rightTupleList.forEach(rightTuple -> {
                if (this.testFiltering(leftTuple, rightTuple)) {
                    ++counter.countRight;
                    TupleList rightTrackerList = (TupleList)rightTuple.getStore(this.inputStoreIndexRightTrackerList);
                    new AbstractIfExistsNode.FilteringTracker(counter, leftTrackerList, rightTrackerList);
                }
            });
            leftTuple.setStore(this.inputStoreIndexLeftTrackerList, leftTrackerList);
        }
        this.initCounterLeft(counter);
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        TupleListEntry counterEntry = (TupleListEntry)leftTuple.getStore(this.inputStoreIndexLeftCounterEntry);
        if (counterEntry == null) {
            this.insertLeft(leftTuple);
            return;
        }
        ExistsCounter counter = (ExistsCounter)counterEntry.getElement();
        if (!this.isFiltering) {
            this.updateUnchangedCounterLeft(counter);
        } else {
            TupleList leftTrackerList = (TupleList)leftTuple.getStore(this.inputStoreIndexLeftTrackerList);
            leftTrackerList.forEach(AbstractIfExistsNode.FilteringTracker::remove);
            counter.countRight = 0;
            this.rightTupleList.forEach(rightTuple -> {
                if (this.testFiltering(leftTuple, rightTuple)) {
                    ++counter.countRight;
                    TupleList rightTrackerList = (TupleList)rightTuple.getStore(this.inputStoreIndexRightTrackerList);
                    new AbstractIfExistsNode.FilteringTracker(counter, leftTrackerList, rightTrackerList);
                }
            });
            this.updateCounterLeft(counter);
        }
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        TupleListEntry counterEntry = (TupleListEntry)leftTuple.removeStore(this.inputStoreIndexLeftCounterEntry);
        if (counterEntry == null) {
            return;
        }
        ExistsCounter counter = (ExistsCounter)counterEntry.getElement();
        counterEntry.remove();
        if (this.isFiltering) {
            TupleList leftTrackerList = (TupleList)leftTuple.getStore(this.inputStoreIndexLeftTrackerList);
            leftTrackerList.forEach(AbstractIfExistsNode.FilteringTracker::remove);
        }
        this.killCounterLeft(counter);
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRightEntry) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + rightTuple + ") was already added in the tupleStore.");
        }
        TupleListEntry<UniTuple<Right_>> rightEntry = this.rightTupleList.add(rightTuple);
        rightTuple.setStore(this.inputStoreIndexRightEntry, rightEntry);
        if (!this.isFiltering) {
            this.leftCounterList.forEach(this::incrementCounterRight);
        } else {
            TupleList rightTrackerList = new TupleList();
            this.leftCounterList.forEach(counter -> {
                if (this.testFiltering(counter.leftTuple, rightTuple)) {
                    this.incrementCounterRight(counter);
                    TupleList leftTrackerList = (TupleList)counter.leftTuple.getStore(this.inputStoreIndexLeftTrackerList);
                    new AbstractIfExistsNode.FilteringTracker(counter, leftTrackerList, rightTrackerList);
                }
            });
            rightTuple.setStore(this.inputStoreIndexRightTrackerList, rightTrackerList);
        }
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        TupleListEntry rightEntry = (TupleListEntry)rightTuple.getStore(this.inputStoreIndexRightEntry);
        if (rightEntry == null) {
            this.insertRight(rightTuple);
            return;
        }
        if (this.isFiltering) {
            TupleList rightTrackerList = (TupleList)rightTuple.getStore(this.inputStoreIndexRightTrackerList);
            rightTrackerList.forEach(filteringTacker -> {
                this.decrementCounterRight(filteringTacker.counter);
                filteringTacker.remove();
            });
            this.leftCounterList.forEach(counter -> {
                if (this.testFiltering(counter.leftTuple, rightTuple)) {
                    this.incrementCounterRight(counter);
                    TupleList leftTrackerList = (TupleList)counter.leftTuple.getStore(this.inputStoreIndexLeftTrackerList);
                    new AbstractIfExistsNode.FilteringTracker(counter, leftTrackerList, rightTrackerList);
                }
            });
        }
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        TupleListEntry rightEntry = (TupleListEntry)rightTuple.removeStore(this.inputStoreIndexRightEntry);
        if (rightEntry == null) {
            return;
        }
        rightEntry.remove();
        if (!this.isFiltering) {
            this.leftCounterList.forEach(this::decrementCounterRight);
        } else {
            TupleList rightTrackerList = (TupleList)rightTuple.getStore(this.inputStoreIndexRightTrackerList);
            rightTrackerList.forEach(filteringTacker -> {
                this.decrementCounterRight(filteringTacker.counter);
                filteringTacker.remove();
            });
        }
    }
}

