/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.util.Arrays;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

public class SolutionConverter<Solution_>
extends LoggingMain {
    protected SolutionFileIO<Solution_> inputSolutionFileIO;
    protected final File inputDir;
    protected final boolean inputFileIsDirectory;
    protected SolutionFileIO<Solution_> outputSolutionFileIO;
    protected final File outputDir;

    public static <Solution_> SolutionConverter<Solution_> createImportConverter(String dataDirName, AbstractSolutionImporter<Solution_> importer, Class<Solution_> solutionClass) {
        XStreamSolutionFileIO outputSolutionFileIO = new XStreamSolutionFileIO(new Class[]{solutionClass});
        return SolutionConverter.createImportConverter(dataDirName, importer, outputSolutionFileIO);
    }

    public static <Solution_> SolutionConverter<Solution_> createImportConverter(String dataDirName, final AbstractSolutionImporter<Solution_> importer, SolutionFileIO<Solution_> outputSolutionFileIO) {
        SolutionFileIO inputSolutionFileIO = new SolutionFileIO<Solution_>(){

            public String getInputFileExtension() {
                return importer.getInputFileSuffix();
            }

            public Solution_ read(File inputSolutionFile) {
                return importer.readSolution(inputSolutionFile);
            }

            public void write(Solution_ solution_, File outputSolutionFile) {
                throw new UnsupportedOperationException();
            }
        };
        return new SolutionConverter<Solution_>(dataDirName, inputSolutionFileIO, "import", importer.isInputFileDirectory(), outputSolutionFileIO, "unsolved");
    }

    public static <Solution_> SolutionConverter<Solution_> createExportConverter(String dataDirName, Class<Solution_> solutionClass, AbstractSolutionExporter<Solution_> exporter) {
        XStreamSolutionFileIO inputSolutionFileIO = new XStreamSolutionFileIO(new Class[]{solutionClass});
        return SolutionConverter.createExportConverter(dataDirName, inputSolutionFileIO, exporter);
    }

    public static <Solution_> SolutionConverter<Solution_> createExportConverter(String dataDirName, SolutionFileIO<Solution_> inputSolutionFileIO, final AbstractSolutionExporter<Solution_> exporter) {
        SolutionFileIO outputSolutionFileIO = new SolutionFileIO<Solution_>(){

            public String getInputFileExtension() {
                throw new UnsupportedOperationException();
            }

            public String getOutputFileExtension() {
                return exporter.getOutputFileSuffix();
            }

            public Solution_ read(File inputSolutionFile) {
                throw new UnsupportedOperationException();
            }

            public void write(Solution_ solution, File outputSolutionFile) {
                exporter.writeSolution(solution, outputSolutionFile);
            }
        };
        return new SolutionConverter<Solution_>(dataDirName, inputSolutionFileIO, "solved", false, outputSolutionFileIO, "export");
    }

    private SolutionConverter(String dataDirName, SolutionFileIO<Solution_> inputSolutionFileIO, String inputDirName, boolean inputFileIsDirectory, SolutionFileIO<Solution_> outputSolutionFileIO, String outputDirName) {
        this.inputSolutionFileIO = inputSolutionFileIO;
        this.inputFileIsDirectory = inputFileIsDirectory;
        this.outputSolutionFileIO = outputSolutionFileIO;
        File dataDir = CommonApp.determineDataDir(dataDirName);
        this.inputDir = new File(dataDir, inputDirName);
        if (!this.inputDir.exists() || !this.inputDir.isDirectory()) {
            throw new IllegalStateException("The directory inputDir (" + this.inputDir.getAbsolutePath() + ") does not exist or is not a directory.");
        }
        this.outputDir = new File(dataDir, outputDirName);
    }

    public void convertAll() {
        File[] inputFiles = this.inputDir.listFiles();
        if (inputFiles == null) {
            throw new IllegalStateException("Unable to list the files in the inputDirectory (" + this.inputDir.getAbsolutePath() + ").");
        }
        Arrays.sort(inputFiles, new ProblemFileComparator());
        for (File inputFile : inputFiles) {
            if (!this.acceptInputFile(inputFile)) continue;
            this.convert(inputFile);
        }
    }

    public boolean acceptInputFile(File inputFile) {
        if (this.inputFileIsDirectory) {
            return inputFile.isDirectory();
        }
        return inputFile.getName().endsWith("." + this.inputSolutionFileIO.getInputFileExtension());
    }

    public void convert(String inputFileName) {
        String outputFileName = inputFileName.substring(0, inputFileName.length() - this.inputSolutionFileIO.getInputFileExtension().length()) + this.outputSolutionFileIO.getOutputFileExtension();
        this.convert(inputFileName, outputFileName);
    }

    public void convert(String inputFileName, String outputFileName) {
        File inputFile = new File(this.inputDir, inputFileName);
        if (!inputFile.exists()) {
            throw new IllegalStateException("The file inputFile (" + inputFile.getAbsolutePath() + ") does not exist.");
        }
        File outputFile = new File(this.outputDir, outputFileName);
        outputFile.getParentFile().mkdirs();
        this.convert(inputFile, outputFile);
    }

    public void convert(File inputFile) {
        String inputFileName = inputFile.getName();
        String outputFileName = inputFileName.substring(0, inputFileName.length() - this.inputSolutionFileIO.getInputFileExtension().length()) + this.outputSolutionFileIO.getOutputFileExtension();
        File outputFile = new File(this.outputDir, outputFileName);
        this.convert(inputFile, outputFile);
    }

    protected void convert(File inputFile, File outputFile) {
        Object solution = this.inputSolutionFileIO.read(inputFile);
        this.outputSolutionFileIO.write(solution, outputFile);
        this.logger.info("Saved: {}", (Object)outputFile);
    }
}

