/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistableJackson;
import org.optaplanner.examples.machinereassignment.domain.MrLocation;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrNeighborhood;
import org.optaplanner.examples.machinereassignment.domain.MrProcess;
import org.optaplanner.examples.machinereassignment.domain.MrResource;
import org.optaplanner.examples.machinereassignment.domain.MrService;
import org.optaplanner.examples.machinereassignment.domain.solver.MrProcessAssignmentDifficultyComparator;

@PlanningEntity(difficultyComparatorClass=MrProcessAssignmentDifficultyComparator.class)
public class MrProcessAssignment
extends AbstractPersistableJackson {
    private MrProcess process;
    private MrMachine originalMachine;
    private MrMachine machine;

    public static MrProcessAssignment withOriginalMachine(long id, MrProcess process, MrMachine originalMachine) {
        return new MrProcessAssignment(id, process, originalMachine, null);
    }

    public static MrProcessAssignment withTargetMachine(long id, MrProcess process, MrMachine targetMachine) {
        return new MrProcessAssignment(id, process, null, targetMachine);
    }

    MrProcessAssignment() {
    }

    public MrProcessAssignment(long id, MrProcess process) {
        super(id);
        this.process = process;
    }

    public MrProcessAssignment(long id, MrProcess process, MrMachine originalMachine, MrMachine machine) {
        super(id);
        this.process = process;
        this.originalMachine = originalMachine;
        this.machine = machine;
    }

    public MrProcess getProcess() {
        return this.process;
    }

    public MrMachine getOriginalMachine() {
        return this.originalMachine;
    }

    public void setOriginalMachine(MrMachine originalMachine) {
        this.originalMachine = originalMachine;
    }

    @PlanningVariable(valueRangeProviderRefs={"machineRange"})
    public MrMachine getMachine() {
        return this.machine;
    }

    public void setMachine(MrMachine machine) {
        this.machine = machine;
    }

    @JsonIgnore
    public MrService getService() {
        return this.process.getService();
    }

    @JsonIgnore
    public boolean isMoved() {
        if (this.machine == null) {
            return false;
        }
        return !Objects.equals(this.originalMachine, this.machine);
    }

    @JsonIgnore
    public int getProcessMoveCost() {
        return this.process.getMoveCost();
    }

    @JsonIgnore
    public int getMachineMoveCost() {
        return this.machine == null || this.originalMachine == null ? 0 : this.originalMachine.getMoveCostTo(this.machine);
    }

    @JsonIgnore
    public MrNeighborhood getNeighborhood() {
        return this.machine == null ? null : this.machine.getNeighborhood();
    }

    @JsonIgnore
    public MrLocation getLocation() {
        return this.machine == null ? null : this.machine.getLocation();
    }

    @JsonIgnore
    public long getUsage(MrResource resource) {
        return this.process.getUsage(resource);
    }

    @JsonIgnore
    public String getLabel() {
        return "Process " + this.getId();
    }

    @Override
    public String toString() {
        return this.process.toString();
    }
}

