/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.ScoreExplanation;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.impl.score.DefaultScoreExplanation;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.solver.DefaultSolverFactory;
import org.optaplanner.core.impl.solver.DefaultSolverManager;

public final class DefaultScoreManager<Solution_, Score_ extends Score<Score_>>
implements ScoreManager<Solution_, Score_> {
    private final InnerScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory;

    public <ProblemId_> DefaultScoreManager(SolverManager<Solution_, ProblemId_> solverManager) {
        this(((DefaultSolverManager)solverManager).getSolverFactory());
    }

    public DefaultScoreManager(SolverFactory<Solution_> solverFactory) {
        this.scoreDirectorFactory = ((DefaultSolverFactory)solverFactory).getScoreDirectorFactory();
    }

    public InnerScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public Score_ updateScore(Solution_ solution) {
        try (InnerScoreDirector<Solution_, Score_> scoreDirector = this.scoreDirectorFactory.buildScoreDirector(false, false);){
            scoreDirector.setWorkingSolution(solution);
            Score_ Score_ = scoreDirector.calculateScore();
            return Score_;
        }
    }

    @Override
    public String getSummary(Solution_ solution) {
        return this.explainScore(solution).getSummary();
    }

    @Override
    public ScoreExplanation<Solution_, Score_> explainScore(Solution_ solution) {
        try (InnerScoreDirector<Solution_, Score_> scoreDirector = this.scoreDirectorFactory.buildScoreDirector(false, true);){
            scoreDirector.setWorkingSolution(solution);
            boolean constraintMatchEnabled = scoreDirector.isConstraintMatchEnabled();
            if (!constraintMatchEnabled) {
                throw new IllegalStateException("When constraintMatchEnabled (" + constraintMatchEnabled + ") is disabled, this method should not be called.");
            }
            DefaultScoreExplanation<Solution_, Score_> defaultScoreExplanation = new DefaultScoreExplanation<Solution_, Score_>(scoreDirector);
            return defaultScoreExplanation;
        }
    }
}

