/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.persistence;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.DistanceType;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.HubSegmentLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.RoadSegmentLocation;
import org.optaplanner.persistence.jackson.impl.domain.solution.JacksonSolutionFileIO;

public class VehicleRoutingSolutionFileIO
extends JacksonSolutionFileIO<VehicleRoutingSolution> {
    public VehicleRoutingSolutionFileIO() {
        super(VehicleRoutingSolution.class);
    }

    public VehicleRoutingSolution read(File inputSolutionFile) {
        VehicleRoutingSolution vehicleRoutingSolution = (VehicleRoutingSolution)super.read(inputSolutionFile);
        if (vehicleRoutingSolution.getDistanceType() == DistanceType.ROAD_DISTANCE) {
            this.deduplicateRoadLocations(vehicleRoutingSolution);
        } else if (vehicleRoutingSolution.getDistanceType() == DistanceType.SEGMENTED_ROAD_DISTANCE) {
            this.deduplicateRoadSegments(vehicleRoutingSolution);
        }
        return vehicleRoutingSolution;
    }

    private void deduplicateRoadLocations(VehicleRoutingSolution vehicleRoutingSolution) {
        List roadLocationList = vehicleRoutingSolution.getLocationList().stream().filter(location -> location instanceof RoadLocation).map(location -> (RoadLocation)location).collect(Collectors.toList());
        Map locationsById = roadLocationList.stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        for (RoadLocation roadLocation : roadLocationList) {
            Map<RoadLocation, Double> newTravelDistanceMap = this.deduplicateMap(roadLocation.getTravelDistanceMap(), locationsById, AbstractPersistable::getId);
            roadLocation.setTravelDistanceMap(newTravelDistanceMap);
        }
        vehicleRoutingSolution.getCustomerList().forEach(customer -> customer.setLocation((Location)locationsById.get(customer.getLocation().getId())));
        vehicleRoutingSolution.getDepotList().forEach(depot -> depot.setLocation((Location)locationsById.get(depot.getLocation().getId())));
    }

    private <Key, Value, Index> Map<Key, Value> deduplicateMap(Map<Key, Value> originalMap, Map<Index, Key> index, Function<Key, Index> idFunction) {
        if (originalMap == null || originalMap.isEmpty()) {
            return originalMap;
        }
        LinkedHashMap newMap = new LinkedHashMap(originalMap.size());
        originalMap.forEach((key, value) -> newMap.put(index.get(idFunction.apply(key)), value));
        return newMap;
    }

    private void deduplicateRoadSegments(VehicleRoutingSolution vehicleRoutingSolution) {
        Map<RoadSegmentLocation, Double> newNearbyTravelDistanceMap;
        Map<HubSegmentLocation, Double> newHubTravelDistanceMap;
        List hubSegmentLocationList = vehicleRoutingSolution.getLocationList().stream().filter(location -> location instanceof HubSegmentLocation).map(location -> (HubSegmentLocation)location).collect(Collectors.toList());
        List roadSegmentLocationList = vehicleRoutingSolution.getLocationList().stream().filter(location -> location instanceof RoadSegmentLocation).map(location -> (RoadSegmentLocation)location).collect(Collectors.toList());
        Map hubSegmentLocationsById = hubSegmentLocationList.stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        Map roadSegmentLocationsById = roadSegmentLocationList.stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        for (HubSegmentLocation hubSegmentLocation : hubSegmentLocationList) {
            newHubTravelDistanceMap = this.deduplicateMap(hubSegmentLocation.getHubTravelDistanceMap(), hubSegmentLocationsById, AbstractPersistable::getId);
            newNearbyTravelDistanceMap = this.deduplicateMap(hubSegmentLocation.getNearbyTravelDistanceMap(), roadSegmentLocationsById, AbstractPersistable::getId);
            hubSegmentLocation.setHubTravelDistanceMap(newHubTravelDistanceMap);
            hubSegmentLocation.setNearbyTravelDistanceMap(newNearbyTravelDistanceMap);
        }
        for (RoadSegmentLocation roadSegmentLocation : roadSegmentLocationList) {
            newHubTravelDistanceMap = this.deduplicateMap(roadSegmentLocation.getHubTravelDistanceMap(), hubSegmentLocationsById, AbstractPersistable::getId);
            newNearbyTravelDistanceMap = this.deduplicateMap(roadSegmentLocation.getNearbyTravelDistanceMap(), roadSegmentLocationsById, AbstractPersistable::getId);
            roadSegmentLocation.setHubTravelDistanceMap(newHubTravelDistanceMap);
            roadSegmentLocation.setNearbyTravelDistanceMap(newNearbyTravelDistanceMap);
        }
        Map locationsById = vehicleRoutingSolution.getLocationList().stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        vehicleRoutingSolution.getCustomerList().forEach(customer -> customer.setLocation((Location)locationsById.get(customer.getLocation().getId())));
        vehicleRoutingSolution.getDepotList().forEach(depot -> depot.setLocation((Location)locationsById.get(depot.getLocation().getId())));
    }
}

