/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.persistence.util;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.domain.AbstractPersistableJackson;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingSolutionFileIO;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public class VehicleRoutingDistanceTypeComparison
extends LoggingMain {
    private final ScoreManager<VehicleRoutingSolution, HardSoftLongScore> scoreManager;
    protected final File dataDir = CommonApp.determineDataDir("vehiclerouting");
    protected final SolutionFileIO<VehicleRoutingSolution> solutionFileIO = new VehicleRoutingSolutionFileIO();

    public static void main(String[] args) {
        new VehicleRoutingDistanceTypeComparison().compare("solved/tmp-p-belgium-n50-k10.json", "solved/tmp-p-belgium-road-km-n50-k10.json", "solved/tmp-p-belgium-road-time-n50-k10.json");
    }

    public VehicleRoutingDistanceTypeComparison() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/vehiclerouting/vehicleRoutingSolverConfig.xml");
        this.scoreManager = ScoreManager.create((SolverFactory)solverFactory);
    }

    public void compare(String ... filePaths) {
        File[] files = new File[filePaths.length];
        for (int i = 0; i < filePaths.length; ++i) {
            File file = new File(this.dataDir, filePaths[i]);
            if (!file.exists()) {
                throw new IllegalArgumentException("The file (" + file + ") does not exist.");
            }
            files[i] = file;
        }
        for (File varFile : files) {
            this.logger.info("  Results for {}:", (Object)varFile.getName());
            VehicleRoutingSolution variablesSolution = (VehicleRoutingSolution)this.solutionFileIO.read(varFile);
            for (File inputFile : files) {
                HardSoftLongScore score;
                if (inputFile == varFile) {
                    score = variablesSolution.getScore();
                } else {
                    VehicleRoutingSolution inputSolution = (VehicleRoutingSolution)this.solutionFileIO.read(inputFile);
                    this.applyVariables(inputSolution, variablesSolution);
                    score = inputSolution.getScore();
                }
                this.logger.info("    {} (according to {})", (Object)score.getSoftScore(), (Object)inputFile.getName());
            }
        }
    }

    private void applyVariables(VehicleRoutingSolution inputSolution, VehicleRoutingSolution varSolution) {
        List<Vehicle> inputVehicleList = inputSolution.getVehicleList();
        LinkedHashMap<Long, Vehicle> inputVehicleMap = new LinkedHashMap<Long, Vehicle>(inputVehicleList.size());
        for (Vehicle vehicle : inputVehicleList) {
            inputVehicleMap.put(vehicle.getId(), vehicle);
        }
        List<Customer> inputCustomerList = inputSolution.getCustomerList();
        LinkedHashMap<Long, Customer> inputCustomerMap = new LinkedHashMap<Long, Customer>(inputCustomerList.size());
        for (Customer customer : inputCustomerList) {
            inputCustomerMap.put(customer.getId(), customer);
        }
        for (Customer varCustomer : varSolution.getCustomerList()) {
            Customer inputCustomer = (Customer)inputCustomerMap.get(varCustomer.getId());
            inputCustomer.setPreviousCustomer(this.findInputObjectById(inputCustomerMap, varCustomer.getPreviousCustomer()));
            inputCustomer.setNextCustomer(this.findInputObjectById(inputCustomerMap, varCustomer.getNextCustomer()));
            inputCustomer.setVehicle(this.findInputObjectById(inputVehicleMap, varCustomer.getVehicle()));
        }
        this.scoreManager.updateScore((Object)inputSolution);
    }

    private <T extends AbstractPersistableJackson> T findInputObjectById(Map<Long, T> inputMap, T varObject) {
        return (T)(varObject == null ? null : (AbstractPersistableJackson)inputMap.get(varObject.getId()));
    }
}

