/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.domain;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.List;
import org.optaplanner.examples.common.domain.AbstractPersistableJackson;
import org.optaplanner.examples.machinereassignment.domain.MrProcessRequirement;
import org.optaplanner.examples.machinereassignment.domain.MrResource;
import org.optaplanner.examples.machinereassignment.domain.MrService;

@JsonIdentityInfo(scope=MrProcess.class, generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
public class MrProcess
extends AbstractPersistableJackson {
    private MrService service;
    private int moveCost;
    private List<MrProcessRequirement> processRequirementList;

    public MrProcess() {
    }

    public MrProcess(int moveCost) {
        this.moveCost = moveCost;
    }

    public MrProcess(MrService service) {
        this.service = service;
    }

    public MrProcess(long id, MrService service, int moveCost) {
        super(id);
        this.service = service;
        this.moveCost = moveCost;
    }

    public MrService getService() {
        return this.service;
    }

    public int getMoveCost() {
        return this.moveCost;
    }

    public List<MrProcessRequirement> getProcessRequirementList() {
        return this.processRequirementList;
    }

    public void setProcessRequirementList(List<MrProcessRequirement> processRequirementList) {
        this.processRequirementList = processRequirementList;
    }

    public MrProcessRequirement getProcessRequirement(MrResource resource) {
        return this.processRequirementList.get(resource.getIndex());
    }

    public long getUsage(MrResource resource) {
        return resource.getIndex() >= this.processRequirementList.size() ? 0L : this.processRequirementList.get(resource.getIndex()).getUsage();
    }

    @JsonIgnore
    public int getUsageMultiplicand() {
        int multiplicand = 1;
        for (MrProcessRequirement processRequirement : this.processRequirementList) {
            multiplicand = (int)((long)multiplicand * processRequirement.getUsage());
        }
        return multiplicand;
    }
}

