/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractRandomSwapIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.RandomSubListSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.SubList;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.SubListSwapMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.TriangularNumbers;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;

public class RandomSubListSwapMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final EntitySelector<Solution_> entitySelector;
    private final int minimumSubListSize;
    private final int maximumSubListSize;
    private final RandomSubListSelector<Solution_> leftSubListSelector;
    private final RandomSubListSelector<Solution_> rightSubListSelector;
    private final boolean selectReversingMoveToo;

    public RandomSubListSwapMoveSelector(ListVariableDescriptor<Solution_> listVariableDescriptor, EntitySelector<Solution_> entitySelector, EntityIndependentValueSelector<Solution_> leftValueSelector, EntityIndependentValueSelector<Solution_> rightValueSelector, int minimumSubListSize, int maximumSubListSize, boolean selectReversingMoveToo) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.entitySelector = entitySelector;
        this.minimumSubListSize = minimumSubListSize;
        this.maximumSubListSize = maximumSubListSize;
        this.selectReversingMoveToo = selectReversingMoveToo;
        this.leftSubListSelector = new RandomSubListSelector<Solution_>(listVariableDescriptor, entitySelector, leftValueSelector, minimumSubListSize, maximumSubListSize);
        this.rightSubListSelector = new RandomSubListSelector<Solution_>(listVariableDescriptor, entitySelector, rightValueSelector, minimumSubListSize, maximumSubListSize);
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        this.phaseLifecycleSupport.addEventListener(leftValueSelector);
        this.phaseLifecycleSupport.addEventListener(this.leftSubListSelector);
        this.phaseLifecycleSupport.addEventListener(this.rightSubListSelector);
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        return new AbstractRandomSwapIterator<Solution_, Move<Solution_>, SubList>(this.leftSubListSelector, this.rightSubListSelector){

            @Override
            protected Move<Solution_> newSwapSelection(SubList leftSubSelection, SubList rightSubSelection) {
                boolean reversing = RandomSubListSwapMoveSelector.this.selectReversingMoveToo && RandomSubListSwapMoveSelector.this.workingRandom.nextBoolean();
                return new SubListSwapMove(RandomSubListSwapMoveSelector.this.listVariableDescriptor, leftSubSelection, rightSubSelection, reversing);
            }
        };
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return true;
    }

    @Override
    public long getSize() {
        long subListCount = 0L;
        for (Object entity : this.entitySelector::endingIterator) {
            int listSize = this.listVariableDescriptor.getListSize(entity);
            if (listSize < this.minimumSubListSize) continue;
            subListCount += (long)TriangularNumbers.nthTriangle(listSize - this.minimumSubListSize + 1);
            if (listSize <= this.maximumSubListSize) continue;
            subListCount -= (long)TriangularNumbers.nthTriangle(listSize - this.maximumSubListSize);
        }
        return subListCount * subListCount;
    }

    boolean isSelectReversingMoveToo() {
        return this.selectReversingMoveToo;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.leftSubListSelector + ", " + this.rightSubListSelector + ")";
    }
}

