/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Objects;
import org.optaplanner.core.api.score.director.ScoreDirector;

public final class SubList {
    private final Object entity;
    private final int fromIndex;
    private final int length;

    SubList(Object entity, int fromIndex, int length) {
        this.entity = entity;
        this.fromIndex = fromIndex;
        this.length = length;
    }

    public Object getEntity() {
        return this.entity;
    }

    public int getFromIndex() {
        return this.fromIndex;
    }

    public int getLength() {
        return this.length;
    }

    public int getToIndex() {
        return this.fromIndex + this.length;
    }

    public SubList rebase(ScoreDirector<?> destinationScoreDirector) {
        return new SubList(destinationScoreDirector.lookUpWorkingObject(this.entity), this.fromIndex, this.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubList other = (SubList)o;
        return this.fromIndex == other.fromIndex && this.length == other.length && this.entity.equals(other.entity);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.fromIndex, this.length);
    }

    public String toString() {
        return this.entity + "[" + this.fromIndex + ".." + this.getToIndex() + "]";
    }
}

