/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Iterator;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.AddRemoveRule;
import org.drools.core.phreak.RuntimeSegmentUtilities;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.SegmentMemory;

public class SegmentPropagator {
    public static void propagate(SegmentMemory sourceSegment, TupleSets<LeftTuple> leftTuples, ReteEvaluator reteEvaluator) {
        if (leftTuples.isEmpty()) {
            return;
        }
        LeftTupleSource source = (LeftTupleSource)sourceSegment.getTipNode();
        if (sourceSegment.isEmpty()) {
            RuntimeSegmentUtilities.createChildSegments(reteEvaluator, sourceSegment, source.getSinkPropagator());
        }
        SegmentPropagator.processPeers(sourceSegment, leftTuples);
        Iterator<SegmentMemory> peersIterator = sourceSegment.getPeersWithDataDrivenPathMemoriesIterator();
        while (peersIterator.hasNext()) {
            SegmentMemory smem = peersIterator.next();
            for (PathMemory dataDrivenPmem : smem.getDataDrivenPathMemories()) {
                if (smem.getStagedLeftTuples().getDeleteFirst() == null && smem.getStagedLeftTuples().getUpdateFirst() == null && !dataDrivenPmem.isRuleLinked()) continue;
                AddRemoveRule.forceFlushLeftTuple(dataDrivenPmem, smem, reteEvaluator, smem.getStagedLeftTuples());
                AddRemoveRule.forceFlushWhenRiaNode(reteEvaluator, dataDrivenPmem);
            }
        }
    }

    private static void processPeers(SegmentMemory sourceSegment, TupleSets<LeftTuple> leftTuples) {
        SegmentMemory firstSmem = (SegmentMemory)sourceSegment.getFirst();
        SegmentPropagator.processPeerDeletes(leftTuples.getDeleteFirst(), firstSmem);
        SegmentPropagator.processPeerDeletes(leftTuples.getNormalizedDeleteFirst(), firstSmem);
        SegmentPropagator.processPeerUpdates(leftTuples, firstSmem);
        SegmentPropagator.processPeerInserts(leftTuples, firstSmem);
        firstSmem.getStagedLeftTuples().addAll(leftTuples);
        leftTuples.resetAll();
    }

    private static void processPeerInserts(TupleSets<LeftTuple> leftTuples, SegmentMemory firstSmem) {
        for (LeftTuple leftTuple = leftTuples.getInsertFirst(); leftTuple != null; leftTuple = (LeftTuple)leftTuple.getStagedNext()) {
            LeftTuple peer;
            SegmentMemory smem = firstSmem.getNext();
            if (smem == null) continue;
            if (leftTuple.getPeer() == null) {
                peer = leftTuple;
                while (smem != null) {
                    LeftTupleSink sink = smem.getSinkFactory();
                    peer = sink.createPeer(peer);
                    smem.getStagedLeftTuples().addInsert(peer);
                    smem = smem.getNext();
                }
                continue;
            }
            peer = leftTuple.getPeer();
            while (smem != null) {
                peer.setPropagationContext(leftTuple.getPropagationContext());
                SegmentPropagator.updateChildLeftTupleDuringInsert(peer, smem.getStagedLeftTuples(), smem.getStagedLeftTuples());
                peer = peer.getPeer();
                smem = smem.getNext();
            }
        }
    }

    private static void processPeerUpdates(TupleSets<LeftTuple> leftTuples, SegmentMemory firstSmem) {
        for (LeftTuple leftTuple = leftTuples.getUpdateFirst(); leftTuple != null; leftTuple = (LeftTuple)leftTuple.getStagedNext()) {
            SegmentMemory smem = firstSmem.getNext();
            if (smem == null) continue;
            for (LeftTuple peer = leftTuple.getPeer(); peer != null; peer = peer.getPeer()) {
                if (peer.getStagedType() == 0) {
                    peer.setPropagationContext(leftTuple.getPropagationContext());
                    smem.getStagedLeftTuples().addUpdate(peer);
                }
                smem = smem.getNext();
            }
        }
    }

    private static void updateChildLeftTupleDuringInsert(LeftTuple childLeftTuple, TupleSets<LeftTuple> stagedLeftTuples, TupleSets<LeftTuple> trgLeftTuples) {
        switch (childLeftTuple.getStagedType()) {
            case 1: {
                stagedLeftTuples.removeInsert(childLeftTuple);
                trgLeftTuples.addInsert(childLeftTuple);
                break;
            }
            case 2: {
                stagedLeftTuples.removeUpdate(childLeftTuple);
                trgLeftTuples.addUpdate(childLeftTuple);
                break;
            }
            default: {
                if (NodeTypeEnums.hasNodeMemory(childLeftTuple.getTupleSink())) {
                    trgLeftTuples.addInsert(childLeftTuple);
                    break;
                }
                trgLeftTuples.addUpdate(childLeftTuple);
            }
        }
    }

    private static void processPeerDeletes(LeftTuple leftTuple, SegmentMemory firstSmem) {
        while (leftTuple != null) {
            SegmentMemory smem = firstSmem.getNext();
            if (smem != null) {
                for (LeftTuple peer = leftTuple.getPeer(); peer != null; peer = peer.getPeer()) {
                    peer.setPropagationContext(leftTuple.getPropagationContext());
                    TupleSets<LeftTuple> stagedLeftTuples = smem.getStagedLeftTuples();
                    stagedLeftTuples.addDelete(peer);
                    smem = smem.getNext();
                }
            }
            leftTuple = (LeftTuple)leftTuple.getStagedNext();
        }
    }
}

