/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.cloudbalancing.swingui.CloudBalancingPanel;
import org.optaplanner.swing.impl.SwingUtils;
import org.optaplanner.swing.impl.TangoColorFactory;

public class CloudComputerPanel
extends JPanel {
    private final CloudBalancingPanel cloudBalancingPanel;
    private CloudComputer computer;
    private List<CloudProcess> processList = new ArrayList<CloudProcess>();
    private JLabel computerLabel;
    private JTextField cpuPowerField;
    private JTextField memoryField;
    private JTextField networkBandwidthField;
    private JTextField costField;
    private JLabel numberOfProcessesLabel;
    private CloudBar cpuPowerBar;
    private CloudBar memoryBar;
    private CloudBar networkBandwidthBar;
    private JButton detailsButton;

    public CloudComputerPanel(CloudBalancingPanel cloudBalancingPanel, CloudComputer computer) {
        super(new GridLayout(0, 5));
        this.cloudBalancingPanel = cloudBalancingPanel;
        this.computer = computer;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2), BorderFactory.createLineBorder(Color.BLACK)), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.createTotalsUI();
        this.createBarsUI();
    }

    public CloudComputer getComputer() {
        return this.computer;
    }

    private String getComputerLabel() {
        return this.computer == null ? "Unassigned" : this.computer.getLabel();
    }

    private int getComputerCpuPower() {
        return this.computer == null ? 0 : this.computer.getCpuPower();
    }

    private int getComputerMemory() {
        return this.computer == null ? 0 : this.computer.getMemory();
    }

    private int getComputerNetworkBandwidth() {
        return this.computer == null ? 0 : this.computer.getNetworkBandwidth();
    }

    private int getComputerCost() {
        return this.computer == null ? 0 : this.computer.getCost();
    }

    private void createTotalsUI() {
        JPanel labelAndDeletePanel = new JPanel(new BorderLayout(5, 0));
        if (this.computer != null) {
            labelAndDeletePanel.add((Component)new JLabel(this.cloudBalancingPanel.getCloudComputerIcon()), "West");
        }
        this.computerLabel = new JLabel(this.getComputerLabel());
        this.computerLabel.setEnabled(false);
        labelAndDeletePanel.add((Component)this.computerLabel, "Center");
        if (this.computer != null) {
            JPanel deletePanel = new JPanel(new BorderLayout());
            JButton deleteButton = SwingUtils.makeSmallButton((JButton)new JButton(this.cloudBalancingPanel.getDeleteCloudComputerIcon()));
            deleteButton.setToolTipText("Delete");
            deleteButton.addActionListener(e -> this.cloudBalancingPanel.deleteComputer(this.computer));
            deletePanel.add((Component)deleteButton, "North");
            labelAndDeletePanel.add((Component)deletePanel, "East");
        }
        this.add(labelAndDeletePanel);
        this.cpuPowerField = new JTextField("0 GHz / " + this.getComputerCpuPower() + " GHz");
        this.cpuPowerField.setEditable(false);
        this.cpuPowerField.setEnabled(false);
        this.add(this.cpuPowerField);
        this.memoryField = new JTextField("0 GB / " + this.getComputerMemory() + " GB");
        this.memoryField.setEditable(false);
        this.memoryField.setEnabled(false);
        this.add(this.memoryField);
        this.networkBandwidthField = new JTextField("0 GB / " + this.getComputerNetworkBandwidth() + " GB");
        this.networkBandwidthField.setEditable(false);
        this.networkBandwidthField.setEnabled(false);
        this.add(this.networkBandwidthField);
        this.costField = new JTextField(this.getComputerCost() + " $");
        this.costField.setEditable(false);
        this.costField.setEnabled(false);
        this.add(this.costField);
    }

    private void createBarsUI() {
        this.numberOfProcessesLabel = new JLabel("    0 processes");
        this.numberOfProcessesLabel.setEnabled(false);
        this.numberOfProcessesLabel.setBorder(BorderFactory.createEmptyBorder(0, 37, 0, 0));
        this.add(this.numberOfProcessesLabel);
        this.cpuPowerBar = new CloudBar(this.getComputerCpuPower(), this.cloudBalancingPanel.getMaximumComputerCpuPower(), CloudProcess::getRequiredCpuPower);
        this.cpuPowerBar.setEnabled(false);
        this.add(this.cpuPowerBar);
        this.memoryBar = new CloudBar(this.getComputerMemory(), this.cloudBalancingPanel.getMaximumComputerMemory(), CloudProcess::getRequiredMemory);
        this.memoryBar.setEnabled(false);
        this.add(this.memoryBar);
        this.networkBandwidthBar = new CloudBar(this.getComputerNetworkBandwidth(), this.cloudBalancingPanel.getMaximumComputerNetworkBandwidth(), CloudProcess::getRequiredNetworkBandwidth);
        this.networkBandwidthBar.setEnabled(false);
        this.add(this.networkBandwidthBar);
        this.detailsButton = new JButton(new AbstractAction("Details"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudProcessListDialog processListDialog = new CloudProcessListDialog();
                processListDialog.setLocationRelativeTo(CloudComputerPanel.this.getRootPane());
                processListDialog.setVisible(true);
            }
        });
        this.detailsButton.setEnabled(false);
        this.add(this.detailsButton);
    }

    public void addProcess(CloudProcess process) {
        this.processList.add(process);
    }

    public void removeProcess(CloudProcess process) {
        this.processList.remove(process);
    }

    public void clearProcesses() {
        this.processList.clear();
    }

    public void update() {
        int usedCpuPower = 0;
        int usedMemory = 0;
        int usedNetworkBandwidth = 0;
        for (CloudProcess process : this.processList) {
            usedCpuPower += process.getRequiredCpuPower();
            usedMemory += process.getRequiredMemory();
            usedNetworkBandwidth += process.getRequiredNetworkBandwidth();
        }
        boolean used = this.processList.size() > 0;
        this.updateTotals(usedCpuPower, usedMemory, usedNetworkBandwidth, used);
        this.updateBars(used);
    }

    private void updateTotals(int usedCpuPower, int usedMemory, int usedNetworkBandwidth, boolean used) {
        this.computerLabel.setEnabled(used);
        this.cpuPowerField.setText(usedCpuPower + " GHz / " + this.getComputerCpuPower() + " GHz");
        this.cpuPowerField.setForeground(usedCpuPower > this.getComputerCpuPower() ? TangoColorFactory.SCARLET_3 : Color.BLACK);
        this.cpuPowerField.setEnabled(used);
        this.memoryField.setText(usedMemory + " GB / " + this.getComputerMemory() + " GB");
        this.memoryField.setForeground(usedMemory > this.getComputerMemory() ? TangoColorFactory.SCARLET_3 : Color.BLACK);
        this.memoryField.setEnabled(used);
        this.networkBandwidthField.setText(usedNetworkBandwidth + " GB / " + this.getComputerNetworkBandwidth() + " GB");
        this.networkBandwidthField.setForeground(usedNetworkBandwidth > this.getComputerNetworkBandwidth() ? TangoColorFactory.SCARLET_3 : Color.BLACK);
        this.networkBandwidthField.setEnabled(used);
        this.costField.setEnabled(used);
    }

    private void updateBars(boolean used) {
        this.numberOfProcessesLabel.setText(this.processList.size() + " processes");
        this.numberOfProcessesLabel.setEnabled(used);
        this.cpuPowerBar.setEnabled(used);
        this.cpuPowerBar.repaint();
        this.memoryBar.setEnabled(used);
        this.memoryBar.repaint();
        this.networkBandwidthBar.setEnabled(used);
        this.networkBandwidthBar.repaint();
        this.detailsButton.setEnabled(used);
    }

    private class CloudBar
    extends JPanel {
        private int computerValue;
        private int maximumComputerValue;
        private ToIntFunction<CloudProcess> processValueExtractor;

        public CloudBar(int computerValue, int maximumComputerValue, ToIntFunction<CloudProcess> processValueExtractor) {
            this.computerValue = computerValue;
            this.maximumComputerValue = maximumComputerValue;
            this.processValueExtractor = processValueExtractor;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Dimension size = this.getSize();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            int maximumComputerWidth = size.width - 10;
            if (maximumComputerWidth <= 10) {
                g.setColor(TangoColorFactory.ALUMINIUM_6);
                g.drawString("?", 2, 2);
                return;
            }
            double pixelsPerValue = (double)maximumComputerWidth / (double)this.maximumComputerValue;
            int computerWidth = (int)(pixelsPerValue * (double)this.computerValue);
            if (this.computerValue > 0) {
                g.setColor(this.isEnabled() ? Color.WHITE : this.getBackground());
                g.fillRect(0, 0, computerWidth, size.height);
            }
            int offsetValue = 0;
            for (CloudProcess process : CloudComputerPanel.this.processList) {
                int processValue = this.processValueExtractor.applyAsInt(process);
                int offset = (int)((double)offsetValue * pixelsPerValue);
                int processWidth = (int)((double)processValue * pixelsPerValue) + 1;
                processWidth = Math.max(processWidth, 1);
                g.setColor(CloudComputerPanel.this.cloudBalancingPanel.getCloudProcessColor(process));
                g.fillRect(offset, 0, processWidth, size.height);
                offsetValue += processValue;
            }
            if (this.computerValue > 0) {
                g.setColor(this.isEnabled() ? Color.BLACK : TangoColorFactory.ALUMINIUM_5);
                g.drawRect(0, 0, computerWidth, size.height - 1);
            }
        }
    }

    private class CloudProcessListDialog
    extends JDialog {
        public CloudProcessListDialog() {
            this.setModal(true);
            this.setTitle(CloudComputerPanel.this.getComputerLabel());
            JPanel contentPanel = new JPanel();
            contentPanel.setLayout(new BorderLayout());
            contentPanel.add((Component)this.createHeaderPanel(), "North");
            JPanel assignmentsPanel = this.createAssignmentsPanel();
            JScrollPane assignmentsScrollPane = new JScrollPane(assignmentsPanel);
            assignmentsScrollPane.setPreferredSize(new Dimension(800, 400));
            assignmentsScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            contentPanel.add((Component)assignmentsScrollPane, "Center");
            JPanel buttonPanel = new JPanel(new FlowLayout());
            AbstractAction okAction = new AbstractAction("Ok"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CloudProcessListDialog.this.dispose();
                }
            };
            buttonPanel.add(new JButton(okAction));
            contentPanel.add((Component)buttonPanel, "South");
            this.setContentPane(contentPanel);
            this.pack();
        }

        private JPanel createHeaderPanel() {
            JPanel headerPanel = new JPanel(new GridLayout(0, 5));
            headerPanel.add(new JLabel(""));
            JLabel cpuPowerLabel = new JLabel("CPU power");
            headerPanel.add(cpuPowerLabel);
            JLabel memoryLabel = new JLabel("Memory");
            headerPanel.add(memoryLabel);
            JLabel networkBandwidthLabel = new JLabel("Network bandwidth");
            headerPanel.add(networkBandwidthLabel);
            headerPanel.add(new JLabel(""));
            return headerPanel;
        }

        private JPanel createAssignmentsPanel() {
            JPanel assignmentsPanel = new JPanel(new GridLayout(0, 1));
            for (CloudProcess process : CloudComputerPanel.this.processList) {
                assignmentsPanel.add(new CloudProcessAssignmentPanel(assignmentsPanel, process));
            }
            JPanel fillerAssignmentsPanel = new JPanel(new BorderLayout());
            fillerAssignmentsPanel.add((Component)assignmentsPanel, "North");
            return fillerAssignmentsPanel;
        }

        private class CloudProcessAssignmentPanel
        extends JPanel {
            public CloudProcessAssignmentPanel(JPanel assignmentsPanel, CloudProcess process) {
                super(new GridLayout(0, 5));
                JPanel labelAndDeletePanel = new JPanel(new BorderLayout(5, 0));
                labelAndDeletePanel.add((Component)new JLabel(CloudComputerPanel.this.cloudBalancingPanel.getCloudProcessIcon()), "West");
                JLabel processLabel = new JLabel(process.getLabel());
                processLabel.setForeground(CloudComputerPanel.this.cloudBalancingPanel.getCloudProcessColor(process));
                labelAndDeletePanel.add((Component)processLabel, "Center");
                JPanel deletePanel = new JPanel(new BorderLayout());
                JButton deleteButton = SwingUtils.makeSmallButton((JButton)new JButton(CloudComputerPanel.this.cloudBalancingPanel.getDeleteCloudProcessIcon()));
                deleteButton.setToolTipText("Delete");
                deleteButton.addActionListener(e -> {
                    CloudComputerPanel.this.cloudBalancingPanel.deleteProcess(process);
                    CloudProcessListDialog.this.dispose();
                });
                deletePanel.add((Component)deleteButton, "North");
                labelAndDeletePanel.add((Component)deletePanel, "East");
                this.add(labelAndDeletePanel);
                JTextField cpuPowerField = new JTextField(process.getRequiredCpuPower() + " GHz");
                cpuPowerField.setEditable(false);
                this.add(cpuPowerField);
                JTextField memoryField = new JTextField(process.getRequiredMemory() + " GB");
                memoryField.setEditable(false);
                this.add(memoryField);
                JTextField networkBandwidthField = new JTextField(process.getRequiredNetworkBandwidth() + " GB");
                networkBandwidthField.setEditable(false);
                this.add(networkBandwidthField);
                this.add(CloudComputerPanel.this.cloudBalancingPanel.createButton(process, () -> {
                    assignmentsPanel.remove(this);
                    assignmentsPanel.revalidate();
                }));
            }
        }
    }
}

