/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.machinereassignment.domain.MrBalancePenalty;
import org.optaplanner.examples.machinereassignment.domain.MrGlobalPenaltyInfo;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrMachineCapacity;
import org.optaplanner.examples.machinereassignment.domain.MrProcessAssignment;
import org.optaplanner.examples.machinereassignment.domain.solver.MrServiceDependency;

public class MachineReassignmentConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory factory) {
        return new Constraint[]{this.maximumCapacity(factory), this.serviceConflict(factory), this.serviceLocationSpread(factory), this.serviceDependency(factory), this.transientUsage(factory), this.loadCost(factory), this.balanceCost(factory), this.processMoveCost(factory), this.serviceMoveCost(factory), this.machineMoveCost(factory)};
    }

    protected Constraint maximumCapacity(ConstraintFactory factory) {
        return factory.forEach(MrMachineCapacity.class).join(MrProcessAssignment.class, Joiners.equal(MrMachineCapacity::getMachine, MrProcessAssignment::getMachine)).groupBy((machineCapacity, processAssignment) -> machineCapacity.getMachine(), (machineCapacity, processAssignment) -> machineCapacity, ConstraintCollectors.sumLong((machineCapacity, processAssignment) -> processAssignment.getUsage(machineCapacity.getResource()))).filter((machine, machineCapacity, usage) -> machineCapacity.getMaximumCapacity() < usage).penalizeLong((Score)HardSoftLongScore.ONE_HARD, (machine, machineCapacity, usage) -> usage - machineCapacity.getMaximumCapacity()).asConstraint("maximumCapacity");
    }

    protected Constraint serviceConflict(ConstraintFactory factory) {
        return factory.forEachUniquePair(MrProcessAssignment.class, Joiners.equal(MrProcessAssignment::getMachine, MrProcessAssignment::getMachine), Joiners.equal(MrProcessAssignment::getService, MrProcessAssignment::getService)).penalize((Score)HardSoftLongScore.ONE_HARD).asConstraint("serviceConflict");
    }

    protected Constraint serviceLocationSpread(ConstraintFactory factory) {
        return factory.forEach(MrProcessAssignment.class).groupBy(MrProcessAssignment::getService, ConstraintCollectors.countDistinct(MrProcessAssignment::getLocation)).filter((service, distinctLocationCount) -> distinctLocationCount < service.getLocationSpread()).penalizeLong((Score)HardSoftLongScore.ONE_HARD, (service, distinctLocationCount) -> service.getLocationSpread() - distinctLocationCount).asConstraint("serviceLocationSpread");
    }

    protected Constraint serviceDependency(ConstraintFactory factory) {
        return factory.forEach(MrServiceDependency.class).join(MrProcessAssignment.class, Joiners.equal(MrServiceDependency::getFromService, MrProcessAssignment::getService)).ifExists(MrProcessAssignment.class, Joiners.equal((serviceDependency, processFrom) -> serviceDependency.getToService(), MrProcessAssignment::getService), Joiners.filtering((serviceDependency, processFrom, processTo) -> !processFrom.getNeighborhood().equals(processTo.getNeighborhood()))).penalize((Score)HardSoftLongScore.ONE_HARD).asConstraint("serviceDependency");
    }

    protected Constraint transientUsage(ConstraintFactory factory) {
        return factory.forEach(MrMachineCapacity.class).filter(MrMachineCapacity::isTransientlyConsumed).join(factory.forEach(MrProcessAssignment.class).filter(MrProcessAssignment::isMoved), Joiners.equal(MrMachineCapacity::getMachine, MrProcessAssignment::getOriginalMachine)).groupBy((machineCapacity, processAssignment) -> machineCapacity, ConstraintCollectors.sumLong((machineCapacity, processAssignment) -> processAssignment.getUsage(machineCapacity.getResource()))).filter((machineCapacity, usage) -> machineCapacity.getMaximumCapacity() < usage).penalizeLong((Score)HardSoftLongScore.ONE_HARD, (machineCapacity, usage) -> usage - machineCapacity.getMaximumCapacity()).asConstraint("transientUsage");
    }

    protected Constraint loadCost(ConstraintFactory factory) {
        return factory.forEach(MrMachineCapacity.class).join(MrProcessAssignment.class, Joiners.equal(MrMachineCapacity::getMachine, MrProcessAssignment::getMachine)).groupBy((machineCapacity, processAssignment) -> machineCapacity, ConstraintCollectors.sumLong((machineCapacity, processAssignment) -> processAssignment.getUsage(machineCapacity.getResource()))).filter((machineCapacity, usage) -> machineCapacity.getSafetyCapacity() < usage).penalizeLong((Score)HardSoftLongScore.ONE_SOFT, (machineCapacity, usage) -> (long)machineCapacity.getResource().getLoadCostWeight() * (usage - machineCapacity.getSafetyCapacity())).asConstraint("loadCost");
    }

    protected Constraint balanceCost(ConstraintFactory factory) {
        return factory.forEach(MrBalancePenalty.class).join(MrProcessAssignment.class).groupBy((penalty, processAssignment) -> penalty, (penalty, processAssignment) -> processAssignment.getMachine(), ConstraintCollectors.sumLong((penalty, processAssignment) -> processAssignment.getUsage(penalty.getOriginResource())), ConstraintCollectors.sumLong((penalty, processAssignment) -> processAssignment.getUsage(penalty.getTargetResource()))).penalizeLong((Score)HardSoftLongScore.ONE_SOFT, this::balanceCost).asConstraint("balanceCost");
    }

    private long balanceCost(MrBalancePenalty penalty, MrMachine machine, long originalUsage, long targetUsage) {
        long originalAvailability = machine.getMachineCapacity(penalty.getOriginResource()).getMaximumCapacity() - originalUsage;
        long targetAvailability = machine.getMachineCapacity(penalty.getTargetResource()).getMaximumCapacity() - targetUsage;
        long lackingAvailability = (long)penalty.getMultiplicand() * originalAvailability - targetAvailability;
        if (lackingAvailability <= 0L) {
            return 0L;
        }
        return lackingAvailability * (long)penalty.getWeight();
    }

    protected Constraint processMoveCost(ConstraintFactory factory) {
        return factory.forEach(MrProcessAssignment.class).filter(processAssignment -> processAssignment.isMoved() && processAssignment.getProcessMoveCost() > 0).join(MrGlobalPenaltyInfo.class, Joiners.filtering((processAssignment, penalty) -> penalty.getProcessMoveCostWeight() > 0)).penalize((Score)HardSoftLongScore.ONE_SOFT, (processAssignment, penalty) -> processAssignment.getProcessMoveCost() * penalty.getProcessMoveCostWeight()).asConstraint("processMoveCost");
    }

    protected Constraint serviceMoveCost(ConstraintFactory factory) {
        return factory.forEach(MrProcessAssignment.class).filter(MrProcessAssignment::isMoved).groupBy(MrProcessAssignment::getService, ConstraintCollectors.count()).groupBy(ConstraintCollectors.max((service, count) -> count)).join(MrGlobalPenaltyInfo.class).penalize((Score)HardSoftLongScore.ONE_SOFT, (count, penalty) -> count * penalty.getServiceMoveCostWeight()).asConstraint("serviceMoveCost");
    }

    protected Constraint machineMoveCost(ConstraintFactory factory) {
        return factory.forEach(MrProcessAssignment.class).filter(processAssignment -> processAssignment.isMoved() && processAssignment.getMachineMoveCost() > 0).join(MrGlobalPenaltyInfo.class, Joiners.filtering((processAssignment, penalty) -> penalty.getMachineMoveCostWeight() > 0)).penalize((Score)HardSoftLongScore.ONE_SOFT, (processAssignment, penalty) -> processAssignment.getMachineMoveCost() * penalty.getMachineMoveCostWeight()).asConstraint("machineMoveCost");
    }
}

