/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.BavetConstraint;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.BavetAbstractUniConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.BavetForEachUniConstraintStream;
import org.optaplanner.constraint.streams.common.InnerConstraintFactory;
import org.optaplanner.constraint.streams.common.RetrievalSemantics;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintConfigurationDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;

public final class BavetConstraintFactory<Solution_>
extends InnerConstraintFactory<Solution_, BavetConstraint<Solution_>> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final String defaultConstraintPackage;
    private final Map<BavetAbstractConstraintStream<Solution_>, BavetAbstractConstraintStream<Solution_>> sharingStreamMap = new HashMap<BavetAbstractConstraintStream<Solution_>, BavetAbstractConstraintStream<Solution_>>(256);

    public BavetConstraintFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
        Package pack;
        this.solutionDescriptor = solutionDescriptor;
        ConstraintConfigurationDescriptor configurationDescriptor = solutionDescriptor.getConstraintConfigurationDescriptor();
        this.defaultConstraintPackage = configurationDescriptor == null ? ((pack = solutionDescriptor.getSolutionClass().getPackage()) == null ? "" : pack.getName()) : configurationDescriptor.getConstraintPackage();
    }

    public <Stream_ extends BavetAbstractConstraintStream<Solution_>> Stream_ share(Stream_ stream) {
        return (Stream_)((Object)this.share(stream, t -> {}));
    }

    public <Stream_ extends BavetAbstractConstraintStream<Solution_>> Stream_ share(Stream_ stream, Consumer<Stream_> consumer) {
        return (Stream_)((Object)this.sharingStreamMap.computeIfAbsent(stream, k -> {
            consumer.accept(stream);
            return stream;
        }));
    }

    public <A> UniConstraintStream<A> forEachIncludingNullVars(Class<A> sourceClass) {
        this.assertValidFromType(sourceClass);
        return (UniConstraintStream)this.share(new BavetForEachUniConstraintStream(this, sourceClass, RetrievalSemantics.STANDARD));
    }

    public <A> BavetAbstractUniConstraintStream<Solution_, A> fromUnfiltered(Class<A> fromClass) {
        this.assertValidFromType(fromClass);
        return this.share(new BavetForEachUniConstraintStream(this, fromClass, RetrievalSemantics.LEGACY));
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public String getDefaultConstraintPackage() {
        return this.defaultConstraintPackage;
    }
}

