/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.travelingtournament.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.travelingtournament.domain.Day;
import org.optaplanner.examples.travelingtournament.domain.Match;

public final class TravelingTournamentConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.fourConsecutiveHomeMatches(constraintFactory), this.fourConsecutiveAwayMatches(constraintFactory), this.repeatMatchOnTheNextDay(constraintFactory), this.startToAwayHop(constraintFactory), this.homeToAwayHop(constraintFactory), this.awayToAwayHop(constraintFactory), this.awayToHomeHop(constraintFactory), this.awayToEndHop(constraintFactory)};
    }

    private Constraint fourConsecutiveHomeMatches(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Match.class).ifExists(Match.class, Joiners.equal(Match::getHomeTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 1, TravelingTournamentConstraintProvider::getDayIndex)).ifExists(Match.class, Joiners.equal(Match::getHomeTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 2, TravelingTournamentConstraintProvider::getDayIndex)).ifExists(Match.class, Joiners.equal(Match::getHomeTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 3, TravelingTournamentConstraintProvider::getDayIndex)).penalize((Score)HardSoftScore.ONE_HARD).asConstraint("4 consecutive home matches");
    }

    private Constraint fourConsecutiveAwayMatches(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Match.class).ifExists(Match.class, Joiners.equal(Match::getAwayTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 1, TravelingTournamentConstraintProvider::getDayIndex)).ifExists(Match.class, Joiners.equal(Match::getAwayTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 2, TravelingTournamentConstraintProvider::getDayIndex)).ifExists(Match.class, Joiners.equal(Match::getAwayTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 3, TravelingTournamentConstraintProvider::getDayIndex)).penalize((Score)HardSoftScore.ONE_HARD).asConstraint("4 consecutive away matches");
    }

    private Constraint repeatMatchOnTheNextDay(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Match.class).ifExists(Match.class, Joiners.equal(Match::getHomeTeam, Match::getAwayTeam), Joiners.equal(Match::getAwayTeam, Match::getHomeTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 1, TravelingTournamentConstraintProvider::getDayIndex)).penalize((Score)HardSoftScore.ONE_HARD).asConstraint("Repeat match on the next day");
    }

    private Constraint startToAwayHop(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Match.class).ifNotExists(Day.class, Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) - 1, Day::getIndex)).penalize((Score)HardSoftScore.ONE_SOFT, match -> match.getAwayTeam().getDistance(match.getHomeTeam())).asConstraint("Start to away hop");
    }

    private Constraint homeToAwayHop(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Match.class).join(Match.class, Joiners.equal(Match::getHomeTeam, Match::getAwayTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 1, TravelingTournamentConstraintProvider::getDayIndex)).penalize((Score)HardSoftScore.ONE_SOFT, (match, otherMatch) -> match.getHomeTeam().getDistance(otherMatch.getHomeTeam())).asConstraint("Home to away hop");
    }

    private Constraint awayToAwayHop(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Match.class).join(Match.class, Joiners.equal(Match::getAwayTeam, Match::getAwayTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 1, TravelingTournamentConstraintProvider::getDayIndex)).penalize((Score)HardSoftScore.ONE_SOFT, (match, otherMatch) -> match.getHomeTeam().getDistance(otherMatch.getHomeTeam())).asConstraint("Away to away hop");
    }

    private Constraint awayToHomeHop(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Match.class).join(Match.class, Joiners.equal(Match::getAwayTeam, Match::getHomeTeam), Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 1, TravelingTournamentConstraintProvider::getDayIndex)).penalize((Score)HardSoftScore.ONE_SOFT, (match, otherMatch) -> match.getHomeTeam().getDistance(match.getAwayTeam())).asConstraint("Away to home hop");
    }

    private Constraint awayToEndHop(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Match.class).ifNotExists(Day.class, Joiners.equal(match -> TravelingTournamentConstraintProvider.getDayIndex(match) + 1, Day::getIndex)).penalize((Score)HardSoftScore.ONE_SOFT, match -> match.getHomeTeam().getDistance(match.getAwayTeam())).asConstraint("Away to end hop");
    }

    private static int getDayIndex(Match match) {
        return match.getDay().getIndex();
    }
}

