/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.InverseRelationShadowVariable;
import org.optaplanner.core.api.domain.variable.NextElementShadowVariable;
import org.optaplanner.core.api.domain.variable.PreviousElementShadowVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.jackson.JacksonUniqueIdGenerator;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.solver.DepotAngleCustomerDifficultyWeightFactory;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;

@PlanningEntity(difficultyWeightFactoryClass=DepotAngleCustomerDifficultyWeightFactory.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=TimeWindowedCustomer.class, name="timeWindowed")})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonIdentityInfo(generator=JacksonUniqueIdGenerator.class)
public class Customer
extends AbstractPersistable {
    protected Location location;
    protected int demand;
    protected Vehicle vehicle;
    protected Customer previousCustomer;
    protected Customer nextCustomer;

    public Customer() {
    }

    public Customer(long id, Location location, int demand) {
        super(id);
        this.location = location;
        this.demand = demand;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public int getDemand() {
        return this.demand;
    }

    public void setDemand(int demand) {
        this.demand = demand;
    }

    @InverseRelationShadowVariable(sourceVariableName="customers")
    public Vehicle getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(Vehicle vehicle) {
        this.vehicle = vehicle;
    }

    @PreviousElementShadowVariable(sourceVariableName="customers")
    public Customer getPreviousCustomer() {
        return this.previousCustomer;
    }

    public void setPreviousCustomer(Customer previousCustomer) {
        this.previousCustomer = previousCustomer;
    }

    @NextElementShadowVariable(sourceVariableName="customers")
    public Customer getNextCustomer() {
        return this.nextCustomer;
    }

    public void setNextCustomer(Customer nextCustomer) {
        this.nextCustomer = nextCustomer;
    }

    @JsonIgnore
    public long getDistanceFromPreviousStandstill() {
        if (this.vehicle == null) {
            throw new IllegalStateException("This method must not be called when the shadow variables are not initialized yet.");
        }
        if (this.previousCustomer == null) {
            return this.vehicle.getLocation().getDistanceTo(this.location);
        }
        return this.previousCustomer.getLocation().getDistanceTo(this.location);
    }

    @JsonIgnore
    public long getDistanceToDepot() {
        return this.location.getDistanceTo(this.vehicle.getLocation());
    }

    @Override
    public String toString() {
        if (this.location.getName() == null) {
            return super.toString();
        }
        return this.location.getName();
    }
}

