/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.ProblemBenchmarksConfig;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;
import org.optaplanner.benchmark.impl.loader.FileProblemProvider;
import org.optaplanner.benchmark.impl.loader.InstanceProblemProvider;
import org.optaplanner.benchmark.impl.loader.ProblemProvider;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.PureSubSingleStatistic;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.solver.DefaultSolverFactory;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public class ProblemBenchmarksFactory {
    private final ProblemBenchmarksConfig config;

    public ProblemBenchmarksFactory(ProblemBenchmarksConfig config) {
        this.config = config;
    }

    public <Solution_> void buildProblemBenchmarkList(SolverBenchmarkResult solverBenchmarkResult, Solution_[] extraProblems) {
        PlannerBenchmarkResult plannerBenchmarkResult = solverBenchmarkResult.getPlannerBenchmarkResult();
        List<ProblemBenchmarkResult> unifiedProblemBenchmarkResultList = plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList();
        for (ProblemProvider<Solution_> problemProvider : this.buildProblemProviderList(solverBenchmarkResult, extraProblems)) {
            ProblemBenchmarkResult problemBenchmarkResult;
            ProblemBenchmarkResult newProblemBenchmarkResult = this.buildProblemBenchmark(plannerBenchmarkResult, problemProvider);
            int index = unifiedProblemBenchmarkResultList.indexOf(newProblemBenchmarkResult);
            if (index < 0) {
                problemBenchmarkResult = newProblemBenchmarkResult;
                unifiedProblemBenchmarkResultList.add(problemBenchmarkResult);
            } else {
                problemBenchmarkResult = unifiedProblemBenchmarkResultList.get(index);
            }
            this.buildSingleBenchmark(solverBenchmarkResult, problemBenchmarkResult);
        }
    }

    private <Solution_> List<ProblemProvider<Solution_>> buildProblemProviderList(SolverBenchmarkResult solverBenchmarkResult, Solution_[] extraProblems) {
        if (ConfigUtils.isEmptyCollection(this.config.getInputSolutionFileList()) && extraProblems.length == 0) {
            throw new IllegalArgumentException("The solverBenchmarkResult (" + solverBenchmarkResult.getName() + ") has no problems.\nMaybe configure at least 1 <inputSolutionFile> directly or indirectly by inheriting it.\nOr maybe pass at least one problem to " + PlannerBenchmarkFactory.class.getSimpleName() + ".buildPlannerBenchmark().");
        }
        ArrayList<ProblemProvider<Solution_>> problemProviderList = new ArrayList<ProblemProvider<Solution_>>(extraProblems.length + (this.config.getInputSolutionFileList() == null ? 0 : this.config.getInputSolutionFileList().size()));
        DefaultSolverFactory defaultSolverFactory = new DefaultSolverFactory(solverBenchmarkResult.getSolverConfig());
        SolutionDescriptor solutionDescriptor = defaultSolverFactory.getSolutionDescriptor();
        int extraProblemIndex = 0;
        for (Solution_ extraProblem : extraProblems) {
            if (extraProblem == null) {
                throw new IllegalStateException("The benchmark problem (" + extraProblem + ") is null.");
            }
            String problemName = "Problem_" + extraProblemIndex;
            problemProviderList.add(new InstanceProblemProvider<Solution_>(problemName, solutionDescriptor, extraProblem));
            ++extraProblemIndex;
        }
        if (ConfigUtils.isEmptyCollection(this.config.getInputSolutionFileList())) {
            if (this.config.getSolutionFileIOClass() != null) {
                throw new IllegalArgumentException("Cannot use solutionFileIOClass (" + this.config.getSolutionFileIOClass() + ") with an empty inputSolutionFileList (" + this.config.getInputSolutionFileList() + ").");
            }
        } else {
            SolutionFileIO<Solution_> solutionFileIO = this.buildSolutionFileIO();
            for (File inputSolutionFile : this.config.getInputSolutionFileList()) {
                if (!inputSolutionFile.exists()) {
                    throw new IllegalArgumentException("The inputSolutionFile (" + inputSolutionFile + ") does not exist.");
                }
                problemProviderList.add(new FileProblemProvider<Solution_>(solutionFileIO, inputSolutionFile));
            }
        }
        return problemProviderList;
    }

    private <Solution_> SolutionFileIO<Solution_> buildSolutionFileIO() {
        if (this.config.getSolutionFileIOClass() == null) {
            throw new IllegalArgumentException("The solutionFileIOClass (" + this.config.getSolutionFileIOClass() + ") cannot be null.");
        }
        return (SolutionFileIO)ConfigUtils.newInstance((Object)((Object)this.config), (String)"solutionFileIOClass", this.config.getSolutionFileIOClass());
    }

    private <Solution_> ProblemBenchmarkResult<Solution_> buildProblemBenchmark(PlannerBenchmarkResult plannerBenchmarkResult, ProblemProvider<Solution_> problemProvider) {
        ArrayList<ProblemStatistic> problemStatisticList;
        ProblemBenchmarkResult<Solution_> problemBenchmarkResult = new ProblemBenchmarkResult<Solution_>(plannerBenchmarkResult);
        problemBenchmarkResult.setName(problemProvider.getProblemName());
        problemBenchmarkResult.setProblemProvider(problemProvider);
        problemBenchmarkResult.setWriteOutputSolutionEnabled(this.config.getWriteOutputSolutionEnabled() == null ? false : this.config.getWriteOutputSolutionEnabled());
        if (this.config.getProblemStatisticEnabled() != null && !this.config.getProblemStatisticEnabled().booleanValue()) {
            if (!ConfigUtils.isEmptyCollection(this.config.getProblemStatisticTypeList())) {
                throw new IllegalArgumentException("The problemStatisticEnabled (" + this.config.getProblemStatisticEnabled() + ") and problemStatisticTypeList (" + this.config.getProblemStatisticTypeList() + ") cannot be used together.");
            }
            problemStatisticList = Collections.emptyList();
        } else {
            List<ProblemStatisticType> problemStatisticTypeList_ = this.config.determineProblemStatisticTypeList();
            problemStatisticList = new ArrayList(problemStatisticTypeList_.size());
            for (ProblemStatisticType problemStatisticType : problemStatisticTypeList_) {
                problemStatisticList.add(problemStatisticType.buildProblemStatistic(problemBenchmarkResult));
            }
        }
        problemBenchmarkResult.setProblemStatisticList(problemStatisticList);
        problemBenchmarkResult.setSingleBenchmarkResultList(new ArrayList<SingleBenchmarkResult>());
        return problemBenchmarkResult;
    }

    private void buildSingleBenchmark(SolverBenchmarkResult solverBenchmarkResult, ProblemBenchmarkResult problemBenchmarkResult) {
        SingleBenchmarkResult singleBenchmarkResult = new SingleBenchmarkResult(solverBenchmarkResult, problemBenchmarkResult);
        this.buildSubSingleBenchmarks(singleBenchmarkResult, solverBenchmarkResult.getSubSingleCount());
        List<SingleStatisticType> singleStatisticTypeList = this.config.determineSingleStatisticTypeList();
        for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
            subSingleBenchmarkResult.setPureSubSingleStatisticList(new ArrayList<PureSubSingleStatistic>(singleStatisticTypeList.size()));
        }
        for (SingleStatisticType singleStatisticType : singleStatisticTypeList) {
            for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                subSingleBenchmarkResult.getPureSubSingleStatisticList().add(singleStatisticType.buildPureSubSingleStatistic(subSingleBenchmarkResult));
            }
        }
        singleBenchmarkResult.initSubSingleStatisticMaps();
        solverBenchmarkResult.getSingleBenchmarkResultList().add(singleBenchmarkResult);
        problemBenchmarkResult.getSingleBenchmarkResultList().add(singleBenchmarkResult);
    }

    private void buildSubSingleBenchmarks(SingleBenchmarkResult parent, int subSingleCount) {
        ArrayList<SubSingleBenchmarkResult> subSingleBenchmarkResultList = new ArrayList<SubSingleBenchmarkResult>(subSingleCount);
        for (int i = 0; i < subSingleCount; ++i) {
            SubSingleBenchmarkResult subSingleBenchmarkResult = new SubSingleBenchmarkResult(parent, i);
            subSingleBenchmarkResultList.add(subSingleBenchmarkResult);
        }
        parent.setSubSingleBenchmarkResultList(subSingleBenchmarkResultList);
    }
}

