/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ObjectType;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.rule.MutableTypeConstraint;
import org.drools.core.rule.constraint.BetaNodeFieldConstraint;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.index.IndexFactory;
import org.drools.core.util.index.IndexUtil;
import org.kie.internal.conf.IndexPrecedenceOption;

public class DefaultBetaConstraints
implements BetaConstraints {
    private static final long serialVersionUID = 510L;
    protected transient boolean disableIndexing;
    protected BetaNodeFieldConstraint[] constraints;
    protected IndexPrecedenceOption indexPrecedenceOption;
    protected int indexed;
    private transient Boolean leftUpdateOptimizationAllowed;

    public DefaultBetaConstraints() {
    }

    public DefaultBetaConstraints(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf) {
        this(constraints, conf, false);
    }

    public DefaultBetaConstraints(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf, boolean disableIndexing) {
        this.constraints = constraints;
        this.disableIndexing = disableIndexing;
        this.indexPrecedenceOption = conf.getIndexPrecedenceOption();
    }

    @Override
    public DefaultBetaConstraints cloneIfInUse() {
        if (this.constraints[0] instanceof MutableTypeConstraint && ((MutableTypeConstraint)this.constraints[0]).setInUse()) {
            BetaNodeFieldConstraint[] clonedConstraints = new BetaNodeFieldConstraint[this.constraints.length];
            for (int i = 0; i < this.constraints.length; ++i) {
                clonedConstraints[i] = this.constraints[i].cloneIfInUse();
            }
            DefaultBetaConstraints clone = new DefaultBetaConstraints();
            clone.constraints = clonedConstraints;
            clone.disableIndexing = this.disableIndexing;
            clone.indexPrecedenceOption = this.indexPrecedenceOption;
            clone.indexed = this.indexed;
            return clone;
        }
        return this;
    }

    @Override
    public void init(BuildContext context, short betaNodeType) {
        RuleBaseConfiguration config = context.getRuleBase().getRuleBaseConfiguration();
        if (this.disableIndexing || !config.isIndexLeftBetaMemory() && !config.isIndexRightBetaMemory()) {
            this.indexed = 0;
        } else {
            int depth = config.getCompositeKeyDepth();
            if (!IndexUtil.compositeAllowed(this.constraints, betaNodeType, config)) {
                depth = 1;
            }
            this.initIndexes(depth, betaNodeType, config);
        }
    }

    @Override
    public void initIndexes(int depth, short betaNodeType, RuleBaseConfiguration config) {
        boolean[] indexable;
        this.indexed = 0;
        for (boolean i : indexable = IndexUtil.isIndexableForNode(this.indexPrecedenceOption, betaNodeType, depth, this.constraints, config)) {
            if (!i) break;
            ++this.indexed;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraints = (BetaNodeFieldConstraint[])in.readObject();
        this.indexed = in.readInt();
        this.indexPrecedenceOption = (IndexPrecedenceOption)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.constraints);
        out.writeInt(this.indexed);
        out.writeObject(this.indexPrecedenceOption);
    }

    @Override
    public ContextEntry[] createContext() {
        ContextEntry[] entries = new ContextEntry[this.constraints.length];
        for (int i = 0; i < this.constraints.length; ++i) {
            entries[i] = this.constraints[i].createContextEntry();
        }
        return entries;
    }

    @Override
    public void updateFromTuple(ContextEntry[] context, ReteEvaluator reteEvaluator, Tuple tuple) {
        for (ContextEntry aContext : context) {
            aContext.updateFromTuple(reteEvaluator, tuple);
        }
    }

    @Override
    public void updateFromFactHandle(ContextEntry[] context, ReteEvaluator reteEvaluator, InternalFactHandle handle) {
        for (ContextEntry aContext : context) {
            aContext.updateFromFactHandle(reteEvaluator, handle);
        }
    }

    @Override
    public void resetTuple(ContextEntry[] context) {
        for (ContextEntry aContext : context) {
            aContext.resetTuple();
        }
    }

    @Override
    public void resetFactHandle(ContextEntry[] context) {
        for (ContextEntry aContext : context) {
            aContext.resetFactHandle();
        }
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry[] context, InternalFactHandle handle) {
        for (int i = this.indexed; i < this.constraints.length; ++i) {
            if (this.constraints[i].isAllowedCachedLeft(context[i], handle)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllowedCachedRight(ContextEntry[] context, Tuple tuple) {
        for (int i = this.indexed; i < this.constraints.length; ++i) {
            if (this.constraints[i].isAllowedCachedRight(tuple, context[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isIndexed() {
        return this.indexed > 0;
    }

    @Override
    public int getIndexCount() {
        return this.indexed;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public BetaMemory createBetaMemory(RuleBaseConfiguration config, short nodeType) {
        return IndexFactory.createBetaMemory(config, nodeType, this.constraints);
    }

    public int hashCode() {
        return Arrays.hashCode(this.constraints);
    }

    @Override
    public BetaNodeFieldConstraint[] getConstraints() {
        return this.constraints;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultBetaConstraints)) {
            return false;
        }
        DefaultBetaConstraints other = (DefaultBetaConstraints)object;
        if (this.constraints == other.constraints) {
            return true;
        }
        if (this.constraints.length != other.constraints.length) {
            return false;
        }
        return Arrays.equals(this.constraints, other.constraints);
    }

    @Override
    public BetaConstraints getOriginalConstraint() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitMask getListenedPropertyMask(ObjectType modifiedType, List<String> settableProperties) {
        BitMask mask = PropertySpecificUtil.getEmptyPropertyReactiveMask(settableProperties.size());
        for (BetaNodeFieldConstraint constraint : this.constraints) {
            mask = mask.setAll(constraint.getListenedPropertyMask(modifiedType, settableProperties));
        }
        return mask;
    }

    @Override
    public boolean isLeftUpdateOptimizationAllowed() {
        if (this.leftUpdateOptimizationAllowed == null) {
            this.leftUpdateOptimizationAllowed = this.calcLeftUpdateOptimizationAllowed();
        }
        return this.leftUpdateOptimizationAllowed;
    }

    private boolean calcLeftUpdateOptimizationAllowed() {
        for (BetaNodeFieldConstraint constraint : this.constraints) {
            if (constraint instanceof IndexableConstraint && ((IndexableConstraint)((Object)constraint)).getConstraintType().isEquality()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void registerEvaluationContext(BuildContext buildContext) {
        for (int i = 0; i < this.constraints.length; ++i) {
            this.constraints[i].registerEvaluationContext(buildContext);
        }
    }
}

