/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.cloner;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.solution.cloner.BooleanFieldCloner;
import org.optaplanner.core.impl.domain.solution.cloner.ByteFieldCloner;
import org.optaplanner.core.impl.domain.solution.cloner.CharFieldCloner;
import org.optaplanner.core.impl.domain.solution.cloner.ConcurrentMemoization;
import org.optaplanner.core.impl.domain.solution.cloner.DeepCloningFieldCloner;
import org.optaplanner.core.impl.domain.solution.cloner.DeepCloningUtils;
import org.optaplanner.core.impl.domain.solution.cloner.DoubleFieldCloner;
import org.optaplanner.core.impl.domain.solution.cloner.FieldCloner;
import org.optaplanner.core.impl.domain.solution.cloner.FloatFieldCloner;
import org.optaplanner.core.impl.domain.solution.cloner.IntFieldCloner;
import org.optaplanner.core.impl.domain.solution.cloner.LongFieldCloner;
import org.optaplanner.core.impl.domain.solution.cloner.ShallowCloningFieldCloner;
import org.optaplanner.core.impl.domain.solution.cloner.ShortFieldCloner;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;

public final class FieldAccessingSolutionCloner<Solution_>
implements SolutionCloner<Solution_> {
    private final ConcurrentMap<Class<?>, Constructor<?>> constructorMemoization = new ConcurrentMemoization();
    private final ConcurrentMap<Class<?>, Map<Field, FieldCloner>> fieldListMemoization = new ConcurrentMemoization();
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final DeepCloningUtils deepCloningUtils;

    public FieldAccessingSolutionCloner(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
        this.deepCloningUtils = new DeepCloningUtils(solutionDescriptor);
    }

    @Override
    public Solution_ cloneSolution(Solution_ originalSolution) {
        return new FieldAccessingSolutionClonerRun(originalSolution).call();
    }

    private <C> Constructor<C> retrieveCachedConstructor(Class<C> clazz) {
        return this.constructorMemoization.computeIfAbsent(clazz, key -> {
            Constructor constructor;
            try {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("The class (" + clazz + ") should have a no-arg constructor to create a planning clone.", e);
            }
            constructor.setAccessible(true);
            return constructor;
        });
    }

    private Map<Field, FieldCloner> retrieveCachedFields(Class<?> clazz) {
        return this.fieldListMemoization.computeIfAbsent(clazz, key -> {
            Field[] fields = key.getDeclaredFields();
            IdentityHashMap<Field, FieldCloner> fieldMap = new IdentityHashMap<Field, FieldCloner>(fields.length);
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                fieldMap.put(field, FieldAccessingSolutionCloner.getCloner(clazz, field));
            }
            return fieldMap;
        });
    }

    private static FieldCloner getCloner(Class<?> clazz, Field field) {
        Class<?> fieldType = field.getType();
        if (fieldType.isPrimitive()) {
            if (fieldType == Boolean.TYPE) {
                return BooleanFieldCloner.INSTANCE;
            }
            if (fieldType == Byte.TYPE) {
                return ByteFieldCloner.INSTANCE;
            }
            if (fieldType == Character.TYPE) {
                return CharFieldCloner.INSTANCE;
            }
            if (fieldType == Short.TYPE) {
                return ShortFieldCloner.INSTANCE;
            }
            if (fieldType == Integer.TYPE) {
                return IntFieldCloner.INSTANCE;
            }
            if (fieldType == Long.TYPE) {
                return LongFieldCloner.INSTANCE;
            }
            if (fieldType == Float.TYPE) {
                return FloatFieldCloner.INSTANCE;
            }
            if (fieldType == Double.TYPE) {
                return DoubleFieldCloner.INSTANCE;
            }
            throw new IllegalStateException("Impossible state: The class (" + clazz + ") has a field (" + field + ") of an unknown primitive type (" + fieldType + ").");
        }
        if (fieldType.isEnum() || DeepCloningUtils.IMMUTABLE_CLASSES.contains(fieldType)) {
            return ShallowCloningFieldCloner.INSTANCE;
        }
        return DeepCloningFieldCloner.INSTANCE;
    }

    private final class FieldAccessingSolutionClonerRun
    implements Callable<Solution_> {
        private final Solution_ originalSolution;
        private final Map<Object, Object> originalToCloneMap;
        private final Queue<Unprocessed> unprocessedQueue;

        private FieldAccessingSolutionClonerRun(Solution_ originalSolution) {
            this.originalSolution = originalSolution;
            int entityCount = FieldAccessingSolutionCloner.this.solutionDescriptor.getEntityCount(originalSolution);
            this.unprocessedQueue = new ArrayDeque<Unprocessed>(entityCount + 1);
            this.originalToCloneMap = new IdentityHashMap<Object, Object>(entityCount + 1);
        }

        @Override
        public Solution_ call() {
            Object cloneSolution = this.clone(this.originalSolution);
            this.processQueue();
            this.validateCloneSolution(this.originalSolution, cloneSolution);
            return cloneSolution;
        }

        private <C> C clone(C original) {
            if (original == null) {
                return null;
            }
            Object existingClone = this.originalToCloneMap.get(original);
            if (existingClone != null) {
                return (C)existingClone;
            }
            Class<?> instanceClass = original.getClass();
            Object clone = this.constructClone(instanceClass);
            this.originalToCloneMap.put(original, clone);
            this.copyFields(instanceClass, instanceClass, original, clone);
            return (C)clone;
        }

        private <C> C constructClone(Class<C> clazz) {
            try {
                Constructor<C> constructor = FieldAccessingSolutionCloner.this.retrieveCachedConstructor(clazz);
                return constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("The class (" + clazz + ") should have a no-arg constructor to create a planning clone.", e);
            }
        }

        private <C> void copyFields(Class<C> clazz, Class<? extends C> instanceClass, C original, C clone) {
            for (Map.Entry<Field, FieldCloner> entry : FieldAccessingSolutionCloner.this.retrieveCachedFields(clazz).entrySet()) {
                Field field = entry.getKey();
                FieldCloner fieldCloner = entry.getValue();
                Consumer<Object> unprocessedValueConsumer = fieldCloner.mayDeferClone() ? originalValue -> this.unprocessedQueue.add(new Unprocessed(clone, field, originalValue)) : null;
                fieldCloner.clone(FieldAccessingSolutionCloner.this.deepCloningUtils, field, instanceClass, original, clone, unprocessedValueConsumer);
            }
            Class<C> superclass = clazz.getSuperclass();
            if (superclass != null) {
                this.copyFields(superclass, instanceClass, original, clone);
            }
        }

        private void processQueue() {
            while (!this.unprocessedQueue.isEmpty()) {
                Unprocessed unprocessed = this.unprocessedQueue.remove();
                this.process(unprocessed);
            }
        }

        private void process(Unprocessed unprocessed) {
            Object originalValue = unprocessed.originalValue;
            Field field = unprocessed.field;
            Class<?> fieldType = field.getType();
            Object cloneValue = originalValue instanceof Collection ? this.cloneCollection(fieldType, (Collection)originalValue) : (originalValue instanceof Map ? this.cloneMap(fieldType, (Map)originalValue) : (originalValue.getClass().isArray() ? this.cloneArray(fieldType, originalValue) : this.clone(originalValue)));
            FieldCloner.setFieldValue(unprocessed.bean, field, cloneValue);
        }

        private Object cloneArray(Class<?> expectedType, Object originalArray) {
            int arrayLength = Array.getLength(originalArray);
            Object cloneArray = Array.newInstance(originalArray.getClass().getComponentType(), arrayLength);
            if (!expectedType.isInstance(cloneArray)) {
                throw new IllegalStateException("The cloneArrayClass (" + cloneArray.getClass() + ") created for originalArrayClass (" + originalArray.getClass() + ") is not assignable to the field's type (" + expectedType + ").\nMaybe consider replacing the default " + SolutionCloner.class.getSimpleName() + ".");
            }
            for (int i = 0; i < arrayLength; ++i) {
                Object cloneElement = this.cloneCollectionsElementIfNeeded(Array.get(originalArray, i));
                Array.set(cloneArray, i, cloneElement);
            }
            return cloneArray;
        }

        private <E> Collection<E> cloneCollection(Class<?> expectedType, Collection<E> originalCollection) {
            Collection<E> cloneCollection = this.constructCloneCollection(originalCollection);
            if (!expectedType.isInstance(cloneCollection)) {
                throw new IllegalStateException("The cloneCollectionClass (" + cloneCollection.getClass() + ") created for originalCollectionClass (" + originalCollection.getClass() + ") is not assignable to the field's type (" + expectedType + ").\nMaybe consider replacing the default " + SolutionCloner.class.getSimpleName() + ".");
            }
            for (E originalElement : originalCollection) {
                E cloneElement = this.cloneCollectionsElementIfNeeded(originalElement);
                cloneCollection.add(cloneElement);
            }
            return cloneCollection;
        }

        private <E> Collection<E> constructCloneCollection(Collection<E> originalCollection) {
            if (originalCollection instanceof List) {
                if (originalCollection instanceof ArrayList) {
                    return new ArrayList(originalCollection.size());
                }
                if (originalCollection instanceof LinkedList) {
                    return new LinkedList();
                }
                return new ArrayList(originalCollection.size());
            }
            if (originalCollection instanceof Set) {
                if (originalCollection instanceof SortedSet) {
                    Comparator setComparator = ((SortedSet)originalCollection).comparator();
                    return new TreeSet(setComparator);
                }
                if (originalCollection instanceof LinkedHashSet) {
                    return new LinkedHashSet(originalCollection.size());
                }
                if (originalCollection instanceof HashSet) {
                    return new HashSet(originalCollection.size());
                }
                return new LinkedHashSet(originalCollection.size());
            }
            if (originalCollection instanceof Deque) {
                return new ArrayDeque(originalCollection.size());
            }
            return new ArrayList(originalCollection.size());
        }

        private <K, V> Map<K, V> cloneMap(Class<?> expectedType, Map<K, V> originalMap) {
            Map<K, V> cloneMap = this.constructCloneMap(originalMap);
            if (!expectedType.isInstance(cloneMap)) {
                throw new IllegalStateException("The cloneMapClass (" + cloneMap.getClass() + ") created for originalMapClass (" + originalMap.getClass() + ") is not assignable to the field's type (" + expectedType + ").\nMaybe consider replacing the default " + SolutionCloner.class.getSimpleName() + ".");
            }
            for (Map.Entry<K, V> originalEntry : originalMap.entrySet()) {
                K cloneKey = this.cloneCollectionsElementIfNeeded(originalEntry.getKey());
                V cloneValue = this.cloneCollectionsElementIfNeeded(originalEntry.getValue());
                cloneMap.put(cloneKey, cloneValue);
            }
            return cloneMap;
        }

        private <K, V> Map<K, V> constructCloneMap(Map<K, V> originalMap) {
            if (originalMap instanceof SortedMap) {
                Comparator setComparator = ((SortedMap)originalMap).comparator();
                return new TreeMap(setComparator);
            }
            if (originalMap instanceof LinkedHashMap) {
                return new LinkedHashMap(originalMap.size());
            }
            if (originalMap instanceof HashMap) {
                return new HashMap(originalMap.size());
            }
            return new LinkedHashMap(originalMap.size());
        }

        private <C> C cloneCollectionsElementIfNeeded(C original) {
            if (original == null) {
                return null;
            }
            if (original instanceof Collection) {
                return (C)this.cloneCollection(Collection.class, (Collection)original);
            }
            if (original instanceof Map) {
                return (C)this.cloneMap(Map.class, (Map)original);
            }
            if (original.getClass().isArray()) {
                return (C)this.cloneArray(original.getClass(), original);
            }
            if (FieldAccessingSolutionCloner.this.deepCloningUtils.retrieveDeepCloneDecisionForActualValueClass(original.getClass())) {
                return this.clone(original);
            }
            return original;
        }

        private void validateCloneSolution(Solution_ originalSolution, Solution_ cloneSolution) {
            for (MemberAccessor memberAccessor : FieldAccessingSolutionCloner.this.solutionDescriptor.getEntityMemberAccessorMap().values()) {
                this.validateCloneProperty(originalSolution, cloneSolution, memberAccessor);
            }
            for (MemberAccessor memberAccessor : FieldAccessingSolutionCloner.this.solutionDescriptor.getEntityCollectionMemberAccessorMap().values()) {
                this.validateCloneProperty(originalSolution, cloneSolution, memberAccessor);
            }
        }

        private void validateCloneProperty(Solution_ originalSolution, Solution_ cloneSolution, MemberAccessor memberAccessor) {
            Object cloneProperty;
            Object originalProperty = memberAccessor.executeGetter(originalSolution);
            if (originalProperty != null && originalProperty == (cloneProperty = memberAccessor.executeGetter(cloneSolution))) {
                throw new IllegalStateException("The solutionProperty (" + memberAccessor.getName() + ") was not cloned as expected. The " + FieldAccessingSolutionCloner.class.getSimpleName() + " failed to recognize that property's field, probably because its field name is different.");
            }
        }
    }

    private static final class Unprocessed {
        final Object bean;
        final Field field;
        final Object originalValue;

        public Unprocessed(Object bean, Field field, Object originalValue) {
            this.bean = bean;
            this.field = field;
            this.originalValue = originalValue;
        }
    }
}

