/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.nearby;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.selector.Selector;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.util.MemoizingSupply;

public final class NearbyDistanceMatrixDemand<Solution_, Origin_, Destination_>
implements Demand<MemoizingSupply<NearbyDistanceMatrix<Origin_, Destination_>>> {
    private final NearbyDistanceMeter<Origin_, Destination_> meter;
    private final Selector<Solution_> childSelector;
    private final EntitySelector<Solution_> replayingOriginEntitySelector;
    private final ToIntFunction<Origin_> destinationSizeFunction;

    public NearbyDistanceMatrixDemand(NearbyDistanceMeter<Origin_, Destination_> meter, Selector<Solution_> childSelector, EntitySelector<Solution_> replayingOriginEntitySelector, ToIntFunction<Origin_> destinationSizeFunction) {
        this.meter = meter;
        this.childSelector = childSelector;
        this.replayingOriginEntitySelector = replayingOriginEntitySelector;
        this.destinationSizeFunction = destinationSizeFunction;
    }

    @Override
    public MemoizingSupply<NearbyDistanceMatrix<Origin_, Destination_>> createExternalizedSupply(SupplyManager supplyManager) {
        Supplier<NearbyDistanceMatrix> supplier = () -> {
            long childSize;
            if (this.childSelector instanceof EntitySelector && (childSize = ((EntitySelector)this.childSelector).getSize()) > Integer.MAX_VALUE) {
                throw new IllegalStateException("The childEntitySelector (" + this.childSelector + ") has an entitySize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
            }
            long originSize = this.replayingOriginEntitySelector.getSize();
            if (originSize > Integer.MAX_VALUE) {
                throw new IllegalStateException("The originEntitySelector (" + this.replayingOriginEntitySelector + ") has an entitySize (" + originSize + ") which is higher than Integer.MAX_VALUE.");
            }
            NearbyDistanceMatrix nearbyDistanceMatrix = this.childSelector instanceof EntitySelector ? new NearbyDistanceMatrix(this.meter, (int)originSize, (EntitySelector)this.childSelector, this.destinationSizeFunction) : new NearbyDistanceMatrix<Origin_, Destination_>(this.meter, (int)originSize, (ValueSelector)this.childSelector, this.destinationSizeFunction);
            this.replayingOriginEntitySelector.endingIterator().forEachRemaining(origin -> nearbyDistanceMatrix.addAllDestinations(origin));
            return nearbyDistanceMatrix;
        };
        return new MemoizingSupply<NearbyDistanceMatrix<Origin_, Destination_>>(supplier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NearbyDistanceMatrixDemand that = (NearbyDistanceMatrixDemand)o;
        return Objects.equals(this.meter, that.meter) && Objects.equals(this.childSelector, that.childSelector) && Objects.equals(this.replayingOriginEntitySelector, that.replayingOriginEntitySelector);
    }

    public int hashCode() {
        return Objects.hash(this.meter, this.childSelector, this.replayingOriginEntitySelector);
    }
}

