/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Objects;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningListVariable;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.list.SubListSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.list.SubListSwapMoveSelectorConfig;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.RandomSubListSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.RandomSubListSwapMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.SubListSelectorFactory;

public class SubListSwapMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, SubListSwapMoveSelectorConfig> {
    public SubListSwapMoveSelectorFactory(SubListSwapMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        EntitySelector entitySelector = EntitySelectorFactory.create(new EntitySelectorConfig()).buildEntitySelector(configPolicy, minimumCacheType, selectionOrder);
        GenuineVariableDescriptor variableDescriptor = this.getTheOnlyVariableDescriptor(entitySelector.getEntityDescriptor());
        if (!variableDescriptor.isListVariable()) {
            throw new IllegalArgumentException("The subListSwapMoveSelector (" + this.config + ") can only be used when the domain model has a list variable. Check your @" + PlanningEntity.class.getSimpleName() + " and make sure it has a @" + PlanningListVariable.class.getSimpleName() + ".");
        }
        ListVariableDescriptor listVariableDescriptor = (ListVariableDescriptor)variableDescriptor;
        SubListSelectorFactory<Solution_> subListSelectorFactory = SubListSelectorFactory.create((SubListSelectorConfig)((Object)this.config));
        RandomSubListSelector leftSubListSelector = subListSelectorFactory.buildSubListSelector(configPolicy, listVariableDescriptor, entitySelector, minimumCacheType, selectionOrder);
        RandomSubListSelector rightSubListSelector = subListSelectorFactory.buildSubListSelector(configPolicy, listVariableDescriptor, entitySelector, minimumCacheType, selectionOrder);
        boolean selectReversingMoveToo = Objects.requireNonNullElse(((SubListSwapMoveSelectorConfig)this.config).getSelectReversingMoveToo(), true);
        return new RandomSubListSwapMoveSelector(listVariableDescriptor, leftSubListSelector, rightSubListSelector, selectReversingMoveToo);
    }
}

