/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt;

import java.util.Collections;
import java.util.List;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptAffectedElements;

final class FlipSublistAction<Solution_> {
    private final ListVariableDescriptor<Solution_> variableDescriptor;
    private final Object entity;
    private final int fromIndexInclusive;
    private final int toIndexExclusive;

    public FlipSublistAction(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndexInclusive, int toIndexExclusive) {
        this.variableDescriptor = variableDescriptor;
        this.entity = entity;
        this.fromIndexInclusive = fromIndexInclusive;
        this.toIndexExclusive = toIndexExclusive;
    }

    FlipSublistAction<Solution_> createUndoMove() {
        return new FlipSublistAction<Solution_>(this.variableDescriptor, this.entity, this.fromIndexInclusive, this.toIndexExclusive);
    }

    public KOptAffectedElements getAffectedElements() {
        if (this.fromIndexInclusive < this.toIndexExclusive) {
            return KOptAffectedElements.forMiddleRange(this.fromIndexInclusive, this.toIndexExclusive);
        }
        return KOptAffectedElements.forWrappedRange(this.fromIndexInclusive, this.toIndexExclusive);
    }

    void doMoveOnGenuineVariables() {
        List<Object> listVariable = this.variableDescriptor.getListVariable(this.entity);
        FlipSublistAction.flipSublist(listVariable, this.fromIndexInclusive, this.toIndexExclusive);
    }

    public FlipSublistAction<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new FlipSublistAction<Solution_>(this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.entity), this.fromIndexInclusive, this.toIndexExclusive);
    }

    public Object getEntity() {
        return this.entity;
    }

    public static <T> void flipSublist(List<T> originalList, int fromIndexInclusive, int toIndexExclusive) {
        if (fromIndexInclusive < toIndexExclusive) {
            Collections.reverse(originalList.subList(fromIndexInclusive, toIndexExclusive));
        } else {
            List<T> firstHalfReversedPath = originalList.subList(fromIndexInclusive, originalList.size());
            List<T> secondHalfReversedPath = originalList.subList(0, toIndexExclusive);
            int totalLength = firstHalfReversedPath.size() + secondHalfReversedPath.size();
            for (int i = 0; i < totalLength >> 1; ++i) {
                if (i < firstHalfReversedPath.size()) {
                    if (i < secondHalfReversedPath.size()) {
                        int secondHalfIndex = secondHalfReversedPath.size() - i - 1;
                        T savedFirstItem = firstHalfReversedPath.get(i);
                        firstHalfReversedPath.set(i, secondHalfReversedPath.get(secondHalfIndex));
                        secondHalfReversedPath.set(secondHalfIndex, savedFirstItem);
                        continue;
                    }
                    int secondIndex = firstHalfReversedPath.size() - i + secondHalfReversedPath.size() - 1;
                    T savedFirstItem = firstHalfReversedPath.get(i);
                    firstHalfReversedPath.set(i, firstHalfReversedPath.get(secondIndex));
                    firstHalfReversedPath.set(secondIndex, savedFirstItem);
                    continue;
                }
                int firstIndex = i - firstHalfReversedPath.size();
                int secondIndex = secondHalfReversedPath.size() - i - 1;
                T savedFirstItem = secondHalfReversedPath.get(firstIndex);
                secondHalfReversedPath.set(firstIndex, secondHalfReversedPath.get(secondIndex));
                secondHalfReversedPath.set(secondIndex, savedFirstItem);
            }
        }
    }

    public String toString() {
        return "FlipSublistAction(entity=" + this.entity + ", from=" + this.fromIndexInclusive + ", to=" + this.toIndexExclusive + ")";
    }
}

