/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptCycle;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptDescriptor;
import org.optaplanner.core.impl.util.Pair;

final class KOptUtils {
    private KOptUtils() {
    }

    static <Solution_, Node_> KOptCycle getCyclesForPermutation(KOptDescriptor<Solution_, Node_> kOptDescriptor) {
        int cycleCount = 0;
        int[] removedEdgeIndexToTourOrder = kOptDescriptor.getRemovedEdgeIndexToTourOrder();
        int[] addedEdgeToOtherEndpoint = kOptDescriptor.getAddedEdgeToOtherEndpoint();
        int[] inverseRemovedEdgeIndexToTourOrder = kOptDescriptor.getInverseRemovedEdgeIndexToTourOrder();
        int[] indexToCycle = new int[removedEdgeIndexToTourOrder.length];
        BitSet remaining = new BitSet(removedEdgeIndexToTourOrder.length);
        remaining.set(1, removedEdgeIndexToTourOrder.length, true);
        while (!remaining.isEmpty()) {
            int currentEndpoint = remaining.nextSetBit(0);
            while (remaining.get(currentEndpoint)) {
                indexToCycle[currentEndpoint] = cycleCount;
                remaining.clear(currentEndpoint);
                int currentEndpointTourIndex = removedEdgeIndexToTourOrder[currentEndpoint];
                int nextEndpointTourIndex = addedEdgeToOtherEndpoint[currentEndpointTourIndex];
                currentEndpoint = inverseRemovedEdgeIndexToTourOrder[nextEndpointTourIndex];
                indexToCycle[currentEndpoint] = cycleCount;
                remaining.clear(currentEndpoint);
                currentEndpoint ^= 1;
            }
            ++cycleCount;
        }
        return new KOptCycle(cycleCount, indexToCycle);
    }

    static <Solution_, Node_> List<Pair<Node_, Node_>> getAddedEdgeList(KOptDescriptor<Solution_, Node_> kOptDescriptor) {
        int k = kOptDescriptor.getK();
        ArrayList<Pair<Node_, Node_>> out = new ArrayList<Pair<Node_, Node_>>(2 * k);
        int currentEndpoint = 1;
        Node_[] removedEdges = kOptDescriptor.getRemovedEdges();
        int[] addedEdgeToOtherEndpoint = kOptDescriptor.getAddedEdgeToOtherEndpoint();
        int[] removedEdgeIndexToTourOrder = kOptDescriptor.getRemovedEdgeIndexToTourOrder();
        int[] inverseRemovedEdgeIndexToTourOrder = kOptDescriptor.getInverseRemovedEdgeIndexToTourOrder();
        while (currentEndpoint != 2 * k + 1) {
            out.add(Pair.of(removedEdges[currentEndpoint], removedEdges[addedEdgeToOtherEndpoint[currentEndpoint]]));
            int tourIndex = removedEdgeIndexToTourOrder[currentEndpoint];
            int nextEndpointTourIndex = addedEdgeToOtherEndpoint[tourIndex];
            currentEndpoint = inverseRemovedEdgeIndexToTourOrder[nextEndpointTourIndex] ^ 1;
        }
        return out;
    }

    static <Solution_, Node_> List<Pair<Node_, Node_>> getRemovedEdgeList(KOptDescriptor<Solution_, Node_> kOptDescriptor) {
        int k = kOptDescriptor.getK();
        Node_[] removedEdges = kOptDescriptor.getRemovedEdges();
        ArrayList<Pair<Node_, Node_>> out = new ArrayList<Pair<Node_, Node_>>(2 * k);
        for (int i = 1; i <= k; ++i) {
            out.add(Pair.of(removedEdges[2 * i - 1], removedEdges[2 * i]));
        }
        return out;
    }

    public static <Solution_, Node_> Function<Node_, Node_> getSuccessorFunction(ListVariableDescriptor<Solution_> listVariableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, IndexVariableSupply indexVariableSupply) {
        return node -> {
            List<Object> valueList = listVariableDescriptor.getListVariable(inverseVariableSupply.getInverseSingleton(node));
            int index = indexVariableSupply.getIndex(node);
            if (index == valueList.size() - 1) {
                return valueList.get(0);
            }
            return valueList.get(index + 1);
        };
    }

    public static <Solution_, Node_> Function<Node_, Node_> getPredecessorFunction(ListVariableDescriptor<Solution_> listVariableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, IndexVariableSupply indexVariableSupply) {
        return node -> {
            List<Object> valueList = listVariableDescriptor.getListVariable(inverseVariableSupply.getInverseSingleton(node));
            int index = indexVariableSupply.getIndex(node);
            if (index == 0) {
                return valueList.get(valueList.size() - 1);
            }
            return valueList.get(index - 1);
        };
    }

    public static <Node_> TriPredicate<Node_, Node_, Node_> getBetweenPredicate(IndexVariableSupply indexVariableSupply) {
        return (start, middle, end) -> {
            int startIndex = indexVariableSupply.getIndex(start);
            int middleIndex = indexVariableSupply.getIndex(middle);
            int endIndex = indexVariableSupply.getIndex(end);
            if (startIndex <= endIndex) {
                return startIndex <= middleIndex && middleIndex <= endIndex;
            }
            return middleIndex >= startIndex || middleIndex <= endIndex;
        };
    }

    public static void flipSubarray(int[] array, int fromIndexInclusive, int toIndexExclusive) {
        if (fromIndexInclusive < toIndexExclusive) {
            int halfwayPoint = toIndexExclusive - fromIndexInclusive >> 1;
            for (int i = 0; i < halfwayPoint; ++i) {
                int saved = array[fromIndexInclusive + i];
                array[fromIndexInclusive + i] = array[toIndexExclusive - i - 1];
                array[toIndexExclusive - i - 1] = saved;
            }
        } else {
            int firstHalfSize = array.length - fromIndexInclusive;
            int secondHalfSize = toIndexExclusive;
            int totalLength = firstHalfSize + secondHalfSize;
            for (int i = 0; i < totalLength >> 1; ++i) {
                int secondHalfIndex;
                int firstHalfIndex;
                if (i < firstHalfSize) {
                    if (i < secondHalfSize) {
                        firstHalfIndex = fromIndexInclusive + i;
                        secondHalfIndex = secondHalfSize - i - 1;
                    } else {
                        firstHalfIndex = fromIndexInclusive + i;
                        secondHalfIndex = array.length - (i - secondHalfSize) - 1;
                    }
                } else {
                    firstHalfIndex = i - firstHalfSize;
                    secondHalfIndex = secondHalfSize - i - 1;
                }
                int saved = array[firstHalfIndex];
                array[firstHalfIndex] = array[secondHalfIndex];
                array[secondHalfIndex] = saved;
            }
        }
    }

    public static long getPureKOptMoveTypes(int k) {
        long totalTypes = 0L;
        for (int i = 1; i < k; ++i) {
            for (int j = 0; j <= i; ++j) {
                int sign = (k + j - 1) % 2 == 0 ? 1 : -1;
                totalTypes += (long)sign * CombinatoricsUtils.binomialCoefficient((int)i, (int)j) * CombinatoricsUtils.factorial((int)j) * (1L << j);
            }
        }
        return totalTypes;
    }
}

