/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.mimic;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.ValueMimicRecorder;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;

public class MimicReplayingValueSelector<Solution_>
extends AbstractValueSelector<Solution_>
implements EntityIndependentValueSelector<Solution_> {
    protected final ValueMimicRecorder<Solution_> valueMimicRecorder;
    protected boolean hasRecordingCreated;
    protected boolean hasRecording;
    protected boolean recordingCreated;
    protected Object recording;
    protected boolean recordingAlreadyReturned;

    public MimicReplayingValueSelector(ValueMimicRecorder<Solution_> valueMimicRecorder) {
        this.valueMimicRecorder = valueMimicRecorder;
        valueMimicRecorder.addMimicReplayingValueSelector(this);
        if (!valueMimicRecorder.getVariableDescriptor().isValueRangeEntityIndependent()) {
            throw new IllegalArgumentException("The current implementation support only an entityIndependent variable (" + valueMimicRecorder.getVariableDescriptor() + ").");
        }
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.hasRecordingCreated = false;
        this.recordingCreated = false;
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.hasRecordingCreated = false;
        this.hasRecording = false;
        this.recordingCreated = false;
        this.recording = null;
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.valueMimicRecorder.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.valueMimicRecorder.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.valueMimicRecorder.isNeverEnding();
    }

    @Override
    public long getSize(Object entity) {
        return this.valueMimicRecorder.getSize(entity);
    }

    @Override
    public long getSize() {
        return this.valueMimicRecorder.getSize();
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return new ReplayingValueIterator();
    }

    @Override
    public Iterator<Object> iterator() {
        return new ReplayingValueIterator();
    }

    public void recordedHasNext(boolean hasNext) {
        this.hasRecordingCreated = true;
        this.hasRecording = hasNext;
        this.recordingCreated = false;
        this.recording = null;
        this.recordingAlreadyReturned = false;
    }

    public void recordedNext(Object next) {
        this.hasRecordingCreated = true;
        this.hasRecording = true;
        this.recordingCreated = true;
        this.recording = next;
        this.recordingAlreadyReturned = false;
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return this.valueMimicRecorder.endingIterator(entity);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MimicReplayingValueSelector that = (MimicReplayingValueSelector)other;
        return Objects.equals(this.valueMimicRecorder, that.valueMimicRecorder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.valueMimicRecorder);
    }

    public String toString() {
        return "Replaying(" + this.valueMimicRecorder + ")";
    }

    private class ReplayingValueIterator
    extends SelectionIterator<Object> {
        private ReplayingValueIterator() {
            MimicReplayingValueSelector.this.recordingAlreadyReturned = false;
        }

        @Override
        public boolean hasNext() {
            if (!MimicReplayingValueSelector.this.hasRecordingCreated) {
                throw new IllegalStateException("Replay must occur after record. The recordingValueSelector (" + MimicReplayingValueSelector.this.valueMimicRecorder + ")'s hasNext() has not been called yet. ");
            }
            return MimicReplayingValueSelector.this.hasRecording && !MimicReplayingValueSelector.this.recordingAlreadyReturned;
        }

        @Override
        public Object next() {
            if (!MimicReplayingValueSelector.this.recordingCreated) {
                throw new IllegalStateException("Replay must occur after record. The recordingValueSelector (" + MimicReplayingValueSelector.this.valueMimicRecorder + ")'s next() has not been called yet. ");
            }
            if (MimicReplayingValueSelector.this.recordingAlreadyReturned) {
                throw new NoSuchElementException("The recordingAlreadyReturned (" + MimicReplayingValueSelector.this.recordingAlreadyReturned + ") is impossible. Check if hasNext() returns true before this call.");
            }
            MimicReplayingValueSelector.this.recordingAlreadyReturned = true;
            return MimicReplayingValueSelector.this.recording;
        }

        public String toString() {
            if (MimicReplayingValueSelector.this.hasRecordingCreated && !MimicReplayingValueSelector.this.hasRecording) {
                return "No next replay";
            }
            return "Next replay (" + (MimicReplayingValueSelector.this.recordingCreated ? MimicReplayingValueSelector.this.recording : "?") + ")";
        }
    }
}

