/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import org.optaplanner.constraint.streams.bavet.common.AbstractJoinNode;
import org.optaplanner.constraint.streams.bavet.common.LeftTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.RightTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleList;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleListEntry;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public abstract class AbstractUnindexedJoinNode<LeftTuple_ extends Tuple, Right_, OutTuple_ extends Tuple, MutableOutTuple_ extends OutTuple_>
extends AbstractJoinNode<LeftTuple_, Right_, OutTuple_, MutableOutTuple_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final int inputStoreIndexLeftEntry;
    private final int inputStoreIndexRightEntry;
    private final TupleList<LeftTuple_> leftTupleList = new TupleList();
    private final TupleList<UniTuple<Right_>> rightTupleList = new TupleList();

    protected AbstractUnindexedJoinNode(int inputStoreIndexLeftEntry, int inputStoreIndexLeftOutTupleList, int inputStoreIndexRightEntry, int inputStoreIndexRightOutTupleList, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, boolean isFiltering, int outputStoreIndexLeftOutEntry, int outputStoreIndexRightOutEntry) {
        super(inputStoreIndexLeftOutTupleList, inputStoreIndexRightOutTupleList, nextNodesTupleLifecycle, isFiltering, outputStoreIndexLeftOutEntry, outputStoreIndexRightOutEntry);
        this.inputStoreIndexLeftEntry = inputStoreIndexLeftEntry;
        this.inputStoreIndexRightEntry = inputStoreIndexRightEntry;
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (leftTuple.getStore(this.inputStoreIndexLeftEntry) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + leftTuple + ") was already added in the tupleStore.");
        }
        TupleListEntry<LeftTuple_> leftEntry = this.leftTupleList.add(leftTuple);
        leftTuple.setStore(this.inputStoreIndexLeftEntry, leftEntry);
        TupleList outTupleListLeft = new TupleList();
        leftTuple.setStore(this.inputStoreIndexLeftOutTupleList, outTupleListLeft);
        this.rightTupleList.forEach(rightTuple -> this.insertOutTupleFiltered(leftTuple, rightTuple));
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        TupleListEntry leftEntry = (TupleListEntry)leftTuple.getStore(this.inputStoreIndexLeftEntry);
        if (leftEntry == null) {
            this.insertLeft(leftTuple);
            return;
        }
        this.innerUpdateLeft(leftTuple, this.rightTupleList::forEach);
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        TupleListEntry leftEntry = (TupleListEntry)leftTuple.removeStore(this.inputStoreIndexLeftEntry);
        if (leftEntry == null) {
            return;
        }
        TupleList outTupleListLeft = (TupleList)leftTuple.removeStore(this.inputStoreIndexLeftOutTupleList);
        leftEntry.remove();
        outTupleListLeft.forEach(this::retractOutTuple);
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRightEntry) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + rightTuple + ") was already added in the tupleStore.");
        }
        TupleListEntry<UniTuple<Right_>> rightEntry = this.rightTupleList.add(rightTuple);
        rightTuple.setStore(this.inputStoreIndexRightEntry, rightEntry);
        TupleList outTupleListRight = new TupleList();
        rightTuple.setStore(this.inputStoreIndexRightOutTupleList, outTupleListRight);
        this.leftTupleList.forEach(leftTuple -> this.insertOutTupleFiltered(leftTuple, rightTuple));
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        TupleListEntry rightEntry = (TupleListEntry)rightTuple.getStore(this.inputStoreIndexRightEntry);
        if (rightEntry == null) {
            this.insertRight(rightTuple);
            return;
        }
        this.innerUpdateRight(rightTuple, this.leftTupleList::forEach);
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        TupleListEntry rightEntry = (TupleListEntry)rightTuple.removeStore(this.inputStoreIndexRightEntry);
        if (rightEntry == null) {
            return;
        }
        TupleList outTupleListRight = (TupleList)rightTuple.removeStore(this.inputStoreIndexRightOutTupleList);
        rightEntry.remove();
        outTupleListRight.forEach(this::retractOutTuple);
    }
}

